/// -*- Mode: C++ -*-
/// This file has been automatically generated.

/// Declarations
uint32 rVTCTRL {0U};
uint32 rSTATUS {81U};
uint32 rVTEICR {0U};
uint32 rVTEIMS {0U};
uint32 rVTEIAC {0U};
uint32 rVTEIAM {0U};
uint32 rVMMB {80U};
uint32 rVTIVAR {0U};
uint32 rVTIVAR_MISC {0U};
uint32 rVTEITR0 {0U};
uint32 rVTEITR1 {0U};
uint32 rVTEITR2 {0U};
uint32 rVFMBX0 {0U};
uint32 rVFMBX1 {0U};
uint32 rVFMBX2 {0U};
uint32 rVFMBX3 {0U};
uint32 rVFMBX4 {0U};
uint32 rVFMBX5 {0U};
uint32 rVFMBX6 {0U};
uint32 rVFMBX7 {0U};
uint32 rVFMBX8 {0U};
uint32 rVFMBX9 {0U};
uint32 rVFMBX10 {0U};
uint32 rVFMBX11 {0U};
uint32 rVFMBX12 {0U};
uint32 rVFMBX13 {0U};
uint32 rVFMBX14 {0U};
uint32 rVFMBX15 {0U};

void MMIO_init()
{
	rVTCTRL = 0x0U;
	rSTATUS = 0x81U;
	rVTEICR = 0x0U;
	rVTEIMS = 0x0U;
	rVTEIAC = 0x0U;
	rVTEIAM = 0x0U;
	rVMMB = 0x80U;
	rVTIVAR = 0x0U;
	rVTIVAR_MISC = 0x0U;
	rVTEITR0 = 0x0U;
	rVTEITR1 = 0x0U;
	rVTEITR2 = 0x0U;
	rVFMBX0 = 0x0U;
	rVFMBX1 = 0x0U;
	rVFMBX2 = 0x0U;
	rVFMBX3 = 0x0U;
	rVFMBX4 = 0x0U;
	rVFMBX5 = 0x0U;
	rVFMBX6 = 0x0U;
	rVFMBX7 = 0x0U;
	rVFMBX8 = 0x0U;
	rVFMBX9 = 0x0U;
	rVFMBX10 = 0x0U;
	rVFMBX11 = 0x0U;
	rVFMBX12 = 0x0U;
	rVFMBX13 = 0x0U;
	rVFMBX14 = 0x0U;
	rVFMBX15 = 0x0U;
}

/// Dispatch

void MMIO_write(uintptr_t offset, uint32 value)
{
	switch (offset/4) {
	case 0x549: rVTEIMS_write(value); break;
	case 0x0: rVTCTRL_write(value); break;
	case 0x560: rVTEICR_write(value); break;
	case 0x548: rVTEICS_write(value); break;
	case 0x54a: rVTEIMC_write(value); break;
	case 0x54b: rVTEIAC_write(value); break;
	case 0x54c: rVTEIAM_write(value); break;
	case 0x310: rVMMB_write(value); break;
	case 0x5c0: rVTIVAR_write(value); break;
	case 0x5d0: rVTIVAR_MISC_write(value); break;
	case 0x5a0: rVTEITR0_write(value); break;
	case 0x5a1: rVTEITR1_write(value); break;
	case 0x5a2: rVTEITR2_write(value); break;
	case 0x200: rVFMBX0_write(value); break;
	case 0x201: rVFMBX1_write(value); break;
	case 0x202: rVFMBX2_write(value); break;
	case 0x203: rVFMBX3_write(value); break;
	case 0x204: rVFMBX4_write(value); break;
	case 0x205: rVFMBX5_write(value); break;
	case 0x206: rVFMBX6_write(value); break;
	case 0x207: rVFMBX7_write(value); break;
	case 0x208: rVFMBX8_write(value); break;
	case 0x209: rVFMBX9_write(value); break;
	case 0x20a: rVFMBX10_write(value); break;
	case 0x20b: rVFMBX11_write(value); break;
	case 0x20c: rVFMBX12_write(value); break;
	case 0x20d: rVFMBX13_write(value); break;
	case 0x20e: rVFMBX14_write(value); break;
	case 0x20f: rVFMBX15_write(value); break;
	default: /* Logging::printf("--> %s UNKNOWN %x\n", __PRETTY_FUNCTION__, offset);*/ /* UNDEFINED! */ break;
	}
}

uint32 MMIO_read(uintptr_t offset)
{
	uint32 val;
	switch (offset/4) {
	case 0x549: val = rVTEIMS_read(); break;
	case 0x0: val = rVTCTRL_read(); break;
	case 0x2: val = rSTATUS_read(); break;
	case 0x412: val = rVTFRTIMER_read(); break;
	case 0x560: val = rVTEICR_read(); break;
	case 0x54b: val = rVTEIAC_read(); break;
	case 0x54c: val = rVTEIAM_read(); break;
	case 0x310: val = rVMMB_read(); break;
	case 0x5c0: val = rVTIVAR_read(); break;
	case 0x5d0: val = rVTIVAR_MISC_read(); break;
	case 0x5a0: val = rVTEITR0_read(); break;
	case 0x5a1: val = rVTEITR1_read(); break;
	case 0x5a2: val = rVTEITR2_read(); break;
	case 0x200: val = rVFMBX0_read(); break;
	case 0x201: val = rVFMBX1_read(); break;
	case 0x202: val = rVFMBX2_read(); break;
	case 0x203: val = rVFMBX3_read(); break;
	case 0x204: val = rVFMBX4_read(); break;
	case 0x205: val = rVFMBX5_read(); break;
	case 0x206: val = rVFMBX6_read(); break;
	case 0x207: val = rVFMBX7_read(); break;
	case 0x208: val = rVFMBX8_read(); break;
	case 0x209: val = rVFMBX9_read(); break;
	case 0x20a: val = rVFMBX10_read(); break;
	case 0x20b: val = rVFMBX11_read(); break;
	case 0x20c: val = rVFMBX12_read(); break;
	case 0x20d: val = rVFMBX13_read(); break;
	case 0x20e: val = rVFMBX14_read(); break;
	case 0x20f: val = rVFMBX15_read(); break;
	default: /* Logging::printf("--> %s UNKNOWN %x\n", __PRETTY_FUNCTION__, offset);*/ val = 0; /* UNDEFINED! */ break;
	}
	return val;
}

/// Readers

uint32 rVTCTRL_read()
{
	uint32 val = rVTCTRL;
	return val;
}

uint32 rSTATUS_read()
{
	uint32 val = rSTATUS;
	return val;
}

uint32 rVTFRTIMER_read()
{
	uint32 val = VTFRTIMER_compute();
	return val;
}

uint32 rVTEICR_read()
{
	uint32 val = rVTEICR;
	rVTEICR &= ~0xffffffff;	// RC
	return val;
}

uint32 rVTEIMS_read()
{
	uint32 val = rVTEIMS;
	return val;
}

uint32 rVTEIAC_read()
{
	uint32 val = rVTEIAC;
	return val;
}

uint32 rVTEIAM_read()
{
	uint32 val = rVTEIAM;
	return val;
}

uint32 rVMMB_read()
{
	uint32 val = rVMMB;
	rVMMB &= ~0xb0;	// RC
	return val;
}

uint32 rVTIVAR_read()
{
	uint32 val = rVTIVAR;
	return val;
}

uint32 rVTIVAR_MISC_read()
{
	uint32 val = rVTIVAR_MISC;
	return val;
}

uint32 rVTEITR0_read()
{
	uint32 val = rVTEITR0;
	return val;
}

uint32 rVTEITR1_read()
{
	uint32 val = rVTEITR1;
	return val;
}

uint32 rVTEITR2_read()
{
	uint32 val = rVTEITR2;
	return val;
}

uint32 rVFMBX0_read()
{
	uint32 val = rVFMBX0;
	return val;
}

uint32 rVFMBX1_read()
{
	uint32 val = rVFMBX1;
	return val;
}

uint32 rVFMBX2_read()
{
	uint32 val = rVFMBX2;
	return val;
}

uint32 rVFMBX3_read()
{
	uint32 val = rVFMBX3;
	return val;
}

uint32 rVFMBX4_read()
{
	uint32 val = rVFMBX4;
	return val;
}

uint32 rVFMBX5_read()
{
	uint32 val = rVFMBX5;
	return val;
}

uint32 rVFMBX6_read()
{
	uint32 val = rVFMBX6;
	return val;
}

uint32 rVFMBX7_read()
{
	uint32 val = rVFMBX7;
	return val;
}

uint32 rVFMBX8_read()
{
	uint32 val = rVFMBX8;
	return val;
}

uint32 rVFMBX9_read()
{
	uint32 val = rVFMBX9;
	return val;
}

uint32 rVFMBX10_read()
{
	uint32 val = rVFMBX10;
	return val;
}

uint32 rVFMBX11_read()
{
	uint32 val = rVFMBX11;
	return val;
}

uint32 rVFMBX12_read()
{
	uint32 val = rVFMBX12;
	return val;
}

uint32 rVFMBX13_read()
{
	uint32 val = rVFMBX13;
	return val;
}

uint32 rVFMBX14_read()
{
	uint32 val = rVFMBX14;
	return val;
}

uint32 rVFMBX15_read()
{
	uint32 val = rVFMBX15;
	return val;
}

/// Writers

void rVTCTRL_write(uint32 val)
{
	uint32 nv;
	uint32 old = rVTCTRL;
	nv = val;
	rVTCTRL = nv;
	VTCTRL_cb(old, val);
}

void rVTEICR_write(uint32 val)
{
	uint32 nv;
	nv = rVTEICR & ~val;	// W1C
	rVTEICR = nv;
}

void rVTEICS_write(uint32 val)
{
	uint32 nv;
	uint32 old = rVTEICR;
	nv = rVTEICR | val;	// W1S
	rVTEICR = nv;
	VTEICS_cb(old, val);
}

void rVTEIMS_write(uint32 val)
{
	uint32 nv;
	nv = rVTEIMS | val;	// W1S
	rVTEIMS = nv;
}

void rVTEIMC_write(uint32 val)
{
	uint32 nv;
	nv = rVTEIMS & ~val;	// W1C
	rVTEIMS = nv;
}

void rVTEIAC_write(uint32 val)
{
	uint32 nv;
	nv = val;
	rVTEIAC = nv;
}

void rVTEIAM_write(uint32 val)
{
	uint32 nv;
	nv = val;
	rVTEIAM = nv;
}

void rVMMB_write(uint32 val)
{
	uint32 nv;
	uint32 old = rVMMB;
	nv = val;
	nv = (rVMMB & ~0xfffffffcU) | (nv & 0xfffffffcU);
	rVMMB = nv;
	VMMB_cb(old, val);
}

void rVTIVAR_write(uint32 val)
{
	uint32 nv;
	nv = val;
	nv = (rVTIVAR & ~0x83838383U) | (nv & 0x83838383U);
	rVTIVAR = nv;
}

void rVTIVAR_MISC_write(uint32 val)
{
	uint32 nv;
	nv = val;
	nv = (rVTIVAR_MISC & ~0x83U) | (nv & 0x83U);
	rVTIVAR_MISC = nv;
}

void rVTEITR0_write(uint32 val)
{
	uint32 nv;
	uint32 old = rVTEITR0;
	nv = val;
	rVTEITR0 = nv;
	VTEITR_cb(old, val);
}

void rVTEITR1_write(uint32 val)
{
	uint32 nv;
	uint32 old = rVTEITR1;
	nv = val;
	rVTEITR1 = nv;
	VTEITR_cb(old, val);
}

void rVTEITR2_write(uint32 val)
{
	uint32 nv;
	uint32 old = rVTEITR2;
	nv = val;
	rVTEITR2 = nv;
	VTEITR_cb(old, val);
}

void rVFMBX0_write(uint32 val)
{
	uint32 nv;
	nv = val;
	rVFMBX0 = nv;
}

void rVFMBX1_write(uint32 val)
{
	uint32 nv;
	nv = val;
	rVFMBX1 = nv;
}

void rVFMBX2_write(uint32 val)
{
	uint32 nv;
	nv = val;
	rVFMBX2 = nv;
}

void rVFMBX3_write(uint32 val)
{
	uint32 nv;
	nv = val;
	rVFMBX3 = nv;
}

void rVFMBX4_write(uint32 val)
{
	uint32 nv;
	nv = val;
	rVFMBX4 = nv;
}

void rVFMBX5_write(uint32 val)
{
	uint32 nv;
	nv = val;
	rVFMBX5 = nv;
}

void rVFMBX6_write(uint32 val)
{
	uint32 nv;
	nv = val;
	rVFMBX6 = nv;
}

void rVFMBX7_write(uint32 val)
{
	uint32 nv;
	nv = val;
	rVFMBX7 = nv;
}

void rVFMBX8_write(uint32 val)
{
	uint32 nv;
	nv = val;
	rVFMBX8 = nv;
}

void rVFMBX9_write(uint32 val)
{
	uint32 nv;
	nv = val;
	rVFMBX9 = nv;
}

void rVFMBX10_write(uint32 val)
{
	uint32 nv;
	nv = val;
	rVFMBX10 = nv;
}

void rVFMBX11_write(uint32 val)
{
	uint32 nv;
	nv = val;
	rVFMBX11 = nv;
}

void rVFMBX12_write(uint32 val)
{
	uint32 nv;
	nv = val;
	rVFMBX12 = nv;
}

void rVFMBX13_write(uint32 val)
{
	uint32 nv;
	nv = val;
	rVFMBX13 = nv;
}

void rVFMBX14_write(uint32 val)
{
	uint32 nv;
	nv = val;
	rVFMBX14 = nv;
}

void rVFMBX15_write(uint32 val)
{
	uint32 nv;
	nv = val;
	rVFMBX15 = nv;
}

/// Done
