/// -*- Mode: C++ -*-
/// This file has been automatically generated.

/// Declarations
uint32 rPCISTSCTRL {100000U};
uint32 rPCIBAR0 {0U};
uint32 rPCIBAR3 {0U};
uint32 rPCIMSIX0 {20011U};

void PCI_init()
{
	rPCISTSCTRL = 0x100000U;
	rPCIBAR0 = 0x0U;
	rPCIBAR3 = 0x0U;
	rPCIMSIX0 = 0x20011U;
}

/// Dispatch

void PCI_write(uintptr_t offset, uint32 value)
{
	switch (offset/4) {
	case 0x1: rPCISTSCTRL_write(value); break;
	case 0x4: rPCIBAR0_write(value); break;
	case 0x7: rPCIBAR3_write(value); break;
	case 0x1c: rPCIMSIX0_write(value); break;
	default: /* Logging::printf("--> %s UNKNOWN %x\n", __PRETTY_FUNCTION__, offset);*/ /* UNDEFINED! */ break;
	}
}

uint32 PCI_read(uintptr_t offset)
{
	uint32 val;
	switch (offset/4) {
	case 0x0: val = rPCIID_read(); break;
	case 0x1: val = rPCISTSCTRL_read(); break;
	case 0x2: val = rPCICCRVID_read(); break;
	case 0x3: val = rBIST_read(); break;
	case 0x4: val = rPCIBAR0_read(); break;
	case 0x7: val = rPCIBAR3_read(); break;
	case 0xb: val = rPCISUBSYS_read(); break;
	case 0xd: val = rPCICAPPTR_read(); break;
	case 0x1c: val = rPCIMSIX0_read(); break;
	case 0x1d: val = rPCIMSIXTBA_read(); break;
	case 0x1e: val = rPCIMSIXPBA_read(); break;
	default: /* Logging::printf("--> %s UNKNOWN %x\n", __PRETTY_FUNCTION__, offset);*/ val = 0; /* UNDEFINED! */ break;
	}
	return val;
}

/// Readers

uint32 rPCIID_read()
{
	uint32 val = 0x10ca8086U;
	return val;
}

uint32 rPCISTSCTRL_read()
{
	uint32 val = rPCISTSCTRL;
	return val;
}

uint32 rPCICCRVID_read()
{
	uint32 val = 0x2000001U;
	return val;
}

uint32 rBIST_read()
{
	uint32 val = 0x0U;
	return val;
}

uint32 rPCIBAR0_read()
{
	uint32 val = rPCIBAR0;
	return val;
}

uint32 rPCIBAR3_read()
{
	uint32 val = rPCIBAR3;
	return val;
}

uint32 rPCISUBSYS_read()
{
	uint32 val = 0x8086U;
	return val;
}

uint32 rPCICAPPTR_read()
{
	uint32 val = 0x70U;
	return val;
}

uint32 rPCIMSIX0_read()
{
	uint32 val = rPCIMSIX0;
	return val;
}

uint32 rPCIMSIXTBA_read()
{
	uint32 val = 0x3U;
	return val;
}

uint32 rPCIMSIXPBA_read()
{
	uint32 val = 0x183U;
	return val;
}

/// Writers

void rPCISTSCTRL_write(uint32 val)
{
	uint32 nv;
	nv = val;
	nv = (rPCISTSCTRL & ~0x6U) | (nv & 0x6U);
	rPCISTSCTRL = nv;
}

void rPCIBAR0_write(uint32 val)
{
	uint32 nv;
	nv = val;
	nv = (rPCIBAR0 & ~0xffffc000U) | (nv & 0xffffc000U);
	rPCIBAR0 = nv;
}

void rPCIBAR3_write(uint32 val)
{
	uint32 nv;
	nv = val;
	nv = (rPCIBAR3 & ~0xfffff000U) | (nv & 0xfffff000U);
	rPCIBAR3 = nv;
}

void rPCIMSIX0_write(uint32 val)
{
	uint32 nv;
	nv = val;
	nv = (rPCIMSIX0 & ~0xc000U) | (nv & 0xc000U);
	rPCIMSIX0 = nv;
}

/// Done
