#
# Sample makefile for bash loadable builtin development
#
# Copyright (C) 2015-2022 Free Software Foundation, Inc.     

#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

PACKAGE = bash
VERSION = 5.3-release

PACKAGE_NAME = bash
PACKAGE_VERSION = 5.3-release

# Include some boilerplate Gnu makefile definitions.
prefix = /

exec_prefix = ${prefix}
bindir = ${exec_prefix}/bin
libdir = ${exec_prefix}/lib
infodir = ${datarootdir}/info
includedir = ${prefix}/include

datarootdir = ${prefix}/share

loadablesdir = ${libdir}/bash
headersdir = $(includedir)/$(PACKAGE_NAME)

topdir = /home/jws/develop/sculpt-25.10-staging/depot/cnuke/src/bash/2025-10-30/src/noux-pkg/bash
BUILD_DIR = /home/jws/develop/sculpt-25.10-staging/depot/cnuke/bin/x86_64/bash/2025-10-30.build/noux-pkg/bash
srcdir = /home/jws/develop/sculpt-25.10-staging/depot/cnuke/src/bash/2025-10-30/src/noux-pkg/bash/examples/loadables
VPATH = /home/jws/develop/sculpt-25.10-staging/depot/cnuke/src/bash/2025-10-30/src/noux-pkg/bash/examples/loadables

# Support an alternate destination root directory for package building
DESTDIR =

INSTALL = /usr/bin/install -c
INSTALL_PROGRAM = ${INSTALL}
INSTALL_SCRIPT = ${INSTALL}
INSTALL_DATA = ${INSTALL} -m 644
INSTALLMODE= -m 0755


CC = /usr/local/genode/tool/25.05/bin/genode-x86-gcc
RM = rm -f

SHELL = /bin/sh

host_os = elf
host_cpu = x86_64
host_vendor = pc

CFLAGS = -Dsh_xfree=free -DNO_MAIN_ENV_ARG=1 -DNO_TTY_DRIVER -fcommon -ffunction-sections -O2 -m64 -mcmodel=large -march=x86-64-v2 -g
LOCAL_CFLAGS = 
DEFS = -DHAVE_CONFIG_H
LOCAL_DEFS = -DSHELL

CPPFLAGS = -nostdinc -I. -I/home/jws/develop/sculpt-25.10-staging/depot/cnuke/api/libc/2025-10-27/include/libc -I/home/jws/develop/sculpt-25.10-staging/depot/cnuke/api/libc/2025-10-27/include/spec/x86_64/libc -I/home/jws/develop/sculpt-25.10-staging/depot/cnuke/api/libc/2025-10-27/include/spec/x86/libc -I/home/jws/develop/sculpt-25.10-staging/depot/cnuke/api/libc/2025-10-27/include/libc-genode -I/home/jws/develop/sculpt-25.10-staging/depot/cnuke/api/libc/2025-10-27/include/spec/x86 -I/home/jws/develop/sculpt-25.10-staging/depot/cnuke/api/libc/2025-10-27/include/spec/x86_64 -I/home/jws/develop/sculpt-25.10-staging/depot/cnuke/api/libc/2025-10-27/include -I/usr/local/genode/tool/25.05/bin/../lib/gcc/x86_64-pc-elf/14.2.0/include -D_GNU_SOURCE=1 -fPIC

BASHINCDIR = ${topdir}/include

SUPPORT_SRC = $(topdir)/support/

LIBBUILD = ${BUILD_DIR}/lib

INTL_LIBSRC = ${topdir}/lib/intl
INTL_BUILDDIR = ${LIBBUILD}/intl
INTL_INC = 
LIBINTL_H = 

CCFLAGS = $(DEFS) $(LOCAL_DEFS) $(LOCAL_CFLAGS) $(CFLAGS)

#
# These values are generated for configure by ${topdir}/support/shobj-conf.
# If your system is not supported by that script, but includes facilities for
# dynamic loading of shared objects, please update the script and send the
# changes to bash-maintainers@gnu.org.
#
SHOBJ_CC = /usr/local/genode/tool/25.05/bin/genode-x86-gcc
SHOBJ_CFLAGS = -fpic
SHOBJ_LD = ${CC}
SHOBJ_LDFLAGS = -shared -nostdlib -Wl,-melf_x86_64 -Wl,-gc-sections -Wl,-z -Wl,max-page-size=0x1000 -Wl,-z -Wl,noexecstack -Wl,--hash-style=sysv -Wl,--dynamic-list=/home/jws/develop/sculpt-25.10-staging/repos/base/src/ld/genode_dyn.dl -nostdlib -Wl,-nostdlib -Wl,-Ttext=0x01000000 -m64 -mcmodel=large -march=x86-64-v2 -m64 -mcmodel=large -march=x86-64-v2 -Wl,-T/home/jws/develop/sculpt-25.10-staging/repos/base/src/ld/genode_dyn.ld -Wl,-rpath-link=/home/jws/develop/sculpt-25.10-staging/depot/cnuke/bin/x86_64/bash/2025-10-30.build/noux-pkg/bash -Wl,--dynamic-linker=ld.lib.so -Wl,--eh-frame-hdr -L./lib/termcap
SHOBJ_XLDFLAGS = 
SHOBJ_LIBS = 
SHOBJ_STATUS = supported

INC = -I$(headersdir) -I$(headersdir)/include -I$(headersdir)/builtins

.c.o:
	$(SHOBJ_CC) $(SHOBJ_CFLAGS) $(CCFLAGS) $(INC) -c -o $@ $<
