/*
 * \brief  Implementation of driver specific Linux functions
 * \author Sebastian Sumpf
 * \date   2023-06-29
 */

/*
 * Copyright (C) 2023 Genode Labs GmbH
 *
 * This file is distributed under the terms of the GNU General Public License
 * version 2 or later.
 */

#include <lx_emul.h>

#include <linux/cdev.h>
#include <linux/device.h>
#include <linux/sysfs.h>
#include <linux/usb.h>

#include <usb_hid.h>

const struct attribute_group input_poller_attribute_group;
pteval_t __default_kernel_pte_mask __read_mostly = ~0;

struct usb_driver usbfs_driver = {
	.name = "usbfs"
};

#include <linux/percpu.h>

DEFINE_PER_CPU(unsigned long, cpu_scale);

const struct attribute_group *usb_device_groups[] = { };

void lx_emul_usb_client_device_unregister_callback(struct usb_device *udev) { }


#ifdef __i386__
#include <asm/fixmap.h>
unsigned long __FIXADDR_TOP = 0xfffff000;
#endif
