// ##### ENDFILE "ProgressWrap.cpp"


// ##### BEGINFILE "SnapshotWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for ISnapshot.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_SNAPSHOT

#include "SnapshotWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(SnapshotWrap)

//
// ISnapshot properties
//

STDMETHODIMP SnapshotWrap::COMGETTER(Id)(BSTR *aId)
{
    LogRelFlow(("{%p} %s: enter aId=%p\n", this, "Snapshot::getId", aId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aId);
        UuidOutConverter TmpId(aId);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_ID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getId(TmpId.uuid());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_ID_RETURN(this, hrc, 0 /*normal*/,TmpId.uuid().toStringCurly().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_ID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_ID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aId=%ls hrc=%Rhrc\n", this, "Snapshot::getId", *aId, hrc));
    return hrc;
}

STDMETHODIMP SnapshotWrap::COMGETTER(Name)(BSTR *aName)
{
    LogRelFlow(("{%p} %s: enter aName=%p\n", this, "Snapshot::getName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aName);
        BSTROutConverter TmpName(aName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_NAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aName=%ls hrc=%Rhrc\n", this, "Snapshot::getName", *aName, hrc));
    return hrc;
}

STDMETHODIMP SnapshotWrap::COMSETTER(Name)(IN_BSTR aName)
{
    LogRelFlow(("{%p} %s: enter aName=%ls\n", this, "Snapshot::setName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpName(aName);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_SET_NAME_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_SET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_SET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_SET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Snapshot::setName", hrc));
    return hrc;
}

STDMETHODIMP SnapshotWrap::COMGETTER(Description)(BSTR *aDescription)
{
    LogRelFlow(("{%p} %s: enter aDescription=%p\n", this, "Snapshot::getDescription", aDescription));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDescription);
        BSTROutConverter TmpDescription(aDescription);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_DESCRIPTION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDescription(TmpDescription.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_DESCRIPTION_RETURN(this, hrc, 0 /*normal*/,TmpDescription.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_DESCRIPTION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_DESCRIPTION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDescription=%ls hrc=%Rhrc\n", this, "Snapshot::getDescription", *aDescription, hrc));
    return hrc;
}

STDMETHODIMP SnapshotWrap::COMSETTER(Description)(IN_BSTR aDescription)
{
    LogRelFlow(("{%p} %s: enter aDescription=%ls\n", this, "Snapshot::setDescription", aDescription));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpDescription(aDescription);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_SET_DESCRIPTION_ENTER(this, TmpDescription.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setDescription(TmpDescription.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_SET_DESCRIPTION_RETURN(this, hrc, 0 /*normal*/,TmpDescription.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_SET_DESCRIPTION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_SET_DESCRIPTION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Snapshot::setDescription", hrc));
    return hrc;
}

STDMETHODIMP SnapshotWrap::COMGETTER(TimeStamp)(LONG64 *aTimeStamp)
{
    LogRelFlow(("{%p} %s: enter aTimeStamp=%p\n", this, "Snapshot::getTimeStamp", aTimeStamp));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aTimeStamp);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_TIMESTAMP_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getTimeStamp(aTimeStamp);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_TIMESTAMP_RETURN(this, hrc, 0 /*normal*/,*aTimeStamp);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_TIMESTAMP_RETURN(this, hrc, 1 /*hrc exception*/,*aTimeStamp);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_TIMESTAMP_RETURN(this, hrc, 9 /*unhandled exception*/,*aTimeStamp);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aTimeStamp=%RI64 hrc=%Rhrc\n", this, "Snapshot::getTimeStamp", *aTimeStamp, hrc));
    return hrc;
}

STDMETHODIMP SnapshotWrap::COMGETTER(Online)(BOOL *aOnline)
{
    LogRelFlow(("{%p} %s: enter aOnline=%p\n", this, "Snapshot::getOnline", aOnline));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aOnline);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_ONLINE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getOnline(aOnline);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_ONLINE_RETURN(this, hrc, 0 /*normal*/,*aOnline != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_ONLINE_RETURN(this, hrc, 1 /*hrc exception*/,*aOnline != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_ONLINE_RETURN(this, hrc, 9 /*unhandled exception*/,*aOnline != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aOnline=%RTbool hrc=%Rhrc\n", this, "Snapshot::getOnline", *aOnline, hrc));
    return hrc;
}

STDMETHODIMP SnapshotWrap::COMGETTER(Machine)(IMachine **aMachine)
{
    LogRelFlow(("{%p} %s: enter aMachine=%p\n", this, "Snapshot::getMachine", aMachine));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMachine);
        ComTypeOutConverter<IMachine> TmpMachine(aMachine);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_MACHINE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMachine(TmpMachine.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_MACHINE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpMachine.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_MACHINE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_MACHINE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMachine=%p hrc=%Rhrc\n", this, "Snapshot::getMachine", *aMachine, hrc));
    return hrc;
}

STDMETHODIMP SnapshotWrap::COMGETTER(Parent)(ISnapshot **aParent)
{
    LogRelFlow(("{%p} %s: enter aParent=%p\n", this, "Snapshot::getParent", aParent));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aParent);
        ComTypeOutConverter<ISnapshot> TmpParent(aParent);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_PARENT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getParent(TmpParent.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_PARENT_RETURN(this, hrc, 0 /*normal*/,(void *)TmpParent.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_PARENT_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_PARENT_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aParent=%p hrc=%Rhrc\n", this, "Snapshot::getParent", *aParent, hrc));
    return hrc;
}

STDMETHODIMP SnapshotWrap::COMGETTER(Children)(ComSafeArrayOut(ISnapshot *, aChildren))
{
    LogRelFlow(("{%p} %s: enter aChildren=%p\n", this, "Snapshot::getChildren", aChildren));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aChildren);
        ArrayComTypeOutConverter<ISnapshot> TmpChildren(ComSafeArrayOutArg(aChildren));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_CHILDREN_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getChildren(TmpChildren.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_CHILDREN_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpChildren.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_CHILDREN_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_CHILDREN_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aChildren=%zu hrc=%Rhrc\n", this, "Snapshot::getChildren", ComSafeArraySize(*aChildren), hrc));
    return hrc;
}

STDMETHODIMP SnapshotWrap::COMGETTER(ChildrenCount)(ULONG *aChildrenCount)
{
    LogRelFlow(("{%p} %s: enter aChildrenCount=%p\n", this, "Snapshot::getChildrenCount", aChildrenCount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aChildrenCount);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_CHILDRENCOUNT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getChildrenCount(aChildrenCount);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_CHILDRENCOUNT_RETURN(this, hrc, 0 /*normal*/,*aChildrenCount);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_CHILDRENCOUNT_RETURN(this, hrc, 1 /*hrc exception*/,*aChildrenCount);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SNAPSHOT_GET_CHILDRENCOUNT_RETURN(this, hrc, 9 /*unhandled exception*/,*aChildrenCount);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aChildrenCount=%RU32 hrc=%Rhrc\n", this, "Snapshot::getChildrenCount", *aChildrenCount, hrc));
    return hrc;
}

STDMETHODIMP SnapshotWrap::COMGETTER(InternalAndReservedAttribute1ISnapshot)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SnapshotWrap::COMGETTER(InternalAndReservedAttribute2ISnapshot)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SnapshotWrap::COMGETTER(InternalAndReservedAttribute3ISnapshot)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SnapshotWrap::COMGETTER(InternalAndReservedAttribute4ISnapshot)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SnapshotWrap::COMGETTER(InternalAndReservedAttribute5ISnapshot)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SnapshotWrap::COMGETTER(InternalAndReservedAttribute6ISnapshot)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SnapshotWrap::COMGETTER(InternalAndReservedAttribute7ISnapshot)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SnapshotWrap::COMGETTER(InternalAndReservedAttribute8ISnapshot)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// ISnapshot methods
//

STDMETHODIMP SnapshotWrap::InternalAndReservedMethod1ISnapshot()
{
    return E_NOTIMPL;
}

STDMETHODIMP SnapshotWrap::InternalAndReservedMethod2ISnapshot()
{
    return E_NOTIMPL;
}

STDMETHODIMP SnapshotWrap::InternalAndReservedMethod3ISnapshot()
{
    return E_NOTIMPL;
}

STDMETHODIMP SnapshotWrap::InternalAndReservedMethod4ISnapshot()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(SnapshotWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(SnapshotWrap, ISnapshot)
#endif // VBOX_WITH_XPCOM

