#
# Linux kernel configuration
#

# kernel fundamentals
LX_ENABLE += TTY SERIAL_EARLYCON SERIAL_OF_PLATFORM PRINTK HAS_IOMEM
LX_ENABLE += NO_HZ_IDLE
LX_ENABLE += TREE_RCU TREE_SRCU SMP PREEMPT
LX_ENABLE += CMA DMA_CMA ZONE_DMA ZONE_DMA32

# do not generate thumb instructions
LX_DISABLE += THUMB2_KERNEL ARM_VIRT_EXT DEBUG_PREEMPT

# SoC
LX_ENABLE += MMU ARCH_MXC SOC_IMX53 SOC_IMX6Q SOC_IMX6SX SOC_IMX7D
LX_ENABLE += MUX_MMIO
LX_ENABLE += GPIOLIB GPIO_MXC
LX_ENABLE += REGULATOR REGULATOR_FIXED_VOLTAGE REGULATOR_ANATOP REGULATOR_GPIO
LX_ENABLE += I2C I2C_GPIO I2C_IMX I2C_IMX_LPI2C
LX_ENABLE += SPI SPI_IMX SPI_GPIO GPIO_74X164
LX_ENABLE += NVMEM NVMEM_IMX_OCOTP

# UART device
LX_ENABLE += SERIAL_IMX SERIAL_IMX_CONSOLE SERIAL_IMX_EARLYCON

# Network
LX_ENABLE += NET INET NETDEVICES FEC MDIO_BUS_MUX_MULTIPLEXER AT803X_PHY

# USB host
LX_ENABLE += USB USB_SUPPORT USB_COMMON USB_ARCH_HAS_HCD USB_ARCH_HAS_HCD
LX_ENABLE += USB_ANNOUNCE_NEW_DEVICES USB_EHCI_HCD USB_OHCI_HCD
LX_ENABLE += USB_CHIPIDEA USB_CHIPIDEA_HOST USB_MXS_PHY NOP_USB_XCEIV USB_GADGET
LX_ENABLE += USB_NET_DRIVERS USB_USBNET

# SD/eMMC
LX_ENABLE += MMC MMC_MXC MMC_SDHCI MMC_SDHCI_PLTFM MMC_SDHCI_OF_ESDHC MMC_SDHCI_ESDHC_IMX

# To run native Linux
LX_ENABLE += SYSFS MULTIUSER FILE_LOCKING BINFMT_ELF BINFMT_SCRIPT BLK_DEV_INITRD
LX_ENABLE += PACKET UNIX PROC_FS POSIX_TIMERS DEVTMPFS
LX_ENABLE += IP_PNP IP_PNP_DHCP

# slim down kernel by removing superfluous drivers
LX_DISABLE += $(addprefix NET_VENDOR_, 3COM 8390 ADAPTEC AGERE ALACRITECH \
                ALTEON AMAZON AMD AQUANTIA ARC ASIX ATHEROS BROADCOM BROCADE \
                CADENCE CAVIUM CHELSIO CIRRUS CISCO CORTINA DAVICOM DEC DLINK EMULEX \
                ENGLEDER EZCHIP FARADAY FUNGIBLE GOOGLE HISILICON HUAWEI I825XX INTEL \
                LITEX MARVELL MELLANOX MICREL MICROCHIP MICROSEMI MICROSOFT \
                MYRI NATSEMI NETERION NETRONOME NI NVIDIA OKI PACKET_ENGINES \
                PENSANDO QLOGIC QUALCOMM RDC REALTEK RENESAS ROCKER SAMSUNG \
                SEEQ SILAN SIS SMSC SOCIONEXT SOLARFLARE STMICRO SUN SYNOPSYS \
                TEHUTI TI VERTEXCOM VIA WANGXUN WIZNET XILINX)
LX_DISABLE += WLAN WIRELESS
LX_DISABLE += MOUSE_PS2
