#
# Linux kernel configuration
#

# kernel fundamentals
LX_ENABLE += TTY SERIAL_EARLYCON SERIAL_OF_PLATFORM PRINTK HAS_IOMEM
LX_ENABLE += NO_HZ_IDLE
LX_ENABLE += CMA DMA_CMA ZONE_DMA ZONE_DMA32

# SoC
LX_ENABLE += ARCH_NXP ARCH_MXC
LX_ENABLE += CLK_IMX8MQ CLK_IMX8MP
LX_ENABLE += PINCTRL PINCTRL_IMX8MQ PINCTRL_IMX8MP MUX_MMIO
LX_ENABLE += RESET_CONTROLLER RESET_IMX7
LX_ENABLE += REGULATOR REGULATOR_FIXED_VOLTAGE REGULATOR_ANATOP
LX_ENABLE += REGULATOR_PFUZE100 REGULATOR_GPIO
LX_ENABLE += NVMEM NVMEM_IMX_OCOTP
LX_ENABLE += INTERCONNECT INTERCONNECT_IMX INTERCONNECT_IMX8MQ
LX_ENABLE += DMADEVICES IMX_SDMA

#
# Generic Dynamic Voltage and Frequency Scaling (DVFS)
#
# Required by USB on imx8mp
LX_ENABLE += PM_DEVFREQ ARM_IMX_BUS_DEVFREQ

# interconnect
LX_ENABLE += INTERCONNECT_IMX8MP

# UART device
LX_ENABLE += SERIAL_IMX SERIAL_IMX_CONSOLE SERIAL_IMX_EARLYCON

# I2C
LX_ENABLE += I2C I2C_IMX I2C_IMX_LPI2C I2C_MUX I2C_MUX_REG I2C_MUX_PCA954x

# GPIO
LX_ENABLE += GPIOLIB GPIO_MXC

# PCI
LX_ENABLE += PCI PCI_IMX6 PCIE_DW_PLAT_HOST PHY_FSL_IMX8M_PCIE

# Network
LX_ENABLE += NET INET NETDEVICES FEC WLAN MDIO_BUS_MUX_MULTIPLEXER
LX_ENABLE += AT803X_PHY REALTEK_PHY

# Network EQOS device on i.MX8 PLUS
LX_ENABLE += NET_VENDOR_STMICRO STMMAC_ETH DWMAC_IMX8 MICREL_PHY

# Wifi
LX_ENABLE += WLAN CFG80211 MAC80211 RFKILL CFG80211_WEXT NETLINK_DIAG
LX_ENABLE += WLAN_VENDOR_ATH ATH_COMMON ATH9K ATH9K_PCI

# iwlwifi
LX_ENABLE += WLAN_VENDOR_INTEL IWLWIFI IWLDVM IWLMVM

# rtlwifi
LX_ENABLE += WLAN_VENDOR_REALTEK RTL_CARDS RTL8188EE

# DRM
LX_ENABLE += DRM DRM_NWL_MIPI_DSI DRM_LVDS_CODEC DRM_SIMPLE_BRIDGE
LX_ENABLE += DRM_TI_SN65DSI86 DRM_CDNS_MHDP8546 DRM_CDNS_HDMI_CEC
LX_ENABLE += DRM_IMX_CDNS_MHDP DRM_IMX_DCSS DRM_PANEL_LVDS PHY_MIXEL_LVDS_PHY
LX_ENABLE += PHY_MIXEL_MIPI_DPHY DRM_PANEL_EDP DRM_MXSFB DRM_PANEL_RAYDIUM_RM67191

# MNT Pocket LCD
LX_ENABLE += DRM_SAMSUNG_DSIM DRM_IMX_LCDIF DRM_PANEL_JDI_LT070ME05000

# Panel backlight
LX_ENABLE += PWM PWM_IMX27 BACKLIGHT_CLASS_DEVICE BACKLIGHT_GPIO NEW_LEDS
LX_ENABLE += LEDS_CLASS BACKLIGHT_LED BACKLIGHT_PWM

# GPU
LX_ENABLE += DRM_ETNAVIV

# Automatically set up screen mode at boot time
LX_ENABLE += FB FRAMEBUFFER_CONSOLE

# USB host
LX_ENABLE += USB USB_SUPPORT USB_COMMON USB_ARCH_HAS_HCD
LX_ENABLE += USB_DWC3 USB_DWC3_IMX8MP USB_ANNOUNCE_NEW_DEVICES USB_XHCI_HCD
LX_ENABLE += USB_NET_DRIVERS USB_USBNET


# Block device support
LX_ENABLE += BLOCK MMC MMC_BLOCK MMC_SDHCI MMC_SDHCI_PLTFM
LX_ENABLE += MMC_SDHCI_OF_ESDHC MMC_SDHCI_ESDHC_IMX BLK_DEV_NVME

# Audio
LX_ENABLE += SOUND SND SND_SOC SND_IMX_SOC SND_SOC_WM8960 SND_SOC_FSL_MICFIL
LX_ENABLE += SND_SOC_FSL_ASOC_CARD SND_SOC_IMX_AUDMIX SND_SOC_IMX_HDMI

# To run native Linux
LX_ENABLE += SYSFS MULTIUSER FILE_LOCKING BINFMT_ELF BINFMT_SCRIPT BLK_DEV_INITRD
LX_ENABLE += PACKET UNIX PROC_FS POSIX_TIMERS DEVTMPFS

# Allow debugging of HW memory via memtool by /dev/mem
LX_ENABLE  += DEVMEM
LX_DISABLE += STRICT_DEVMEM

# Enable watchdog support
LX_ENABLE += WATCHDOG WATCHDOG_HANDLE_BOOT_ENABLED IMX2_WDT

# slim down kernel by removing superfluous drivers
LX_DISABLE += $(addprefix NET_VENDOR_, 3COM 8390 ADAPTEC AGERE ALACRITECH \
                ALTEON AMAZON AMD AQUANTIA ARC ASIX ATHEROS BROADCOM BROCADE \
                CADENCE CAVIUM CHELSIO CISCO CORTINA DAVICOM DEC DLINK EMULEX \
                ENGLEDER EZCHIP FUNGIBLE GOOGLE HISILICON HUAWEI I825XX INTEL \
                LITEX MARVELL MELLANOX MICREL MICROCHIP MICROSEMI MICROSOFT \
                MYRI NATSEMI NETERION NETRONOME NI NVIDIA OKI PACKET_ENGINES \
                PENSANDO QLOGIC QUALCOMM RDC REALTEK RENESAS ROCKER SAMSUNG \
                SEEQ SILAN SIS SMSC SOCIONEXT SOLARFLARE SUN SYNOPSYS \
                TEHUTI TI VERTEXCOM VIA WANGXUN WIZNET XILINX)
LX_DISABLE += $(addprefix WLAN_VENDOR_, ADMTEK ATMEL BROADCOM CISCO INTERSIL \
                MARVELL MEDIATEK MICROCHIP PURELIFI RALINK RSI SILABS \
                ST TI ZYDAS QUANTENNA)
LX_DISABLE += MOUSE_PS2
