/*
 * Command Line Parser
 *
 * Copyright (C) 2009-2011 Udo Steinberg <udo@hypervisor.org>
 * Economic rights: Technische Universitaet Dresden (Germany)
 *
 * Copyright (C) 2012-2013 Udo Steinberg, Intel Corporation.
 * Copyright (C) 2014 Udo Steinberg, FireEye, Inc.
 * Copyright (C) 2017-2018 Alexander Boettcher, Genode Labs GmbH.
 *
 * This file is part of the NOVA microhypervisor.
 *
 * NOVA is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * NOVA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License version 2 for more details.
 */

#pragma once

#include "compiler.hpp"
#include "types.hpp"

class Cmdline
{
    private:
        static struct param_map
        {
            char   const *arg;
            bool * const  ptr;
        } map[];

        INIT
        static char const *get_arg (char const **, unsigned &);

    public:

        static bool iommu_intel;
        static bool iommu_amd;
        static bool keyb;
        static bool serial;
        static bool spinner;
        static bool vtlb;
        static bool nodl;
        static bool nopcid;
        static bool vga;
        static bool novpid;
        static bool logmem;
        static bool fpu_lazy;
        static bool hlt;

        INIT
        static void init (char const *);
};
