/*
 * Mapping Database
 *
 * Copyright (C) 2009-2011 Udo Steinberg <udo@hypervisor.org>
 * Economic rights: Technische Universitaet Dresden (Germany)
 *
 * This file is part of the NOVA microhypervisor.
 *
 * NOVA is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * NOVA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License version 2 for more details.
 */

#include "assert.hpp"
#include "lock_guard.hpp"
#include "mdb.hpp"

Spinlock Mdb::lock;

bool Mdb::insert_node (Mdb *p, mword a)
{
    Lock_guard <Spinlock> guard (lock);

    if (!p->alive())
        return false;

    if (!(node_attr = p->node_attr & a))
        return false;

    prev = prnt = p;
    next = p->next;
    p->next = p->next->prev = this;

    return true;
}

void Mdb::demote_node (mword a)
{
    Lock_guard <Spinlock> guard (lock);

    node_attr &= ~a;
}

bool Mdb::remove_node(bool leaf)
{
    if (node_attr)
        return false;

    Lock_guard <Spinlock> guard (lock);

    if (!alive())
        return false;

    if (leaf && next->dpth > dpth)
        return false;

    if (!leaf)
        next->prnt = prnt;

    next->prev = prev;
    prev->next = next;

    return true;
}
