/*
 * Advanced Configuration and Power Interface (ACPI)
 *
 * Copyright (C) 2012 Udo Steinberg, Intel Corporation.
 *
 * This file is part of the NOVA microhypervisor.
 *
 * NOVA is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * NOVA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License version 2 for more details.
 */

#include "acpi_hpet.hpp"
#include "hpet.hpp"
#include "pd.hpp"

void Acpi_table_hpet::parse() const
{
    if (hpet.asid == Acpi_gas::MEMORY)
        new (Pd::kern.quota) Hpet (static_cast<Paddr>(hpet.addr), id);
}
