/*
 * Copyright 2014-2016 Canonical Ltd.
 *
 * This file is part of morph-browser.
 *
 * morph-browser is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * morph-browser is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.4
import Ubuntu.Components 1.3
import webbrowsercommon.private 0.1

Item {
    id: favicon

    property url source
    property bool fallbackIcon: true
    property alias shouldCache: fetcher.shouldCache

    width: units.dp(16)
    height: units.dp(16)

    Image {
        id: image
        source: fetcher.localUrl
        anchors.fill: parent
        asynchronous: true
    }

    FaviconFetcher {
        id: fetcher
        url: favicon.visible ? favicon.source : ""
    }

    Icon {
        anchors.fill: parent
        name: "stock_website"
        visible: parent.fallbackIcon &&
                 ((image.status !== Image.Ready) || !image.source.toString())
        asynchronous: true
    }
}
