# Largest Contentful Paint Definition Change in M88

## Definition Change in Chrome 88

In Chrome 88, some changes were made to Largest Contentful Paint to bring its
implementation in line with the updated [specification](https://wicg.github.io/largest-contentful-paint/).

The definition change was the following: image or text content which is later
removed from the page is now considered valid largest contentful paints.
[Source code for this change](https://chromium-review.googlesource.com/c/chromium/src/+/2480845).

Before this change, an element being removed caused it to no longer be
considered a valid LCP candidate. In particular, if the current LCP candidate
was removed from the site, this would immediately cause a new LCP candidate to
be found among the content remaining on the page.

After this change, an element being removed is still considered a valid LCP
candidate. What this means is that if this candidate is removed then we do not
need to immediately find a new LCP candidate. In particular, a new LCP candidate
is only dispatched when a larger size is found, so the LCP entries should have
size values that only increase over time.

## How does this affect a site's metrics?

The change to include content which is later removed from the DOM as possible
largest contentful paints will improve Largest Contentful Paint times on sites
which have images of the same size inserted multiple times. This is a common
pattern for carousels, as well as some JavaScript frameworks which do
server-side rendering.

It's worth noting that while the change was made for the web API in Chrome 88,
some tools which display real user metrics lagged behind this change, as we
provided both LCP values (using the old definition and using the new one) to
these tools while they make the necessary adjustments to swap to the new
definition.

## When were users affected?

Chrome 88 is currently scheduled to be released the week of January 19, 2021.
