# Largest Contentful Paint Bug Fixes in M98

## Bug Fixes in Chrome 98

In Chrome 98, a bug fix was made to the Chrome implementation. Previously, we
would wait for one visual update at a time and record the paint times of all
pending text nodes upon receiving the timestamp for the visual update. This
could cause certain text nodes that had just been detected to be considered
displayed even though they're not. Instead, we keep track of the objects which
are painted on each animation frame and set their timestamps to the visual
update corresponding to that animation frame. This is already how it works for
image objects, so this change only impacts text paint times, making them more
accurate. [Source code for this
change](https://chromium-review.googlesource.com/c/chromium/src/+/3265727).

## How does this affect a site's metrics?

A website whose LCP is text may see their LCP values increase due to the more
accurate paint times being used.

## When were users affected?

Chrome 98 is currently scheduled to be released the week of February 1, 2022.
