# Changes related to FCP and document opacity in Chrome 102

## Opacity changes and FCP
When investigating an 
[issue](https://bugs.chromium.org/p/chromium/issues/detail?id=1279548), we
discovered that while FCP is properly ignored when the document is fully opaque
(e.g. in cases where an A/B anti-flicker snippet is deployed), it does not
necessarily fire when the document's opacity changes, unless there are paint
involved with that opacity change. One particular case where paints are elided
is when a `will-change: opacity` style is applied to the document.

## How does this affect a site's metrics?
If your site is using an A/B testing framework that employs
[full-document opacity snippets](https://andydavies.me/blog/2020/11/16/the-case-against-anti-flicker-snippets/),
then this issue may have affected your site's FCP metrics.

The issue results in an FCP entry that indicated the time of the next
contentful paint after the opacity change,  which could be significantly after
the actual FCP. Potentially, there could also be cases where FCP wasn't
reported at all.

## When were users affected?
This seems to have been a long standing issue, most likely introduced when we
[started ignoring paints with opacity 0](https://chromium-review.googlesource.com/c/chromium/src/+/2316788)
in Chrome 86.