# Codes of Conduct

Chromium contributors participate in many organizations that standardize Web
APIs. These organizations have rules that govern participants' behavior. We need
to follow these rules, and we can expect that others in these bodies will also
follow the rules.

This document links to each organization's code of conduct and any contact
information that organization provides for navigating difficulties. For
organizations without a code of conduct, we're happy to help them develop one.

If you notice someone breaking a venue's code of conduct, you have several options for handling the situation:

1. If you feel comfortable, call out the behavior in the discussion and give an
   opportunity for it to be addressed. For example:

   > "This comment is not constructive/does not help move us to consensus/makes
   an incorrect assumption/is not actionable.  Could you please re-state or
   rephrase your comments accordingly?"
1. If you do not feel comfortable raising the concern directly, or the behavior
   is not fixed or acknowledged, disengage with the discussion and escalate the
   issue:
   1. To your [spec mentor](https://www.chromium.org/blink/spec-mentors) if you have one.
   1. To a relevant group chair.
   1. To the SDO's ombuds group as identified below and/or in their code of conduct.


[TOC]


## W3C

See the [Code of Ethics and Professional
Conduct](https://www.w3.org/Consortium/cepc/) and the
[procedures](https://www.w3.org/Consortium/pwe/#Procedures) used to enforce it.
The ombuds may be contacted
[individually](https://www.w3.org/Consortium/pwe/#ombuds) or collectively at
<ombuds@w3.org>.

## WHATWG

See the [Code of Conduct](https://whatwg.org/code-of-conduct). Escalate via
<sg@whatwg.org>.

## IETF

See the [Guidelines for Conduct](https://www.rfc-editor.org/rfc/rfc7154.html)
and the [Anti-Harassment
Procedures](https://www.rfc-editor.org/rfc/rfc7776.html).

Escalate via [individual ombudspeople](https://www.ietf.org/contact/ombudsteam/)
or <ombudsteam@ietf.org>.

## ECMA TC39

See the [Code of Conduct](https://tc39.es/code-of-conduct/). Report violations via <tc39-conduct-reports@googlegroups.com>.

## Khronos

See the
[https://www.khronos.org/events/code-of-conduct](https://www.khronos.org/events/code-of-conduct).
Their escalation path is more tailored to events than standardization activity,
but you can [file an anonymous
report](https://docs.google.com/forms/d/1nr1B_TOMIhSXh1yG8VsvGpEO9p6GWY-3kxJu-rnA5dU/viewform).

## FIDO

See the [Code of Conduct](https://fidoalliance.org/code-of-conduct/). To report
a violation, talk to an [Executive
Director](https://fidoalliance.org/overview/leadership/#staff-members) or the
[President](https://fidoalliance.org/overview/leadership/#executive-council), or
fill out the [contact form](https://fidoalliance.org/contact/) or email
help@fidoalliance.org.

## AO Media

The [Alliance for Open Media](https://aomedia.org/) does not currently have a code of conduct.


