# Positions from Google Chrome Teams on Web Standards

Google Chrome delegates decisions about what web features we implement and ship
to feature teams. This directory holds documents explaining the positions of
those feature teams about features they've decided to implement or not. Not all
such decisions will be explained here: just the ones where the feature teams
expect a document to help future discussions start from a place of shared
understanding.

These positions are explicitly *not* Chromium-wide positions, or even explicitly
Chrome-wide. Other Chromium-based browsers may disagree.

All positions here are subject to change as ownership changes or as owners
encounter new evidence.

Status: as yet, no positions have been published.

## Process for publishing positions

This directory isn't intended to record positions on many features. See
https://chromestatus.com/ for a more complete list of features and their status
in Chrome. Instead, this is intended to support transparency and discoverability
in areas of significant debate or repeated questions. Focus on technical
disagreements and on explaining how the position could be changed. When in
doubt, don't publish a position.

Get positions approved by the tech lead of the team that would decide whether to
ship the feature that the position is about. In the code review adding a
position, try to cc people who were involved in the discussions leading up to
the position, especially those who disagree, to ensure you're addressing the
strongest version of their arguments.

Be sure to add any new features to this README.

There is no systematic way for people outside of the Chrome team to request a
formal position document. If you want to know what Chrome thinks of a feature,
ask someone who's involved with its working or community group. If you can't
figure out who owns a feature, email blink-dev@chromium.org to ask.
