# Chrome OS Inclusive Language

April 22, 2021

Google’s values include a deep respect for everyone who builds and uses our products and services.  One very significant aspect of respect is the sense of inclusiveness our users perceive when they use Google products and services, such as Chrome OS devices. 

Google is taking active steps to revise internally and externally-facing code, documentation, UI and other artifacts, to better promote inclusivity. 

Users, developers and hardware partners have seen tremendous inclusion strides with Google’s focus on accessibility.  [Gender language equity](https://chromium.googlesource.com/chromium/src/+/main/styleguide/inclusive_code.md) in coding terms and language is another area that has benefited from a focus on increased attention to inclusive language.  

Inclusive language used in coding, development language, all aspects of technical documentation including hardware designs, specifications and referenceable materials, all the way through the Chrome OS system to user help articles and documentation have been added to this effort.  

Specific emphasis on improving inclusive language related to those belonging to disadvantaged groups has led to a number of changes in Google-hosted code, repos and documentation. (See Chromebooks [Accessibility for People with Disabilities](https://www.google.com/chromebook/accessibility/).)  For example, oppressive language terms such as “master”, “slave”, “blacklist” and “whitelist” have been replaced with more precise language and terms in Google code, repos and documentation.  

In addition to helping to maintain these changes when contributing to or building  on Google products and services, we encourage partners to join us in these efforts in the following ways:



*   **Review and update** documentation, code and technical materials with respect to identified disrespectful terms.  **Directly replace identified disrespectful terms** with precise terms where possible, such as in  code branches, **master** ⇒ **main**;  **white list** ⇒ **allow list**.   (For a publicly available list of terms, refer to the list posted on [chromium.googlesource.com](https://www.google.com/url?q=https://chromium.googlesource.com/chromiumos/repohooks/%2B/refs/heads/main/blocked_terms.txt&sa=D&source=editors&ust=1614112385305000&usg=AOvVaw2isDcAxXDdDANvl-XPO-y4).)
*   **For schematics, use current [Reference Design Schematic Net Naming](https://chromeos.google.com/partner/dlm/docs/reference-designs/Google_Reference_Design_Schematic_Style_Guidelines.html#net-naming-convention)** to meet the inclusive standard, with particular focus on [SPI signal names](https://www.oshwa.org/a-resolution-to-redefine-spi-signal-names/).  
*   **Adopt pre-submit checks for code check ins** to catch inadvertent re-introduction of disrespectful terms.   (See \_check\_keywords function on [chromium.googlesource.com](https://www.google.com/url?q=https://chromium.googlesource.com/chromiumos/repohooks/%2B/refs/heads/main/blocked_terms.txt&sa=D&source=editors&ust=1614112385305000&usg=AOvVaw2isDcAxXDdDANvl-XPO-y4).)
*   **Use precise language** when direct replacement is awkward, undefined, or using a term that can be perceived as oppressive and disrespectful, such as with **sanity** ⇒ **health check**;  **white label**  ⇒ **custom label**; and **master/slave** relationship ⇒  direct reference of items, such as with components on a schematic. 

As we move towards more precise language, we should consider both context and intent, and consider whether or not there is a more clear way of expressing the point.  The following examples illustrate the idea:  



*   “Black and white,” when used to mean “clearly stated in writing,” is better written as “clearly stated.”
*   “Master your keyboard,” when used to mean “become proficient with” or “learn to use” is better written as simply “Learning to use your keyboard.”

In the end, using more precisely crafted terms, technical artifacts and documentation leads to clearer and more effective materials that are easier to communicate globally to a wide variety of users and audiences.  
