# Fuchsia

Documentation for developing Chromium for the [Fuchsia](https://fuchsia.dev/) platform.

[TOC]

## Contact information

* [`#fuchsia`](https://chromium.slack.com/archives/CGJCHA1SM) on [Chromium Slack](https://www.chromium.org/developers/slack)
* [fuchsia-dev@chromium.org](mailto:fuchsia-dev@chromium.org)

## Bugs

Fuchsia-specific issues should have Component `Fuchsia` and OS `Fuchsia`.

To report a new issue, use this
[template](https://bugs.chromium.org/p/chromium/issues/entry?components=Fuchsia&labels=OS-Fuchsia%2CType-Bug).

## Chromium development for Fuchsia

See [Checking out and building on Fuchsia](build_instructions.md) for
Fuchsia-specific build instructions.

### Deploying and running Fuchsia code.

Fuchsia binaries are deployed and executed via scripts that are automatically
generated by the `fuchsia_package_installer()` or
`fuchsia_run_script_with_packages()` GN templates.

For information on running tests, see [Tests](#tests).

#### Debugging

See [Debugging](debug_instructions.md)

#### Tests

* [Deploying and running gtests on Fuchsia](gtests.md)
* [Deploying content_shell and running web_tests on Fuchsia](web_tests.md)
* [Running GPU integration tests on Fuchsia](gpu_testing.md)
* [Running Telemetry Benchmarks on Fuchsia](telemetry.md)
* [Fuchsia Binary Size Bot](../speed/binary_size/fuchsia_binary_size_trybot.md)

## Fuchsia WebEngine and Runners
See [Fuchsia WebEngine and Runners](../../fuchsia_web/README.md).

## Resources for developers working on Chromium for Fuchsia

* [Fuchsia platform versioning](platform_versioning.md)
* [Manually updating Chromium to a new Fuchsia SDK](sdk_updates.md)
