// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef FUCHSIA_WEB_RUNNERS_CAST_CAST_RESOLVER_H_
#define FUCHSIA_WEB_RUNNERS_CAST_CAST_RESOLVER_H_

#include <fuchsia/component/resolution/cpp/fidl.h>

// fuchsia.component.resolution.Resolver implementation for Cast applications.
class CastResolver final : public fuchsia::component::resolution::Resolver {
 public:
  CastResolver();
  ~CastResolver() override;

  CastResolver(const CastResolver&) = delete;
  CastResolver& operator=(const CastResolver&) = delete;

  // fuchsia::component::resolution::Resolver implementation.
  void Resolve(std::string component_url, ResolveCallback callback) override;
  void ResolveWithContext(std::string component_url,
                          fuchsia::component::resolution::Context context,
                          ResolveWithContextCallback callback) override;
};

#endif  // FUCHSIA_WEB_RUNNERS_CAST_CAST_RESOLVER_H_
