// ##### ENDFILE "USBProxyBackendWrap.h"


// ##### BEGINFILE "AudioAdapterWrap.h"
/** @file
 * VirtualBox API class wrapper header for IAudioAdapter.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#ifndef AudioAdapterWrap_H_
#define AudioAdapterWrap_H_
#ifndef RT_WITHOUT_PRAGMA_ONCE
# pragma once
#endif

#include "VirtualBoxBase.h"
#include "Wrapper.h"

class ATL_NO_VTABLE AudioAdapterWrap
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IAudioAdapter)
{
    Q_OBJECT

public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(AudioAdapterWrap, IAudioAdapter)
    DECLARE_NOT_AGGREGATABLE(AudioAdapterWrap)
    DECLARE_PROTECT_FINAL_CONSTRUCT()

    BEGIN_COM_MAP(AudioAdapterWrap)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IAudioAdapter)
        COM_INTERFACE_ENTRY2(IDispatch, IAudioAdapter)
        VBOX_TWEAK_INTERFACE_ENTRY(IAudioAdapter)
    END_COM_MAP()

    DECLARE_EMPTY_CTOR_DTOR(AudioAdapterWrap)

    /** @name Public IAudioAdapter properties
     * @{ */
    STDMETHOD(COMGETTER(Enabled))(BOOL *aEnabled);
    STDMETHOD(COMSETTER(Enabled))(BOOL aEnabled);
    STDMETHOD(COMGETTER(EnabledIn))(BOOL *aEnabledIn);
    STDMETHOD(COMSETTER(EnabledIn))(BOOL aEnabledIn);
    STDMETHOD(COMGETTER(EnabledOut))(BOOL *aEnabledOut);
    STDMETHOD(COMSETTER(EnabledOut))(BOOL aEnabledOut);
    STDMETHOD(COMGETTER(AudioController))(AudioControllerType_T *aAudioController);
    STDMETHOD(COMSETTER(AudioController))(AudioControllerType_T aAudioController);
    STDMETHOD(COMGETTER(AudioCodec))(AudioCodecType_T *aAudioCodec);
    STDMETHOD(COMSETTER(AudioCodec))(AudioCodecType_T aAudioCodec);
    STDMETHOD(COMGETTER(AudioDriver))(AudioDriverType_T *aAudioDriver);
    STDMETHOD(COMSETTER(AudioDriver))(AudioDriverType_T aAudioDriver);
    STDMETHOD(COMGETTER(PropertiesList))(ComSafeArrayOut(BSTR, aPropertiesList));
    STDMETHOD(COMGETTER(InternalAndReservedAttribute1IAudioAdapter))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute2IAudioAdapter))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute3IAudioAdapter))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute4IAudioAdapter))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute5IAudioAdapter))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute6IAudioAdapter))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute7IAudioAdapter))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute8IAudioAdapter))(ULONG *aReserved);
    /** @} */

    /** @name Public IAudioAdapter methods
     * @{ */
    STDMETHOD(SetProperty)(IN_BSTR aKey,
                           IN_BSTR aValue);
    STDMETHOD(GetProperty)(IN_BSTR aKey,
                           BSTR *aValue);
    STDMETHOD(InternalAndReservedMethod1IAudioAdapter)();
    STDMETHOD(InternalAndReservedMethod2IAudioAdapter)();
    STDMETHOD(InternalAndReservedMethod3IAudioAdapter)();
    STDMETHOD(InternalAndReservedMethod4IAudioAdapter)();
    /** @} */

private:
    /** @name Wrapped IAudioAdapter properties
     * @{ */
    virtual HRESULT getEnabled(BOOL *aEnabled) = 0;
    virtual HRESULT setEnabled(BOOL aEnabled) = 0;
    virtual HRESULT getEnabledIn(BOOL *aEnabledIn) = 0;
    virtual HRESULT setEnabledIn(BOOL aEnabledIn) = 0;
    virtual HRESULT getEnabledOut(BOOL *aEnabledOut) = 0;
    virtual HRESULT setEnabledOut(BOOL aEnabledOut) = 0;
    virtual HRESULT getAudioController(AudioControllerType_T *aAudioController) = 0;
    virtual HRESULT setAudioController(AudioControllerType_T aAudioController) = 0;
    virtual HRESULT getAudioCodec(AudioCodecType_T *aAudioCodec) = 0;
    virtual HRESULT setAudioCodec(AudioCodecType_T aAudioCodec) = 0;
    virtual HRESULT getAudioDriver(AudioDriverType_T *aAudioDriver) = 0;
    virtual HRESULT setAudioDriver(AudioDriverType_T aAudioDriver) = 0;
    virtual HRESULT getPropertiesList(std::vector<com::Utf8Str> &aPropertiesList) = 0;
    /** @} */

    /** @name Wrapped IAudioAdapter methods
     * @{ */
    virtual HRESULT setProperty(const com::Utf8Str &aKey,
                                const com::Utf8Str &aValue) = 0;
    virtual HRESULT getProperty(const com::Utf8Str &aKey,
                                com::Utf8Str &aValue) = 0;
    /** @} */

private:
    DECLARE_CLS_COPY_CTOR_ASSIGN_NOOP(AudioAdapterWrap); /* Shuts up MSC warning C4625. */

};

#endif // !AudioAdapterWrap_H_

