// ##### ENDFILE "MediumFormatWrap.h"


// ##### BEGINFILE "DataStreamWrap.h"
/** @file
 * VirtualBox API class wrapper header for IDataStream.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#ifndef DataStreamWrap_H_
#define DataStreamWrap_H_
#ifndef RT_WITHOUT_PRAGMA_ONCE
# pragma once
#endif

#include "VirtualBoxBase.h"
#include "Wrapper.h"

class ATL_NO_VTABLE DataStreamWrap
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IDataStream)
{
    Q_OBJECT

public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(DataStreamWrap, IDataStream)
    DECLARE_NOT_AGGREGATABLE(DataStreamWrap)
    DECLARE_PROTECT_FINAL_CONSTRUCT()

    BEGIN_COM_MAP(DataStreamWrap)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IDataStream)
        COM_INTERFACE_ENTRY2(IDispatch, IDataStream)
        VBOX_TWEAK_INTERFACE_ENTRY(IDataStream)
    END_COM_MAP()

    DECLARE_EMPTY_CTOR_DTOR(DataStreamWrap)

    /** @name Public IDataStream properties
     * @{ */
    STDMETHOD(COMGETTER(ReadSize))(ULONG *aReadSize);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute1IDataStream))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute2IDataStream))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute3IDataStream))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute4IDataStream))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute5IDataStream))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute6IDataStream))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute7IDataStream))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute8IDataStream))(ULONG *aReserved);
    /** @} */

    /** @name Public IDataStream methods
     * @{ */
    STDMETHOD(Read)(ULONG aSize,
                    ULONG aTimeoutMS,
                    ComSafeArrayOut(BYTE, aData));
    STDMETHOD(InternalAndReservedMethod1IDataStream)();
    STDMETHOD(InternalAndReservedMethod2IDataStream)();
    STDMETHOD(InternalAndReservedMethod3IDataStream)();
    STDMETHOD(InternalAndReservedMethod4IDataStream)();
    /** @} */

private:
    /** @name Wrapped IDataStream properties
     * @{ */
    virtual HRESULT getReadSize(ULONG *aReadSize) = 0;
    /** @} */

    /** @name Wrapped IDataStream methods
     * @{ */
    virtual HRESULT read(ULONG aSize,
                         ULONG aTimeoutMS,
                         std::vector<BYTE> &aData) = 0;
    /** @} */

private:
    DECLARE_CLS_COPY_CTOR_ASSIGN_NOOP(DataStreamWrap); /* Shuts up MSC warning C4625. */

};

#endif // !DataStreamWrap_H_

