// ##### ENDFILE "GuestFileEventWrap.h"


// ##### BEGINFILE "GuestFileIOEventWrap.h"
/** @file
 * VirtualBox API class wrapper header for IGuestFileIOEvent.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#ifndef GuestFileIOEventWrap_H_
#define GuestFileIOEventWrap_H_
#ifndef RT_WITHOUT_PRAGMA_ONCE
# pragma once
#endif

#include "VirtualBoxBase.h"
#include "Wrapper.h"

class ATL_NO_VTABLE GuestFileIOEventWrap
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IGuestFileIOEvent)
{
    Q_OBJECT

public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(GuestFileIOEventWrap, IGuestFileIOEvent)
    DECLARE_NOT_AGGREGATABLE(GuestFileIOEventWrap)
    DECLARE_PROTECT_FINAL_CONSTRUCT()

    BEGIN_COM_MAP(GuestFileIOEventWrap)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IGuestFileIOEvent)
        COM_INTERFACE_ENTRY(IGuestFileEvent)
        COM_INTERFACE_ENTRY(IGuestSessionEvent)
        COM_INTERFACE_ENTRY(IEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IGuestFileIOEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IGuestFileIOEvent)
    END_COM_MAP()

    DECLARE_EMPTY_CTOR_DTOR(GuestFileIOEventWrap)

    /** @name Public IEvent properties
     * @{ */
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType);
    STDMETHOD(COMGETTER(Source))(IEventSource **aSource);
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable);
    /** @} */

    /** @name Public IGuestSessionEvent properties
     * @{ */
    STDMETHOD(COMGETTER(Session))(IGuestSession **aSession);
    /** @} */

    /** @name Public IGuestFileEvent properties
     * @{ */
    STDMETHOD(COMGETTER(File))(IGuestFile **aFile);
    /** @} */

    /** @name Public IGuestFileIOEvent properties
     * @{ */
    STDMETHOD(COMGETTER(Offset))(LONG64 *aOffset);
    STDMETHOD(COMGETTER(Processed))(ULONG *aProcessed);
    /** @} */

    /** @name Public IEvent methods
     * @{ */
    STDMETHOD(SetProcessed)();
    STDMETHOD(WaitProcessed)(LONG aTimeout,
                             BOOL *aResult);
    /** @} */

    /** @name Public IGuestSessionEvent methods
     * @{ */
    /** @} */

    /** @name Public IGuestFileEvent methods
     * @{ */
    /** @} */

    /** @name Public IGuestFileIOEvent methods
     * @{ */
    /** @} */

private:
    /** @name Wrapped IEvent properties
     * @{ */
    virtual HRESULT getType(VBoxEventType_T *aType) = 0;
    virtual HRESULT getSource(ComPtr<IEventSource> &aSource) = 0;
    virtual HRESULT getWaitable(BOOL *aWaitable) = 0;
    /** @} */

    /** @name Wrapped IGuestSessionEvent properties
     * @{ */
    virtual HRESULT getSession(ComPtr<IGuestSession> &aSession) = 0;
    /** @} */

    /** @name Wrapped IGuestFileEvent properties
     * @{ */
    virtual HRESULT getFile(ComPtr<IGuestFile> &aFile) = 0;
    /** @} */

    /** @name Wrapped IGuestFileIOEvent properties
     * @{ */
    virtual HRESULT getOffset(LONG64 *aOffset) = 0;
    virtual HRESULT getProcessed(ULONG *aProcessed) = 0;
    /** @} */

    /** @name Wrapped IEvent methods
     * @{ */
    virtual HRESULT setProcessed() = 0;
    virtual HRESULT waitProcessed(LONG aTimeout,
                                  BOOL *aResult) = 0;
    /** @} */

    /** @name Wrapped IGuestSessionEvent methods
     * @{ */
    /** @} */

    /** @name Wrapped IGuestFileEvent methods
     * @{ */
    /** @} */

    /** @name Wrapped IGuestFileIOEvent methods
     * @{ */
    /** @} */

private:
    DECLARE_CLS_COPY_CTOR_ASSIGN_NOOP(GuestFileIOEventWrap); /* Shuts up MSC warning C4625. */

};

#endif // !GuestFileIOEventWrap_H_

