// ##### ENDFILE "ConsoleWrap.cpp"


// ##### BEGINFILE "HostNetworkInterfaceWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IHostNetworkInterface.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_HOSTNETWORKINTERFACE

#include "HostNetworkInterfaceWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(HostNetworkInterfaceWrap)

//
// IHostNetworkInterface properties
//

STDMETHODIMP HostNetworkInterfaceWrap::COMGETTER(Name)(BSTR *aName)
{
    LogRelFlow(("{%p} %s: enter aName=%p\n", this, "HostNetworkInterface::getName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aName);
        BSTROutConverter TmpName(aName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_NAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aName=%ls hrc=%Rhrc\n", this, "HostNetworkInterface::getName", *aName, hrc));
    return hrc;
}

STDMETHODIMP HostNetworkInterfaceWrap::COMGETTER(ShortName)(BSTR *aShortName)
{
    LogRelFlow(("{%p} %s: enter aShortName=%p\n", this, "HostNetworkInterface::getShortName", aShortName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aShortName);
        BSTROutConverter TmpShortName(aShortName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_SHORTNAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getShortName(TmpShortName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_SHORTNAME_RETURN(this, hrc, 0 /*normal*/,TmpShortName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_SHORTNAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_SHORTNAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aShortName=%ls hrc=%Rhrc\n", this, "HostNetworkInterface::getShortName", *aShortName, hrc));
    return hrc;
}

STDMETHODIMP HostNetworkInterfaceWrap::COMGETTER(Id)(BSTR *aId)
{
    LogRelFlow(("{%p} %s: enter aId=%p\n", this, "HostNetworkInterface::getId", aId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aId);
        UuidOutConverter TmpId(aId);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_ID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getId(TmpId.uuid());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_ID_RETURN(this, hrc, 0 /*normal*/,TmpId.uuid().toStringCurly().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_ID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_ID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aId=%ls hrc=%Rhrc\n", this, "HostNetworkInterface::getId", *aId, hrc));
    return hrc;
}

STDMETHODIMP HostNetworkInterfaceWrap::COMGETTER(NetworkName)(BSTR *aNetworkName)
{
    LogRelFlow(("{%p} %s: enter aNetworkName=%p\n", this, "HostNetworkInterface::getNetworkName", aNetworkName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNetworkName);
        BSTROutConverter TmpNetworkName(aNetworkName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_NETWORKNAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getNetworkName(TmpNetworkName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_NETWORKNAME_RETURN(this, hrc, 0 /*normal*/,TmpNetworkName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_NETWORKNAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_NETWORKNAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNetworkName=%ls hrc=%Rhrc\n", this, "HostNetworkInterface::getNetworkName", *aNetworkName, hrc));
    return hrc;
}

STDMETHODIMP HostNetworkInterfaceWrap::COMGETTER(DHCPEnabled)(BOOL *aDHCPEnabled)
{
    LogRelFlow(("{%p} %s: enter aDHCPEnabled=%p\n", this, "HostNetworkInterface::getDHCPEnabled", aDHCPEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDHCPEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_DHCPENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDHCPEnabled(aDHCPEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_DHCPENABLED_RETURN(this, hrc, 0 /*normal*/,*aDHCPEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_DHCPENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aDHCPEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_DHCPENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aDHCPEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDHCPEnabled=%RTbool hrc=%Rhrc\n", this, "HostNetworkInterface::getDHCPEnabled", *aDHCPEnabled, hrc));
    return hrc;
}

STDMETHODIMP HostNetworkInterfaceWrap::COMGETTER(IPAddress)(BSTR *aIPAddress)
{
    LogRelFlow(("{%p} %s: enter aIPAddress=%p\n", this, "HostNetworkInterface::getIPAddress", aIPAddress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIPAddress);
        BSTROutConverter TmpIPAddress(aIPAddress);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_IPADDRESS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getIPAddress(TmpIPAddress.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_IPADDRESS_RETURN(this, hrc, 0 /*normal*/,TmpIPAddress.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_IPADDRESS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_IPADDRESS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIPAddress=%ls hrc=%Rhrc\n", this, "HostNetworkInterface::getIPAddress", *aIPAddress, hrc));
    return hrc;
}

STDMETHODIMP HostNetworkInterfaceWrap::COMGETTER(NetworkMask)(BSTR *aNetworkMask)
{
    LogRelFlow(("{%p} %s: enter aNetworkMask=%p\n", this, "HostNetworkInterface::getNetworkMask", aNetworkMask));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNetworkMask);
        BSTROutConverter TmpNetworkMask(aNetworkMask);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_NETWORKMASK_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getNetworkMask(TmpNetworkMask.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_NETWORKMASK_RETURN(this, hrc, 0 /*normal*/,TmpNetworkMask.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_NETWORKMASK_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_NETWORKMASK_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNetworkMask=%ls hrc=%Rhrc\n", this, "HostNetworkInterface::getNetworkMask", *aNetworkMask, hrc));
    return hrc;
}

STDMETHODIMP HostNetworkInterfaceWrap::COMGETTER(IPV6Supported)(BOOL *aIPV6Supported)
{
    LogRelFlow(("{%p} %s: enter aIPV6Supported=%p\n", this, "HostNetworkInterface::getIPV6Supported", aIPV6Supported));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIPV6Supported);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_IPV6SUPPORTED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getIPV6Supported(aIPV6Supported);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_IPV6SUPPORTED_RETURN(this, hrc, 0 /*normal*/,*aIPV6Supported != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_IPV6SUPPORTED_RETURN(this, hrc, 1 /*hrc exception*/,*aIPV6Supported != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_IPV6SUPPORTED_RETURN(this, hrc, 9 /*unhandled exception*/,*aIPV6Supported != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIPV6Supported=%RTbool hrc=%Rhrc\n", this, "HostNetworkInterface::getIPV6Supported", *aIPV6Supported, hrc));
    return hrc;
}

STDMETHODIMP HostNetworkInterfaceWrap::COMGETTER(IPV6Address)(BSTR *aIPV6Address)
{
    LogRelFlow(("{%p} %s: enter aIPV6Address=%p\n", this, "HostNetworkInterface::getIPV6Address", aIPV6Address));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIPV6Address);
        BSTROutConverter TmpIPV6Address(aIPV6Address);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_IPV6ADDRESS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getIPV6Address(TmpIPV6Address.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_IPV6ADDRESS_RETURN(this, hrc, 0 /*normal*/,TmpIPV6Address.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_IPV6ADDRESS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_IPV6ADDRESS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIPV6Address=%ls hrc=%Rhrc\n", this, "HostNetworkInterface::getIPV6Address", *aIPV6Address, hrc));
    return hrc;
}

STDMETHODIMP HostNetworkInterfaceWrap::COMGETTER(IPV6NetworkMaskPrefixLength)(ULONG *aIPV6NetworkMaskPrefixLength)
{
    LogRelFlow(("{%p} %s: enter aIPV6NetworkMaskPrefixLength=%p\n", this, "HostNetworkInterface::getIPV6NetworkMaskPrefixLength", aIPV6NetworkMaskPrefixLength));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIPV6NetworkMaskPrefixLength);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_IPV6NETWORKMASKPREFIXLENGTH_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getIPV6NetworkMaskPrefixLength(aIPV6NetworkMaskPrefixLength);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_IPV6NETWORKMASKPREFIXLENGTH_RETURN(this, hrc, 0 /*normal*/,*aIPV6NetworkMaskPrefixLength);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_IPV6NETWORKMASKPREFIXLENGTH_RETURN(this, hrc, 1 /*hrc exception*/,*aIPV6NetworkMaskPrefixLength);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_IPV6NETWORKMASKPREFIXLENGTH_RETURN(this, hrc, 9 /*unhandled exception*/,*aIPV6NetworkMaskPrefixLength);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIPV6NetworkMaskPrefixLength=%RU32 hrc=%Rhrc\n", this, "HostNetworkInterface::getIPV6NetworkMaskPrefixLength", *aIPV6NetworkMaskPrefixLength, hrc));
    return hrc;
}

STDMETHODIMP HostNetworkInterfaceWrap::COMGETTER(HardwareAddress)(BSTR *aHardwareAddress)
{
    LogRelFlow(("{%p} %s: enter aHardwareAddress=%p\n", this, "HostNetworkInterface::getHardwareAddress", aHardwareAddress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHardwareAddress);
        BSTROutConverter TmpHardwareAddress(aHardwareAddress);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_HARDWAREADDRESS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHardwareAddress(TmpHardwareAddress.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_HARDWAREADDRESS_RETURN(this, hrc, 0 /*normal*/,TmpHardwareAddress.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_HARDWAREADDRESS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_HARDWAREADDRESS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHardwareAddress=%ls hrc=%Rhrc\n", this, "HostNetworkInterface::getHardwareAddress", *aHardwareAddress, hrc));
    return hrc;
}

STDMETHODIMP HostNetworkInterfaceWrap::COMGETTER(MediumType)(HostNetworkInterfaceMediumType_T *aMediumType)
{
    LogRelFlow(("{%p} %s: enter aMediumType=%p\n", this, "HostNetworkInterface::getMediumType", aMediumType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMediumType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_MEDIUMTYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMediumType(aMediumType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_MEDIUMTYPE_RETURN(this, hrc, 0 /*normal*/,*aMediumType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_MEDIUMTYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aMediumType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_MEDIUMTYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aMediumType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMediumType=%RU32 hrc=%Rhrc\n", this, "HostNetworkInterface::getMediumType", *aMediumType, hrc));
    return hrc;
}

STDMETHODIMP HostNetworkInterfaceWrap::COMGETTER(Status)(HostNetworkInterfaceStatus_T *aStatus)
{
    LogRelFlow(("{%p} %s: enter aStatus=%p\n", this, "HostNetworkInterface::getStatus", aStatus));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aStatus);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_STATUS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getStatus(aStatus);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_STATUS_RETURN(this, hrc, 0 /*normal*/,*aStatus);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_STATUS_RETURN(this, hrc, 1 /*hrc exception*/,*aStatus);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_STATUS_RETURN(this, hrc, 9 /*unhandled exception*/,*aStatus);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aStatus=%RU32 hrc=%Rhrc\n", this, "HostNetworkInterface::getStatus", *aStatus, hrc));
    return hrc;
}

STDMETHODIMP HostNetworkInterfaceWrap::COMGETTER(InterfaceType)(HostNetworkInterfaceType_T *aInterfaceType)
{
    LogRelFlow(("{%p} %s: enter aInterfaceType=%p\n", this, "HostNetworkInterface::getInterfaceType", aInterfaceType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aInterfaceType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_INTERFACETYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getInterfaceType(aInterfaceType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_INTERFACETYPE_RETURN(this, hrc, 0 /*normal*/,*aInterfaceType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_INTERFACETYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aInterfaceType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_INTERFACETYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aInterfaceType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aInterfaceType=%RU32 hrc=%Rhrc\n", this, "HostNetworkInterface::getInterfaceType", *aInterfaceType, hrc));
    return hrc;
}

STDMETHODIMP HostNetworkInterfaceWrap::COMGETTER(Wireless)(BOOL *aWireless)
{
    LogRelFlow(("{%p} %s: enter aWireless=%p\n", this, "HostNetworkInterface::getWireless", aWireless));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aWireless);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_WIRELESS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getWireless(aWireless);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_WIRELESS_RETURN(this, hrc, 0 /*normal*/,*aWireless != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_WIRELESS_RETURN(this, hrc, 1 /*hrc exception*/,*aWireless != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_GET_WIRELESS_RETURN(this, hrc, 9 /*unhandled exception*/,*aWireless != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aWireless=%RTbool hrc=%Rhrc\n", this, "HostNetworkInterface::getWireless", *aWireless, hrc));
    return hrc;
}

STDMETHODIMP HostNetworkInterfaceWrap::COMGETTER(InternalAndReservedAttribute1IHostNetworkInterface)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostNetworkInterfaceWrap::COMGETTER(InternalAndReservedAttribute2IHostNetworkInterface)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostNetworkInterfaceWrap::COMGETTER(InternalAndReservedAttribute3IHostNetworkInterface)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostNetworkInterfaceWrap::COMGETTER(InternalAndReservedAttribute4IHostNetworkInterface)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IHostNetworkInterface methods
//

STDMETHODIMP HostNetworkInterfaceWrap::EnableStaticIPConfig(IN_BSTR aIPAddress,
                                                            IN_BSTR aNetworkMask)
{
    LogRelFlow(("{%p} %s:enter aIPAddress=%ls aNetworkMask=%ls\n", this, "HostNetworkInterface::enableStaticIPConfig", aIPAddress, aNetworkMask));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpIPAddress(aIPAddress);
        BSTRInConverter TmpNetworkMask(aNetworkMask);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_ENABLESTATICIPCONFIG_ENTER(this, TmpIPAddress.str().c_str(), TmpNetworkMask.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = enableStaticIPConfig(TmpIPAddress.str(),
                                       TmpNetworkMask.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_ENABLESTATICIPCONFIG_RETURN(this, hrc, 0 /*normal*/, TmpIPAddress.str().c_str(), TmpNetworkMask.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_ENABLESTATICIPCONFIG_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_ENABLESTATICIPCONFIG_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "HostNetworkInterface::enableStaticIPConfig", hrc));
    return hrc;
}

STDMETHODIMP HostNetworkInterfaceWrap::EnableStaticIPConfigV6(IN_BSTR aIPV6Address,
                                                              ULONG aIPV6NetworkMaskPrefixLength)
{
    LogRelFlow(("{%p} %s:enter aIPV6Address=%ls aIPV6NetworkMaskPrefixLength=%RU32\n", this, "HostNetworkInterface::enableStaticIPConfigV6", aIPV6Address, aIPV6NetworkMaskPrefixLength));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpIPV6Address(aIPV6Address);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_ENABLESTATICIPCONFIGV6_ENTER(this, TmpIPV6Address.str().c_str(), aIPV6NetworkMaskPrefixLength);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = enableStaticIPConfigV6(TmpIPV6Address.str(),
                                         aIPV6NetworkMaskPrefixLength);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_ENABLESTATICIPCONFIGV6_RETURN(this, hrc, 0 /*normal*/, TmpIPV6Address.str().c_str(), aIPV6NetworkMaskPrefixLength);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_ENABLESTATICIPCONFIGV6_RETURN(this, hrc, 1 /*hrc exception*/, 0, aIPV6NetworkMaskPrefixLength);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_ENABLESTATICIPCONFIGV6_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aIPV6NetworkMaskPrefixLength);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "HostNetworkInterface::enableStaticIPConfigV6", hrc));
    return hrc;
}

STDMETHODIMP HostNetworkInterfaceWrap::EnableDynamicIPConfig()
{
    LogRelFlow(("{%p} %s:enter\n", this, "HostNetworkInterface::enableDynamicIPConfig"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_ENABLEDYNAMICIPCONFIG_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = enableDynamicIPConfig();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_ENABLEDYNAMICIPCONFIG_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_ENABLEDYNAMICIPCONFIG_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_ENABLEDYNAMICIPCONFIG_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "HostNetworkInterface::enableDynamicIPConfig", hrc));
    return hrc;
}

STDMETHODIMP HostNetworkInterfaceWrap::DHCPRediscover()
{
    LogRelFlow(("{%p} %s:enter\n", this, "HostNetworkInterface::DHCPRediscover"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_DHCPREDISCOVER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = DHCPRediscover();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_DHCPREDISCOVER_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_DHCPREDISCOVER_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTNETWORKINTERFACE_DHCPREDISCOVER_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "HostNetworkInterface::DHCPRediscover", hrc));
    return hrc;
}

STDMETHODIMP HostNetworkInterfaceWrap::InternalAndReservedMethod1IHostNetworkInterface()
{
    return E_NOTIMPL;
}

STDMETHODIMP HostNetworkInterfaceWrap::InternalAndReservedMethod2IHostNetworkInterface()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(HostNetworkInterfaceWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(HostNetworkInterfaceWrap, IHostNetworkInterface)
#endif // VBOX_WITH_XPCOM

