// ##### ENDFILE "CloudNetworkEnvironmentInfoWrap.cpp"


// ##### BEGINFILE "CloudProfileWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for ICloudProfile.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_CLOUDPROFILE

#include "CloudProfileWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(CloudProfileWrap)

//
// ICloudProfile properties
//

STDMETHODIMP CloudProfileWrap::COMGETTER(Name)(BSTR *aName)
{
    LogRelFlow(("{%p} %s: enter aName=%p\n", this, "CloudProfile::getName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aName);
        BSTROutConverter TmpName(aName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_GET_NAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_GET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_GET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_GET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aName=%ls hrc=%Rhrc\n", this, "CloudProfile::getName", *aName, hrc));
    return hrc;
}

STDMETHODIMP CloudProfileWrap::COMSETTER(Name)(IN_BSTR aName)
{
    LogRelFlow(("{%p} %s: enter aName=%ls\n", this, "CloudProfile::setName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpName(aName);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_SET_NAME_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_SET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_SET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_SET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "CloudProfile::setName", hrc));
    return hrc;
}

STDMETHODIMP CloudProfileWrap::COMGETTER(ProviderId)(BSTR *aProviderId)
{
    LogRelFlow(("{%p} %s: enter aProviderId=%p\n", this, "CloudProfile::getProviderId", aProviderId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProviderId);
        UuidOutConverter TmpProviderId(aProviderId);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_GET_PROVIDERID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProviderId(TmpProviderId.uuid());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_GET_PROVIDERID_RETURN(this, hrc, 0 /*normal*/,TmpProviderId.uuid().toStringCurly().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_GET_PROVIDERID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_GET_PROVIDERID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aProviderId=%ls hrc=%Rhrc\n", this, "CloudProfile::getProviderId", *aProviderId, hrc));
    return hrc;
}

STDMETHODIMP CloudProfileWrap::COMGETTER(InternalAndReservedAttribute1ICloudProfile)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudProfileWrap::COMGETTER(InternalAndReservedAttribute2ICloudProfile)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudProfileWrap::COMGETTER(InternalAndReservedAttribute3ICloudProfile)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudProfileWrap::COMGETTER(InternalAndReservedAttribute4ICloudProfile)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudProfileWrap::COMGETTER(InternalAndReservedAttribute5ICloudProfile)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudProfileWrap::COMGETTER(InternalAndReservedAttribute6ICloudProfile)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudProfileWrap::COMGETTER(InternalAndReservedAttribute7ICloudProfile)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudProfileWrap::COMGETTER(InternalAndReservedAttribute8ICloudProfile)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// ICloudProfile methods
//

STDMETHODIMP CloudProfileWrap::GetProperty(IN_BSTR aName,
                                           BSTR *aValue)
{
    LogRelFlow(("{%p} %s:enter aName=%ls aValue=%p\n", this, "CloudProfile::getProperty", aName, aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aValue);


        BSTRInConverter TmpName(aName);
        BSTROutConverter TmpValue(aValue);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_GETPROPERTY_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProperty(TmpName.str(),
                              TmpValue.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_GETPROPERTY_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), TmpValue.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_GETPROPERTY_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_GETPROPERTY_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aValue=%ls hrc=%Rhrc\n", this, "CloudProfile::getProperty", *aValue, hrc));
    return hrc;
}

STDMETHODIMP CloudProfileWrap::SetProperty(IN_BSTR aName,
                                           IN_BSTR aValue)
{
    LogRelFlow(("{%p} %s:enter aName=%ls aValue=%ls\n", this, "CloudProfile::setProperty", aName, aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);
        BSTRInConverter TmpValue(aValue);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_SETPROPERTY_ENTER(this, TmpName.str().c_str(), TmpValue.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setProperty(TmpName.str(),
                              TmpValue.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_SETPROPERTY_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), TmpValue.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_SETPROPERTY_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_SETPROPERTY_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "CloudProfile::setProperty", hrc));
    return hrc;
}

STDMETHODIMP CloudProfileWrap::GetProperties(IN_BSTR aNames,
                                             ComSafeArrayOut(BSTR, aReturnNames),
                                             ComSafeArrayOut(BSTR, aReturnValues))
{
    LogRelFlow(("{%p} %s:enter aNames=%ls aReturnNames=%p aReturnValues=%p\n", this, "CloudProfile::getProperties", aNames, aReturnNames, aReturnValues));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aReturnNames);
        CheckComArgOutPointerValidThrow(aReturnValues);


        BSTRInConverter TmpNames(aNames);
        ArrayBSTROutConverter TmpReturnNames(ComSafeArrayOutArg(aReturnNames));
        ArrayBSTROutConverter TmpReturnValues(ComSafeArrayOutArg(aReturnValues));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_GETPROPERTIES_ENTER(this, TmpNames.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProperties(TmpNames.str(),
                                TmpReturnNames.array(),
                                TmpReturnValues.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_GETPROPERTIES_RETURN(this, hrc, 0 /*normal*/, TmpNames.str().c_str(), (uint32_t)TmpReturnNames.array().size(), NULL /*for now*/, (uint32_t)TmpReturnValues.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_GETPROPERTIES_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_GETPROPERTIES_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aReturnNames=%zu aReturnValues=%zu hrc=%Rhrc\n", this, "CloudProfile::getProperties", ComSafeArraySize(*aReturnNames), ComSafeArraySize(*aReturnValues), hrc));
    return hrc;
}

STDMETHODIMP CloudProfileWrap::SetProperties(ComSafeArrayIn(IN_BSTR, aNames),
                                             ComSafeArrayIn(IN_BSTR, aValues))
{
    LogRelFlow(("{%p} %s:enter aNames=%zu aValues=%zu\n", this, "CloudProfile::setProperties", aNames, aValues));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ArrayBSTRInConverter TmpNames(ComSafeArrayInArg(aNames));
        ArrayBSTRInConverter TmpValues(ComSafeArrayInArg(aValues));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_SETPROPERTIES_ENTER(this, (uint32_t)TmpNames.array().size(), NULL /*for now*/, (uint32_t)TmpValues.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setProperties(TmpNames.array(),
                                TmpValues.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_SETPROPERTIES_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpNames.array().size(), NULL /*for now*/, (uint32_t)TmpValues.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_SETPROPERTIES_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_SETPROPERTIES_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "CloudProfile::setProperties", hrc));
    return hrc;
}

STDMETHODIMP CloudProfileWrap::Remove()
{
    LogRelFlow(("{%p} %s:enter\n", this, "CloudProfile::remove"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_REMOVE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = remove();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_REMOVE_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_REMOVE_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_REMOVE_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "CloudProfile::remove", hrc));
    return hrc;
}

STDMETHODIMP CloudProfileWrap::CreateCloudClient(ICloudClient **aCloudClient)
{
    LogRelFlow(("{%p} %s:enter aCloudClient=%p\n", this, "CloudProfile::createCloudClient", aCloudClient));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCloudClient);


        ComTypeOutConverter<ICloudClient> TmpCloudClient(aCloudClient);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_CREATECLOUDCLIENT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = createCloudClient(TmpCloudClient.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_CREATECLOUDCLIENT_RETURN(this, hrc, 0 /*normal*/, (void *)TmpCloudClient.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_CREATECLOUDCLIENT_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROFILE_CREATECLOUDCLIENT_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aCloudClient=%p hrc=%Rhrc\n", this, "CloudProfile::createCloudClient", *aCloudClient, hrc));
    return hrc;
}

STDMETHODIMP CloudProfileWrap::InternalAndReservedMethod1ICloudProfile()
{
    return E_NOTIMPL;
}

STDMETHODIMP CloudProfileWrap::InternalAndReservedMethod2ICloudProfile()
{
    return E_NOTIMPL;
}

STDMETHODIMP CloudProfileWrap::InternalAndReservedMethod3ICloudProfile()
{
    return E_NOTIMPL;
}

STDMETHODIMP CloudProfileWrap::InternalAndReservedMethod4ICloudProfile()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(CloudProfileWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(CloudProfileWrap, ICloudProfile)
#endif // VBOX_WITH_XPCOM

