// ##### ENDFILE "DHCPGroupConditionWrap.cpp"


// ##### BEGINFILE "DHCPIndividualConfigWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IDHCPIndividualConfig.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_DHCPINDIVIDUALCONFIG

#include "DHCPIndividualConfigWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(DHCPIndividualConfigWrap)

//
// IDHCPConfig properties
//

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(Scope)(DHCPConfigScope_T *aScope)
{
    LogRelFlow(("{%p} %s: enter aScope=%p\n", this, "DHCPIndividualConfig::getScope", aScope));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aScope);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_SCOPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getScope(aScope);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_SCOPE_RETURN(this, hrc, 0 /*normal*/,*aScope);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_SCOPE_RETURN(this, hrc, 1 /*hrc exception*/,*aScope);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_SCOPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aScope);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aScope=%RU32 hrc=%Rhrc\n", this, "DHCPIndividualConfig::getScope", *aScope, hrc));
    return hrc;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(MinLeaseTime)(ULONG *aMinLeaseTime)
{
    LogRelFlow(("{%p} %s: enter aMinLeaseTime=%p\n", this, "DHCPIndividualConfig::getMinLeaseTime", aMinLeaseTime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMinLeaseTime);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_MINLEASETIME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMinLeaseTime(aMinLeaseTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_MINLEASETIME_RETURN(this, hrc, 0 /*normal*/,*aMinLeaseTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_MINLEASETIME_RETURN(this, hrc, 1 /*hrc exception*/,*aMinLeaseTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_MINLEASETIME_RETURN(this, hrc, 9 /*unhandled exception*/,*aMinLeaseTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMinLeaseTime=%RU32 hrc=%Rhrc\n", this, "DHCPIndividualConfig::getMinLeaseTime", *aMinLeaseTime, hrc));
    return hrc;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMSETTER(MinLeaseTime)(ULONG aMinLeaseTime)
{
    LogRelFlow(("{%p} %s: enter aMinLeaseTime=%RU32\n", this, "DHCPIndividualConfig::setMinLeaseTime", aMinLeaseTime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_SET_MINLEASETIME_ENTER(this, aMinLeaseTime);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setMinLeaseTime(aMinLeaseTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_SET_MINLEASETIME_RETURN(this, hrc, 0 /*normal*/,aMinLeaseTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_SET_MINLEASETIME_RETURN(this, hrc, 1 /*hrc exception*/,aMinLeaseTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_SET_MINLEASETIME_RETURN(this, hrc, 9 /*unhandled exception*/,aMinLeaseTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPIndividualConfig::setMinLeaseTime", hrc));
    return hrc;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(DefaultLeaseTime)(ULONG *aDefaultLeaseTime)
{
    LogRelFlow(("{%p} %s: enter aDefaultLeaseTime=%p\n", this, "DHCPIndividualConfig::getDefaultLeaseTime", aDefaultLeaseTime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDefaultLeaseTime);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_DEFAULTLEASETIME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDefaultLeaseTime(aDefaultLeaseTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_DEFAULTLEASETIME_RETURN(this, hrc, 0 /*normal*/,*aDefaultLeaseTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_DEFAULTLEASETIME_RETURN(this, hrc, 1 /*hrc exception*/,*aDefaultLeaseTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_DEFAULTLEASETIME_RETURN(this, hrc, 9 /*unhandled exception*/,*aDefaultLeaseTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDefaultLeaseTime=%RU32 hrc=%Rhrc\n", this, "DHCPIndividualConfig::getDefaultLeaseTime", *aDefaultLeaseTime, hrc));
    return hrc;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMSETTER(DefaultLeaseTime)(ULONG aDefaultLeaseTime)
{
    LogRelFlow(("{%p} %s: enter aDefaultLeaseTime=%RU32\n", this, "DHCPIndividualConfig::setDefaultLeaseTime", aDefaultLeaseTime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_SET_DEFAULTLEASETIME_ENTER(this, aDefaultLeaseTime);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setDefaultLeaseTime(aDefaultLeaseTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_SET_DEFAULTLEASETIME_RETURN(this, hrc, 0 /*normal*/,aDefaultLeaseTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_SET_DEFAULTLEASETIME_RETURN(this, hrc, 1 /*hrc exception*/,aDefaultLeaseTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_SET_DEFAULTLEASETIME_RETURN(this, hrc, 9 /*unhandled exception*/,aDefaultLeaseTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPIndividualConfig::setDefaultLeaseTime", hrc));
    return hrc;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(MaxLeaseTime)(ULONG *aMaxLeaseTime)
{
    LogRelFlow(("{%p} %s: enter aMaxLeaseTime=%p\n", this, "DHCPIndividualConfig::getMaxLeaseTime", aMaxLeaseTime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMaxLeaseTime);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_MAXLEASETIME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMaxLeaseTime(aMaxLeaseTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_MAXLEASETIME_RETURN(this, hrc, 0 /*normal*/,*aMaxLeaseTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_MAXLEASETIME_RETURN(this, hrc, 1 /*hrc exception*/,*aMaxLeaseTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_MAXLEASETIME_RETURN(this, hrc, 9 /*unhandled exception*/,*aMaxLeaseTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMaxLeaseTime=%RU32 hrc=%Rhrc\n", this, "DHCPIndividualConfig::getMaxLeaseTime", *aMaxLeaseTime, hrc));
    return hrc;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMSETTER(MaxLeaseTime)(ULONG aMaxLeaseTime)
{
    LogRelFlow(("{%p} %s: enter aMaxLeaseTime=%RU32\n", this, "DHCPIndividualConfig::setMaxLeaseTime", aMaxLeaseTime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_SET_MAXLEASETIME_ENTER(this, aMaxLeaseTime);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setMaxLeaseTime(aMaxLeaseTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_SET_MAXLEASETIME_RETURN(this, hrc, 0 /*normal*/,aMaxLeaseTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_SET_MAXLEASETIME_RETURN(this, hrc, 1 /*hrc exception*/,aMaxLeaseTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_SET_MAXLEASETIME_RETURN(this, hrc, 9 /*unhandled exception*/,aMaxLeaseTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPIndividualConfig::setMaxLeaseTime", hrc));
    return hrc;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(ForcedOptions)(ComSafeArrayOut(DHCPOption_T, aForcedOptions))
{
    LogRelFlow(("{%p} %s: enter aForcedOptions=%p\n", this, "DHCPIndividualConfig::getForcedOptions", aForcedOptions));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aForcedOptions);
        ArrayOutConverter<DHCPOption_T> TmpForcedOptions(ComSafeArrayOutArg(aForcedOptions));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_FORCEDOPTIONS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getForcedOptions(TmpForcedOptions.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_FORCEDOPTIONS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpForcedOptions.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_FORCEDOPTIONS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_FORCEDOPTIONS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aForcedOptions=%zu hrc=%Rhrc\n", this, "DHCPIndividualConfig::getForcedOptions", ComSafeArraySize(*aForcedOptions), hrc));
    return hrc;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMSETTER(ForcedOptions)(ComSafeArrayIn(DHCPOption_T, aForcedOptions))
{
    LogRelFlow(("{%p} %s: enter aForcedOptions=%zu\n", this, "DHCPIndividualConfig::setForcedOptions", ComSafeArraySize(aForcedOptions)));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        ArrayInConverter<DHCPOption_T> TmpForcedOptions(ComSafeArrayInArg(aForcedOptions));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_SET_FORCEDOPTIONS_ENTER(this, (uint32_t)TmpForcedOptions.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setForcedOptions(TmpForcedOptions.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_SET_FORCEDOPTIONS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpForcedOptions.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_SET_FORCEDOPTIONS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_SET_FORCEDOPTIONS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPIndividualConfig::setForcedOptions", hrc));
    return hrc;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(SuppressedOptions)(ComSafeArrayOut(DHCPOption_T, aSuppressedOptions))
{
    LogRelFlow(("{%p} %s: enter aSuppressedOptions=%p\n", this, "DHCPIndividualConfig::getSuppressedOptions", aSuppressedOptions));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSuppressedOptions);
        ArrayOutConverter<DHCPOption_T> TmpSuppressedOptions(ComSafeArrayOutArg(aSuppressedOptions));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_SUPPRESSEDOPTIONS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSuppressedOptions(TmpSuppressedOptions.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_SUPPRESSEDOPTIONS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSuppressedOptions.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_SUPPRESSEDOPTIONS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_SUPPRESSEDOPTIONS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSuppressedOptions=%zu hrc=%Rhrc\n", this, "DHCPIndividualConfig::getSuppressedOptions", ComSafeArraySize(*aSuppressedOptions), hrc));
    return hrc;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMSETTER(SuppressedOptions)(ComSafeArrayIn(DHCPOption_T, aSuppressedOptions))
{
    LogRelFlow(("{%p} %s: enter aSuppressedOptions=%zu\n", this, "DHCPIndividualConfig::setSuppressedOptions", ComSafeArraySize(aSuppressedOptions)));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        ArrayInConverter<DHCPOption_T> TmpSuppressedOptions(ComSafeArrayInArg(aSuppressedOptions));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_SET_SUPPRESSEDOPTIONS_ENTER(this, (uint32_t)TmpSuppressedOptions.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setSuppressedOptions(TmpSuppressedOptions.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_SET_SUPPRESSEDOPTIONS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSuppressedOptions.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_SET_SUPPRESSEDOPTIONS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_SET_SUPPRESSEDOPTIONS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPIndividualConfig::setSuppressedOptions", hrc));
    return hrc;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(InternalAndReservedAttribute1IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(InternalAndReservedAttribute2IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(InternalAndReservedAttribute3IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(InternalAndReservedAttribute4IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(InternalAndReservedAttribute5IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(InternalAndReservedAttribute6IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(InternalAndReservedAttribute7IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(InternalAndReservedAttribute8IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(InternalAndReservedAttribute9IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(InternalAndReservedAttribute10IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(InternalAndReservedAttribute11IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(InternalAndReservedAttribute12IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(InternalAndReservedAttribute13IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(InternalAndReservedAttribute14IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(InternalAndReservedAttribute15IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(InternalAndReservedAttribute16IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

//
// IDHCPIndividualConfig properties
//

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(MACAddress)(BSTR *aMACAddress)
{
    LogRelFlow(("{%p} %s: enter aMACAddress=%p\n", this, "DHCPIndividualConfig::getMACAddress", aMACAddress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMACAddress);
        BSTROutConverter TmpMACAddress(aMACAddress);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_MACADDRESS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMACAddress(TmpMACAddress.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_MACADDRESS_RETURN(this, hrc, 0 /*normal*/,TmpMACAddress.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_MACADDRESS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_MACADDRESS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMACAddress=%ls hrc=%Rhrc\n", this, "DHCPIndividualConfig::getMACAddress", *aMACAddress, hrc));
    return hrc;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(MachineId)(BSTR *aMachineId)
{
    LogRelFlow(("{%p} %s: enter aMachineId=%p\n", this, "DHCPIndividualConfig::getMachineId", aMachineId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMachineId);
        UuidOutConverter TmpMachineId(aMachineId);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_MACHINEID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMachineId(TmpMachineId.uuid());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_MACHINEID_RETURN(this, hrc, 0 /*normal*/,TmpMachineId.uuid().toStringCurly().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_MACHINEID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_MACHINEID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMachineId=%ls hrc=%Rhrc\n", this, "DHCPIndividualConfig::getMachineId", *aMachineId, hrc));
    return hrc;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(Slot)(ULONG *aSlot)
{
    LogRelFlow(("{%p} %s: enter aSlot=%p\n", this, "DHCPIndividualConfig::getSlot", aSlot));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSlot);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_SLOT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSlot(aSlot);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_SLOT_RETURN(this, hrc, 0 /*normal*/,*aSlot);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_SLOT_RETURN(this, hrc, 1 /*hrc exception*/,*aSlot);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_SLOT_RETURN(this, hrc, 9 /*unhandled exception*/,*aSlot);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSlot=%RU32 hrc=%Rhrc\n", this, "DHCPIndividualConfig::getSlot", *aSlot, hrc));
    return hrc;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(FixedAddress)(BSTR *aFixedAddress)
{
    LogRelFlow(("{%p} %s: enter aFixedAddress=%p\n", this, "DHCPIndividualConfig::getFixedAddress", aFixedAddress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFixedAddress);
        BSTROutConverter TmpFixedAddress(aFixedAddress);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_FIXEDADDRESS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getFixedAddress(TmpFixedAddress.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_FIXEDADDRESS_RETURN(this, hrc, 0 /*normal*/,TmpFixedAddress.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_FIXEDADDRESS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GET_FIXEDADDRESS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aFixedAddress=%ls hrc=%Rhrc\n", this, "DHCPIndividualConfig::getFixedAddress", *aFixedAddress, hrc));
    return hrc;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMSETTER(FixedAddress)(IN_BSTR aFixedAddress)
{
    LogRelFlow(("{%p} %s: enter aFixedAddress=%ls\n", this, "DHCPIndividualConfig::setFixedAddress", aFixedAddress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpFixedAddress(aFixedAddress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_SET_FIXEDADDRESS_ENTER(this, TmpFixedAddress.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setFixedAddress(TmpFixedAddress.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_SET_FIXEDADDRESS_RETURN(this, hrc, 0 /*normal*/,TmpFixedAddress.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_SET_FIXEDADDRESS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_SET_FIXEDADDRESS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPIndividualConfig::setFixedAddress", hrc));
    return hrc;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(InternalAndReservedAttribute1IDHCPIndividualConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(InternalAndReservedAttribute2IDHCPIndividualConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(InternalAndReservedAttribute3IDHCPIndividualConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(InternalAndReservedAttribute4IDHCPIndividualConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(InternalAndReservedAttribute5IDHCPIndividualConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(InternalAndReservedAttribute6IDHCPIndividualConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(InternalAndReservedAttribute7IDHCPIndividualConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::COMGETTER(InternalAndReservedAttribute8IDHCPIndividualConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IDHCPConfig methods
//

STDMETHODIMP DHCPIndividualConfigWrap::SetOption(DHCPOption_T aOption,
                                                 DHCPOptionEncoding_T aEncoding,
                                                 IN_BSTR aValue)
{
    LogRelFlow(("{%p} %s:enter aOption=%RU32 aEncoding=%RU32 aValue=%ls\n", this, "DHCPIndividualConfig::setOption", aOption, aEncoding, aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        
        BSTRInConverter TmpValue(aValue);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_SETOPTION_ENTER(this, aOption, aEncoding, TmpValue.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setOption(aOption,
                            aEncoding,
                            TmpValue.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_SETOPTION_RETURN(this, hrc, 0 /*normal*/, aOption, aEncoding, TmpValue.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_SETOPTION_RETURN(this, hrc, 1 /*hrc exception*/, aOption, aEncoding, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_SETOPTION_RETURN(this, hrc, 9 /*unhandled exception*/, aOption, aEncoding, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPIndividualConfig::setOption", hrc));
    return hrc;
}

STDMETHODIMP DHCPIndividualConfigWrap::RemoveOption(DHCPOption_T aOption)
{
    LogRelFlow(("{%p} %s:enter aOption=%RU32\n", this, "DHCPIndividualConfig::removeOption", aOption));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_REMOVEOPTION_ENTER(this, aOption);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = removeOption(aOption);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_REMOVEOPTION_RETURN(this, hrc, 0 /*normal*/, aOption);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_REMOVEOPTION_RETURN(this, hrc, 1 /*hrc exception*/, aOption);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_REMOVEOPTION_RETURN(this, hrc, 9 /*unhandled exception*/, aOption);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPIndividualConfig::removeOption", hrc));
    return hrc;
}

STDMETHODIMP DHCPIndividualConfigWrap::RemoveAllOptions()
{
    LogRelFlow(("{%p} %s:enter\n", this, "DHCPIndividualConfig::removeAllOptions"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_REMOVEALLOPTIONS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = removeAllOptions();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_REMOVEALLOPTIONS_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_REMOVEALLOPTIONS_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_REMOVEALLOPTIONS_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPIndividualConfig::removeAllOptions", hrc));
    return hrc;
}

STDMETHODIMP DHCPIndividualConfigWrap::GetOption(DHCPOption_T aOption,
                                                 DHCPOptionEncoding_T *aEncoding,
                                                 BSTR *aValue)
{
    LogRelFlow(("{%p} %s:enter aOption=%RU32 aEncoding=%p aValue=%p\n", this, "DHCPIndividualConfig::getOption", aOption, aEncoding, aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEncoding);
        CheckComArgOutPointerValidThrow(aValue);


        
        
        BSTROutConverter TmpValue(aValue);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GETOPTION_ENTER(this, aOption);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getOption(aOption,
                            aEncoding,
                            TmpValue.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GETOPTION_RETURN(this, hrc, 0 /*normal*/, aOption, *aEncoding, TmpValue.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GETOPTION_RETURN(this, hrc, 1 /*hrc exception*/, aOption, *aEncoding, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GETOPTION_RETURN(this, hrc, 9 /*unhandled exception*/, aOption, *aEncoding, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEncoding=%RU32 aValue=%ls hrc=%Rhrc\n", this, "DHCPIndividualConfig::getOption", *aEncoding, *aValue, hrc));
    return hrc;
}

STDMETHODIMP DHCPIndividualConfigWrap::GetAllOptions(ComSafeArrayOut(DHCPOption_T, aOptions),
                                                     ComSafeArrayOut(DHCPOptionEncoding_T, aEncodings),
                                                     ComSafeArrayOut(BSTR, aValues))
{
    LogRelFlow(("{%p} %s:enter aOptions=%p aEncodings=%p aValues=%p\n", this, "DHCPIndividualConfig::getAllOptions", aOptions, aEncodings, aValues));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aOptions);
        CheckComArgOutPointerValidThrow(aEncodings);
        CheckComArgOutPointerValidThrow(aValues);


        ArrayOutConverter<DHCPOption_T> TmpOptions(ComSafeArrayOutArg(aOptions));
        ArrayOutConverter<DHCPOptionEncoding_T> TmpEncodings(ComSafeArrayOutArg(aEncodings));
        ArrayBSTROutConverter TmpValues(ComSafeArrayOutArg(aValues));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GETALLOPTIONS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAllOptions(TmpOptions.array(),
                                TmpEncodings.array(),
                                TmpValues.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GETALLOPTIONS_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpOptions.array().size(), NULL /*for now*/, (uint32_t)TmpEncodings.array().size(), NULL /*for now*/, (uint32_t)TmpValues.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GETALLOPTIONS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_GETALLOPTIONS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aOptions=%zu *aEncodings=%zu aValues=%zu hrc=%Rhrc\n", this, "DHCPIndividualConfig::getAllOptions", ComSafeArraySize(*aOptions), ComSafeArraySize(*aEncodings), ComSafeArraySize(*aValues), hrc));
    return hrc;
}

STDMETHODIMP DHCPIndividualConfigWrap::Remove()
{
    LogRelFlow(("{%p} %s:enter\n", this, "DHCPIndividualConfig::remove"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_REMOVE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = remove();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_REMOVE_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_REMOVE_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPINDIVIDUALCONFIG_REMOVE_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPIndividualConfig::remove", hrc));
    return hrc;
}

STDMETHODIMP DHCPIndividualConfigWrap::InternalAndReservedMethod1IDHCPConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::InternalAndReservedMethod2IDHCPConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::InternalAndReservedMethod3IDHCPConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::InternalAndReservedMethod4IDHCPConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::InternalAndReservedMethod5IDHCPConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::InternalAndReservedMethod6IDHCPConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::InternalAndReservedMethod7IDHCPConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::InternalAndReservedMethod8IDHCPConfig()
{
    return E_NOTIMPL;
}

//
// IDHCPIndividualConfig methods
//

STDMETHODIMP DHCPIndividualConfigWrap::InternalAndReservedMethod1IDHCPIndividualConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::InternalAndReservedMethod2IDHCPIndividualConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::InternalAndReservedMethod3IDHCPIndividualConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::InternalAndReservedMethod4IDHCPIndividualConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::InternalAndReservedMethod5IDHCPIndividualConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::InternalAndReservedMethod6IDHCPIndividualConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::InternalAndReservedMethod7IDHCPIndividualConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPIndividualConfigWrap::InternalAndReservedMethod8IDHCPIndividualConfig()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(DHCPIndividualConfigWrap)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(DHCPIndividualConfigWrap, IDHCPIndividualConfig, IDHCPConfig)
#endif // VBOX_WITH_XPCOM

