// ##### ENDFILE "StringFormValueWrap.cpp"


// ##### BEGINFILE "FormWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IForm.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_FORM

#include "FormWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(FormWrap)

//
// IForm properties
//

STDMETHODIMP FormWrap::COMGETTER(Values)(ComSafeArrayOut(IFormValue *, aValues))
{
    LogRelFlow(("{%p} %s: enter aValues=%p\n", this, "Form::getValues", aValues));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aValues);
        ArrayComTypeOutConverter<IFormValue> TmpValues(ComSafeArrayOutArg(aValues));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FORM_GET_VALUES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getValues(TmpValues.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FORM_GET_VALUES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpValues.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FORM_GET_VALUES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_FORM_GET_VALUES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aValues=%zu hrc=%Rhrc\n", this, "Form::getValues", ComSafeArraySize(*aValues), hrc));
    return hrc;
}

STDMETHODIMP FormWrap::COMGETTER(InternalAndReservedAttribute1IForm)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP FormWrap::COMGETTER(InternalAndReservedAttribute2IForm)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP FormWrap::COMGETTER(InternalAndReservedAttribute3IForm)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP FormWrap::COMGETTER(InternalAndReservedAttribute4IForm)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IForm methods
//

STDMETHODIMP FormWrap::InternalAndReservedMethod1IForm()
{
    return E_NOTIMPL;
}

STDMETHODIMP FormWrap::InternalAndReservedMethod2IForm()
{
    return E_NOTIMPL;
}

STDMETHODIMP FormWrap::InternalAndReservedMethod3IForm()
{
    return E_NOTIMPL;
}

STDMETHODIMP FormWrap::InternalAndReservedMethod4IForm()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(FormWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(FormWrap, IForm)
#endif // VBOX_WITH_XPCOM

