// ##### ENDFILE "FileWrap.h"


// ##### BEGINFILE "GuestFileWrap.h"
/** @file
 * VirtualBox API class wrapper header for IGuestFile.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#ifndef GuestFileWrap_H_
#define GuestFileWrap_H_
#ifndef RT_WITHOUT_PRAGMA_ONCE
# pragma once
#endif

#include "VirtualBoxBase.h"
#include "Wrapper.h"

class ATL_NO_VTABLE GuestFileWrap
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IGuestFile)
{
    Q_OBJECT

public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(GuestFileWrap, IGuestFile)
    DECLARE_NOT_AGGREGATABLE(GuestFileWrap)
    DECLARE_PROTECT_FINAL_CONSTRUCT()

    BEGIN_COM_MAP(GuestFileWrap)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IGuestFile)
        COM_INTERFACE_ENTRY(IFile)
        COM_INTERFACE_ENTRY2(IDispatch, IGuestFile)
        VBOX_TWEAK_INTERFACE_ENTRY(IGuestFile)
    END_COM_MAP()

    DECLARE_EMPTY_CTOR_DTOR(GuestFileWrap)

    /** @name Public IFile properties
     * @{ */
    STDMETHOD(COMGETTER(EventSource))(IEventSource **aEventSource);
    STDMETHOD(COMGETTER(Id))(ULONG *aId);
    STDMETHOD(COMGETTER(InitialSize))(LONG64 *aInitialSize);
    STDMETHOD(COMGETTER(Offset))(LONG64 *aOffset);
    STDMETHOD(COMGETTER(Status))(FileStatus_T *aStatus);
    STDMETHOD(COMGETTER(Filename))(BSTR *aFilename);
    STDMETHOD(COMGETTER(CreationMode))(ULONG *aCreationMode);
    STDMETHOD(COMGETTER(OpenAction))(FileOpenAction_T *aOpenAction);
    STDMETHOD(COMGETTER(AccessMode))(FileAccessMode_T *aAccessMode);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute1IFile))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute2IFile))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute3IFile))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute4IFile))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute5IFile))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute6IFile))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute7IFile))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute8IFile))(ULONG *aReserved);
    /** @} */

    /** @name Public IGuestFile properties
     * @{ */
    STDMETHOD(COMGETTER(MidlDoesNotLikeEmptyInterfaces))(BOOL *aMidlDoesNotLikeEmptyInterfaces);
    /** @} */

    /** @name Public IFile methods
     * @{ */
    STDMETHOD(Close)();
    STDMETHOD(QueryInfo)(IFsObjInfo **aObjInfo);
    STDMETHOD(QuerySize)(LONG64 *aSize);
    STDMETHOD(Read)(ULONG aToRead,
                    ULONG aTimeoutMS,
                    ComSafeArrayOut(BYTE, aData));
    STDMETHOD(ReadAt)(LONG64 aOffset,
                      ULONG aToRead,
                      ULONG aTimeoutMS,
                      ComSafeArrayOut(BYTE, aData));
    STDMETHOD(Seek)(LONG64 aOffset,
                    FileSeekOrigin_T aWhence,
                    LONG64 *aNewOffset);
    STDMETHOD(SetACL)(IN_BSTR aAcl,
                      ULONG aMode);
    STDMETHOD(SetSize)(LONG64 aSize);
    STDMETHOD(Write)(ComSafeArrayIn(BYTE, aData),
                     ULONG aTimeoutMS,
                     ULONG *aWritten);
    STDMETHOD(WriteAt)(LONG64 aOffset,
                       ComSafeArrayIn(BYTE, aData),
                       ULONG aTimeoutMS,
                       ULONG *aWritten);
    STDMETHOD(InternalAndReservedMethod1IFile)();
    STDMETHOD(InternalAndReservedMethod2IFile)();
    STDMETHOD(InternalAndReservedMethod3IFile)();
    STDMETHOD(InternalAndReservedMethod4IFile)();
    /** @} */

    /** @name Public IGuestFile methods
     * @{ */
    /** @} */

private:
    /** @name Wrapped IFile properties
     * @{ */
    virtual HRESULT getEventSource(ComPtr<IEventSource> &aEventSource) = 0;
    virtual HRESULT getId(ULONG *aId) = 0;
    virtual HRESULT getInitialSize(LONG64 *aInitialSize) = 0;
    virtual HRESULT getOffset(LONG64 *aOffset) = 0;
    virtual HRESULT getStatus(FileStatus_T *aStatus) = 0;
    virtual HRESULT getFilename(com::Utf8Str &aFilename) = 0;
    virtual HRESULT getCreationMode(ULONG *aCreationMode) = 0;
    virtual HRESULT getOpenAction(FileOpenAction_T *aOpenAction) = 0;
    virtual HRESULT getAccessMode(FileAccessMode_T *aAccessMode) = 0;
    /** @} */

    /** @name Wrapped IGuestFile properties
     * @{ */
    //    virtual HRESULT getMidlDoesNotLikeEmptyInterfaces(BOOL *aMidlDoesNotLikeEmptyInterfaces) = 0;
    /** @} */

    /** @name Wrapped IFile methods
     * @{ */
    virtual HRESULT close() = 0;
    virtual HRESULT queryInfo(ComPtr<IFsObjInfo> &aObjInfo) = 0;
    virtual HRESULT querySize(LONG64 *aSize) = 0;
    virtual HRESULT read(ULONG aToRead,
                         ULONG aTimeoutMS,
                         std::vector<BYTE> &aData) = 0;
    virtual HRESULT readAt(LONG64 aOffset,
                           ULONG aToRead,
                           ULONG aTimeoutMS,
                           std::vector<BYTE> &aData) = 0;
    virtual HRESULT seek(LONG64 aOffset,
                         FileSeekOrigin_T aWhence,
                         LONG64 *aNewOffset) = 0;
    virtual HRESULT setACL(const com::Utf8Str &aAcl,
                           ULONG aMode) = 0;
    virtual HRESULT setSize(LONG64 aSize) = 0;
    virtual HRESULT write(const std::vector<BYTE> &aData,
                          ULONG aTimeoutMS,
                          ULONG *aWritten) = 0;
    virtual HRESULT writeAt(LONG64 aOffset,
                            const std::vector<BYTE> &aData,
                            ULONG aTimeoutMS,
                            ULONG *aWritten) = 0;
    /** @} */

    /** @name Wrapped IGuestFile methods
     * @{ */
    /** @} */

private:
    DECLARE_CLS_COPY_CTOR_ASSIGN_NOOP(GuestFileWrap); /* Shuts up MSC warning C4625. */

};

#endif // !GuestFileWrap_H_

