// ##### ENDFILE "NATEngineWrap.cpp"


// ##### BEGINFILE "ExtPackBaseWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IExtPackBase.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_EXTPACKBASE

#include "ExtPackBaseWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(ExtPackBaseWrap)

//
// IExtPackBase properties
//

STDMETHODIMP ExtPackBaseWrap::COMGETTER(Name)(BSTR *aName)
{
    LogRelFlow(("{%p} %s: enter aName=%p\n", this, "ExtPackBase::getName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aName);
        BSTROutConverter TmpName(aName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_NAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aName=%ls hrc=%Rhrc\n", this, "ExtPackBase::getName", *aName, hrc));
    return hrc;
}

STDMETHODIMP ExtPackBaseWrap::COMGETTER(Description)(BSTR *aDescription)
{
    LogRelFlow(("{%p} %s: enter aDescription=%p\n", this, "ExtPackBase::getDescription", aDescription));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDescription);
        BSTROutConverter TmpDescription(aDescription);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_DESCRIPTION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDescription(TmpDescription.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_DESCRIPTION_RETURN(this, hrc, 0 /*normal*/,TmpDescription.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_DESCRIPTION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_DESCRIPTION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDescription=%ls hrc=%Rhrc\n", this, "ExtPackBase::getDescription", *aDescription, hrc));
    return hrc;
}

STDMETHODIMP ExtPackBaseWrap::COMGETTER(Version)(BSTR *aVersion)
{
    LogRelFlow(("{%p} %s: enter aVersion=%p\n", this, "ExtPackBase::getVersion", aVersion));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVersion);
        BSTROutConverter TmpVersion(aVersion);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_VERSION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVersion(TmpVersion.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_VERSION_RETURN(this, hrc, 0 /*normal*/,TmpVersion.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_VERSION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_VERSION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVersion=%ls hrc=%Rhrc\n", this, "ExtPackBase::getVersion", *aVersion, hrc));
    return hrc;
}

STDMETHODIMP ExtPackBaseWrap::COMGETTER(Revision)(ULONG *aRevision)
{
    LogRelFlow(("{%p} %s: enter aRevision=%p\n", this, "ExtPackBase::getRevision", aRevision));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRevision);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_REVISION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRevision(aRevision);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_REVISION_RETURN(this, hrc, 0 /*normal*/,*aRevision);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_REVISION_RETURN(this, hrc, 1 /*hrc exception*/,*aRevision);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_REVISION_RETURN(this, hrc, 9 /*unhandled exception*/,*aRevision);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRevision=%RU32 hrc=%Rhrc\n", this, "ExtPackBase::getRevision", *aRevision, hrc));
    return hrc;
}

STDMETHODIMP ExtPackBaseWrap::COMGETTER(Edition)(BSTR *aEdition)
{
    LogRelFlow(("{%p} %s: enter aEdition=%p\n", this, "ExtPackBase::getEdition", aEdition));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEdition);
        BSTROutConverter TmpEdition(aEdition);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_EDITION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEdition(TmpEdition.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_EDITION_RETURN(this, hrc, 0 /*normal*/,TmpEdition.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_EDITION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_EDITION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEdition=%ls hrc=%Rhrc\n", this, "ExtPackBase::getEdition", *aEdition, hrc));
    return hrc;
}

STDMETHODIMP ExtPackBaseWrap::COMGETTER(VRDEModule)(BSTR *aVRDEModule)
{
    LogRelFlow(("{%p} %s: enter aVRDEModule=%p\n", this, "ExtPackBase::getVRDEModule", aVRDEModule));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVRDEModule);
        BSTROutConverter TmpVRDEModule(aVRDEModule);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_VRDEMODULE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVRDEModule(TmpVRDEModule.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_VRDEMODULE_RETURN(this, hrc, 0 /*normal*/,TmpVRDEModule.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_VRDEMODULE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_VRDEMODULE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVRDEModule=%ls hrc=%Rhrc\n", this, "ExtPackBase::getVRDEModule", *aVRDEModule, hrc));
    return hrc;
}

STDMETHODIMP ExtPackBaseWrap::COMGETTER(PlugIns)(ComSafeArrayOut(IExtPackPlugIn *, aPlugIns))
{
    LogRelFlow(("{%p} %s: enter aPlugIns=%p\n", this, "ExtPackBase::getPlugIns", aPlugIns));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPlugIns);
        ArrayComTypeOutConverter<IExtPackPlugIn> TmpPlugIns(ComSafeArrayOutArg(aPlugIns));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_PLUGINS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPlugIns(TmpPlugIns.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_PLUGINS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpPlugIns.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_PLUGINS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_PLUGINS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPlugIns=%zu hrc=%Rhrc\n", this, "ExtPackBase::getPlugIns", ComSafeArraySize(*aPlugIns), hrc));
    return hrc;
}

STDMETHODIMP ExtPackBaseWrap::COMGETTER(Usable)(BOOL *aUsable)
{
    LogRelFlow(("{%p} %s: enter aUsable=%p\n", this, "ExtPackBase::getUsable", aUsable));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUsable);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_USABLE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUsable(aUsable);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_USABLE_RETURN(this, hrc, 0 /*normal*/,*aUsable != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_USABLE_RETURN(this, hrc, 1 /*hrc exception*/,*aUsable != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_USABLE_RETURN(this, hrc, 9 /*unhandled exception*/,*aUsable != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUsable=%RTbool hrc=%Rhrc\n", this, "ExtPackBase::getUsable", *aUsable, hrc));
    return hrc;
}

STDMETHODIMP ExtPackBaseWrap::COMGETTER(WhyUnusable)(BSTR *aWhyUnusable)
{
    LogRelFlow(("{%p} %s: enter aWhyUnusable=%p\n", this, "ExtPackBase::getWhyUnusable", aWhyUnusable));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aWhyUnusable);
        BSTROutConverter TmpWhyUnusable(aWhyUnusable);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_WHYUNUSABLE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getWhyUnusable(TmpWhyUnusable.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_WHYUNUSABLE_RETURN(this, hrc, 0 /*normal*/,TmpWhyUnusable.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_WHYUNUSABLE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_WHYUNUSABLE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aWhyUnusable=%ls hrc=%Rhrc\n", this, "ExtPackBase::getWhyUnusable", *aWhyUnusable, hrc));
    return hrc;
}

STDMETHODIMP ExtPackBaseWrap::COMGETTER(ShowLicense)(BOOL *aShowLicense)
{
    LogRelFlow(("{%p} %s: enter aShowLicense=%p\n", this, "ExtPackBase::getShowLicense", aShowLicense));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aShowLicense);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_SHOWLICENSE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getShowLicense(aShowLicense);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_SHOWLICENSE_RETURN(this, hrc, 0 /*normal*/,*aShowLicense != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_SHOWLICENSE_RETURN(this, hrc, 1 /*hrc exception*/,*aShowLicense != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_SHOWLICENSE_RETURN(this, hrc, 9 /*unhandled exception*/,*aShowLicense != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aShowLicense=%RTbool hrc=%Rhrc\n", this, "ExtPackBase::getShowLicense", *aShowLicense, hrc));
    return hrc;
}

STDMETHODIMP ExtPackBaseWrap::COMGETTER(License)(BSTR *aLicense)
{
    LogRelFlow(("{%p} %s: enter aLicense=%p\n", this, "ExtPackBase::getLicense", aLicense));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLicense);
        BSTROutConverter TmpLicense(aLicense);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_LICENSE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLicense(TmpLicense.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_LICENSE_RETURN(this, hrc, 0 /*normal*/,TmpLicense.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_LICENSE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_GET_LICENSE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLicense=%ls hrc=%Rhrc\n", this, "ExtPackBase::getLicense", *aLicense, hrc));
    return hrc;
}

STDMETHODIMP ExtPackBaseWrap::COMGETTER(InternalAndReservedAttribute1IExtPackBase)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackBaseWrap::COMGETTER(InternalAndReservedAttribute2IExtPackBase)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackBaseWrap::COMGETTER(InternalAndReservedAttribute3IExtPackBase)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackBaseWrap::COMGETTER(InternalAndReservedAttribute4IExtPackBase)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackBaseWrap::COMGETTER(InternalAndReservedAttribute5IExtPackBase)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackBaseWrap::COMGETTER(InternalAndReservedAttribute6IExtPackBase)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackBaseWrap::COMGETTER(InternalAndReservedAttribute7IExtPackBase)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackBaseWrap::COMGETTER(InternalAndReservedAttribute8IExtPackBase)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IExtPackBase methods
//

STDMETHODIMP ExtPackBaseWrap::QueryLicense(IN_BSTR aPreferredLocale,
                                           IN_BSTR aPreferredLanguage,
                                           IN_BSTR aFormat,
                                           BSTR *aLicenseText)
{
    LogRelFlow(("{%p} %s:enter aPreferredLocale=%ls aPreferredLanguage=%ls aFormat=%ls aLicenseText=%p\n", this, "ExtPackBase::queryLicense", aPreferredLocale, aPreferredLanguage, aFormat, aLicenseText));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLicenseText);


        BSTRInConverter TmpPreferredLocale(aPreferredLocale);
        BSTRInConverter TmpPreferredLanguage(aPreferredLanguage);
        BSTRInConverter TmpFormat(aFormat);
        BSTROutConverter TmpLicenseText(aLicenseText);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_QUERYLICENSE_ENTER(this, TmpPreferredLocale.str().c_str(), TmpPreferredLanguage.str().c_str(), TmpFormat.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = queryLicense(TmpPreferredLocale.str(),
                               TmpPreferredLanguage.str(),
                               TmpFormat.str(),
                               TmpLicenseText.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_QUERYLICENSE_RETURN(this, hrc, 0 /*normal*/, TmpPreferredLocale.str().c_str(), TmpPreferredLanguage.str().c_str(), TmpFormat.str().c_str(), TmpLicenseText.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_QUERYLICENSE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKBASE_QUERYLICENSE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aLicenseText=%ls hrc=%Rhrc\n", this, "ExtPackBase::queryLicense", *aLicenseText, hrc));
    return hrc;
}

STDMETHODIMP ExtPackBaseWrap::InternalAndReservedMethod1IExtPackBase()
{
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackBaseWrap::InternalAndReservedMethod2IExtPackBase()
{
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackBaseWrap::InternalAndReservedMethod3IExtPackBase()
{
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackBaseWrap::InternalAndReservedMethod4IExtPackBase()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(ExtPackBaseWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(ExtPackBaseWrap, IExtPackBase)
#endif // VBOX_WITH_XPCOM

