/*
 * \brief  Main object of the kernel
 * \author Martin Stein
 * \date   2021-07-09
 */

/*
 * Copyright (C) 2021 Genode Labs GmbH
 *
 * This file is part of the Genode OS framework, which is distributed
 * under the terms of the GNU Affero General Public License version 3.
 */

#ifndef _KERNEL__MAIN_H_
#define _KERNEL__MAIN_H_

#include <cpu/cpu_state.h>

/* base-hw core includes */
#include <kernel/types.h>

namespace Kernel {

	void main_print_char(char const c);

	void main_handle_kernel_entry(Genode::Cpu_state *state);

	void main_initialize_and_handle_kernel_entry();

	time_t main_read_idle_thread_execution_time(Call_arg);

	void main_print_char(char c);
}

#endif /* _KERNEL__MAIN_H_ */
