/*
 * \brief  Access to raw output back end
 * \author Norman Feske
 * \date   2016-06-16
 */

/*
 * Copyright (C) 2016-2017 Genode Labs GmbH
 *
 * This file is part of the Genode OS framework, which is distributed
 * under the terms of the GNU Affero General Public License version 3.
 */

/* Genode includes */
#include <base/log.h>
#include <base/buffered_output.h>

/* base-internal includes */
#include <base/internal/raw_write_string.h>


Genode::Output &Genode::Raw::_output()
{
	struct Write_fn { void operator () (char const *s) { raw_write_string(s); } };

	static Buffered_output<256, Write_fn> buffered_raw_output { Write_fn() };

	return buffered_raw_output;
}
