// ##### ENDFILE "GuestDnDTargetWrap.cpp"


// ##### BEGINFILE "ProcessWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IProcess.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_PROCESS

#include "ProcessWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(ProcessWrap)

//
// IProcess properties
//

STDMETHODIMP ProcessWrap::COMGETTER(Arguments)(ComSafeArrayOut(BSTR, aArguments))
{
    LogRelFlow(("{%p} %s: enter aArguments=%p\n", this, "Process::getArguments", aArguments));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aArguments);
        ArrayBSTROutConverter TmpArguments(ComSafeArrayOutArg(aArguments));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_GET_ARGUMENTS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getArguments(TmpArguments.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_GET_ARGUMENTS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpArguments.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_GET_ARGUMENTS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_GET_ARGUMENTS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aArguments=%zu hrc=%Rhrc\n", this, "Process::getArguments", ComSafeArraySize(*aArguments), hrc));
    return hrc;
}

STDMETHODIMP ProcessWrap::COMGETTER(Environment)(ComSafeArrayOut(BSTR, aEnvironment))
{
    LogRelFlow(("{%p} %s: enter aEnvironment=%p\n", this, "Process::getEnvironment", aEnvironment));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEnvironment);
        ArrayBSTROutConverter TmpEnvironment(ComSafeArrayOutArg(aEnvironment));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_GET_ENVIRONMENT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEnvironment(TmpEnvironment.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_GET_ENVIRONMENT_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpEnvironment.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_GET_ENVIRONMENT_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_GET_ENVIRONMENT_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEnvironment=%zu hrc=%Rhrc\n", this, "Process::getEnvironment", ComSafeArraySize(*aEnvironment), hrc));
    return hrc;
}

STDMETHODIMP ProcessWrap::COMGETTER(EventSource)(IEventSource **aEventSource)
{
    LogRelFlow(("{%p} %s: enter aEventSource=%p\n", this, "Process::getEventSource", aEventSource));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEventSource);
        ComTypeOutConverter<IEventSource> TmpEventSource(aEventSource);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_GET_EVENTSOURCE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEventSource(TmpEventSource.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_GET_EVENTSOURCE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpEventSource.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_GET_EVENTSOURCE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_GET_EVENTSOURCE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEventSource=%p hrc=%Rhrc\n", this, "Process::getEventSource", *aEventSource, hrc));
    return hrc;
}

STDMETHODIMP ProcessWrap::COMGETTER(ExecutablePath)(BSTR *aExecutablePath)
{
    LogRelFlow(("{%p} %s: enter aExecutablePath=%p\n", this, "Process::getExecutablePath", aExecutablePath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aExecutablePath);
        BSTROutConverter TmpExecutablePath(aExecutablePath);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_GET_EXECUTABLEPATH_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getExecutablePath(TmpExecutablePath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_GET_EXECUTABLEPATH_RETURN(this, hrc, 0 /*normal*/,TmpExecutablePath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_GET_EXECUTABLEPATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_GET_EXECUTABLEPATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aExecutablePath=%ls hrc=%Rhrc\n", this, "Process::getExecutablePath", *aExecutablePath, hrc));
    return hrc;
}

STDMETHODIMP ProcessWrap::COMGETTER(ExitCode)(LONG *aExitCode)
{
    LogRelFlow(("{%p} %s: enter aExitCode=%p\n", this, "Process::getExitCode", aExitCode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aExitCode);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_GET_EXITCODE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getExitCode(aExitCode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_GET_EXITCODE_RETURN(this, hrc, 0 /*normal*/,*aExitCode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_GET_EXITCODE_RETURN(this, hrc, 1 /*hrc exception*/,*aExitCode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_GET_EXITCODE_RETURN(this, hrc, 9 /*unhandled exception*/,*aExitCode);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aExitCode=%RI32 hrc=%Rhrc\n", this, "Process::getExitCode", *aExitCode, hrc));
    return hrc;
}

STDMETHODIMP ProcessWrap::COMGETTER(Name)(BSTR *aName)
{
    LogRelFlow(("{%p} %s: enter aName=%p\n", this, "Process::getName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aName);
        BSTROutConverter TmpName(aName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_GET_NAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_GET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_GET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_GET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aName=%ls hrc=%Rhrc\n", this, "Process::getName", *aName, hrc));
    return hrc;
}

STDMETHODIMP ProcessWrap::COMGETTER(PID)(ULONG *aPID)
{
    LogRelFlow(("{%p} %s: enter aPID=%p\n", this, "Process::getPID", aPID));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPID);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_GET_PID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPID(aPID);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_GET_PID_RETURN(this, hrc, 0 /*normal*/,*aPID);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_GET_PID_RETURN(this, hrc, 1 /*hrc exception*/,*aPID);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_GET_PID_RETURN(this, hrc, 9 /*unhandled exception*/,*aPID);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPID=%RU32 hrc=%Rhrc\n", this, "Process::getPID", *aPID, hrc));
    return hrc;
}

STDMETHODIMP ProcessWrap::COMGETTER(Status)(ProcessStatus_T *aStatus)
{
    LogRelFlow(("{%p} %s: enter aStatus=%p\n", this, "Process::getStatus", aStatus));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aStatus);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_GET_STATUS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getStatus(aStatus);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_GET_STATUS_RETURN(this, hrc, 0 /*normal*/,*aStatus);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_GET_STATUS_RETURN(this, hrc, 1 /*hrc exception*/,*aStatus);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_GET_STATUS_RETURN(this, hrc, 9 /*unhandled exception*/,*aStatus);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aStatus=%RU32 hrc=%Rhrc\n", this, "Process::getStatus", *aStatus, hrc));
    return hrc;
}

STDMETHODIMP ProcessWrap::COMGETTER(InternalAndReservedAttribute1IProcess)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ProcessWrap::COMGETTER(InternalAndReservedAttribute2IProcess)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ProcessWrap::COMGETTER(InternalAndReservedAttribute3IProcess)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ProcessWrap::COMGETTER(InternalAndReservedAttribute4IProcess)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ProcessWrap::COMGETTER(InternalAndReservedAttribute5IProcess)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ProcessWrap::COMGETTER(InternalAndReservedAttribute6IProcess)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ProcessWrap::COMGETTER(InternalAndReservedAttribute7IProcess)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ProcessWrap::COMGETTER(InternalAndReservedAttribute8IProcess)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IProcess methods
//

STDMETHODIMP ProcessWrap::WaitFor(ULONG aWaitFor,
                                  ULONG aTimeoutMS,
                                  ProcessWaitResult_T *aReason)
{
    LogRelFlow(("{%p} %s:enter aWaitFor=%RU32 aTimeoutMS=%RU32 aReason=%p\n", this, "Process::waitFor", aWaitFor, aTimeoutMS, aReason));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aReason);


        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_WAITFOR_ENTER(this, aWaitFor, aTimeoutMS);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = waitFor(aWaitFor,
                          aTimeoutMS,
                          aReason);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_WAITFOR_RETURN(this, hrc, 0 /*normal*/, aWaitFor, aTimeoutMS, *aReason);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_WAITFOR_RETURN(this, hrc, 1 /*hrc exception*/, aWaitFor, aTimeoutMS, *aReason);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_WAITFOR_RETURN(this, hrc, 9 /*unhandled exception*/, aWaitFor, aTimeoutMS, *aReason);
#endif
    }

    LogRelFlow(("{%p} %s: leave aReason=%RU32 hrc=%Rhrc\n", this, "Process::waitFor", *aReason, hrc));
    return hrc;
}

STDMETHODIMP ProcessWrap::WaitForArray(ComSafeArrayIn(ProcessWaitForFlag_T, aWaitFor),
                                       ULONG aTimeoutMS,
                                       ProcessWaitResult_T *aReason)
{
    LogRelFlow(("{%p} %s:enter aWaitFor=%zu aTimeoutMS=%RU32 aReason=%p\n", this, "Process::waitForArray", aWaitFor, aTimeoutMS, aReason));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aReason);


        ArrayInConverter<ProcessWaitForFlag_T> TmpWaitFor(ComSafeArrayInArg(aWaitFor));
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_WAITFORARRAY_ENTER(this, (uint32_t)TmpWaitFor.array().size(), NULL /*for now*/, aTimeoutMS);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = waitForArray(TmpWaitFor.array(),
                               aTimeoutMS,
                               aReason);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_WAITFORARRAY_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpWaitFor.array().size(), NULL /*for now*/, aTimeoutMS, *aReason);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_WAITFORARRAY_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, aTimeoutMS, *aReason);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_WAITFORARRAY_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, aTimeoutMS, *aReason);
#endif
    }

    LogRelFlow(("{%p} %s: leave aReason=%RU32 hrc=%Rhrc\n", this, "Process::waitForArray", *aReason, hrc));
    return hrc;
}

STDMETHODIMP ProcessWrap::Read(ULONG aHandle,
                               ULONG aToRead,
                               ULONG aTimeoutMS,
                               ComSafeArrayOut(BYTE, aData))
{
    LogRelFlow(("{%p} %s:enter aHandle=%RU32 aToRead=%RU32 aTimeoutMS=%RU32 aData=%p\n", this, "Process::read", aHandle, aToRead, aTimeoutMS, aData));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aData);


        
        
        
        ArrayOutConverter<BYTE> TmpData(ComSafeArrayOutArg(aData));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_READ_ENTER(this, aHandle, aToRead, aTimeoutMS);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = read(aHandle,
                       aToRead,
                       aTimeoutMS,
                       TmpData.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_READ_RETURN(this, hrc, 0 /*normal*/, aHandle, aToRead, aTimeoutMS, (uint32_t)TmpData.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_READ_RETURN(this, hrc, 1 /*hrc exception*/, aHandle, aToRead, aTimeoutMS, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_READ_RETURN(this, hrc, 9 /*unhandled exception*/, aHandle, aToRead, aTimeoutMS, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aData=%zu hrc=%Rhrc\n", this, "Process::read", ComSafeArraySize(*aData), hrc));
    return hrc;
}

STDMETHODIMP ProcessWrap::Write(ULONG aHandle,
                                ULONG aFlags,
                                ComSafeArrayIn(BYTE, aData),
                                ULONG aTimeoutMS,
                                ULONG *aWritten)
{
    LogRelFlow(("{%p} %s:enter aHandle=%RU32 aFlags=%RU32 aData=%zu aTimeoutMS=%RU32 aWritten=%p\n", this, "Process::write", aHandle, aFlags, aData, aTimeoutMS, aWritten));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aWritten);


        
        
        ArrayInConverter<BYTE> TmpData(ComSafeArrayInArg(aData));
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_WRITE_ENTER(this, aHandle, aFlags, (uint32_t)TmpData.array().size(), NULL /*for now*/, aTimeoutMS);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = write(aHandle,
                        aFlags,
                        TmpData.array(),
                        aTimeoutMS,
                        aWritten);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_WRITE_RETURN(this, hrc, 0 /*normal*/, aHandle, aFlags, (uint32_t)TmpData.array().size(), NULL /*for now*/, aTimeoutMS, *aWritten);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_WRITE_RETURN(this, hrc, 1 /*hrc exception*/, aHandle, aFlags, 0, 0, aTimeoutMS, *aWritten);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_WRITE_RETURN(this, hrc, 9 /*unhandled exception*/, aHandle, aFlags, 0, 0, aTimeoutMS, *aWritten);
#endif
    }

    LogRelFlow(("{%p} %s: leave aWritten=%RU32 hrc=%Rhrc\n", this, "Process::write", *aWritten, hrc));
    return hrc;
}

STDMETHODIMP ProcessWrap::WriteArray(ULONG aHandle,
                                     ComSafeArrayIn(ProcessInputFlag_T, aFlags),
                                     ComSafeArrayIn(BYTE, aData),
                                     ULONG aTimeoutMS,
                                     ULONG *aWritten)
{
    LogRelFlow(("{%p} %s:enter aHandle=%RU32 aFlags=%zu aData=%zu aTimeoutMS=%RU32 aWritten=%p\n", this, "Process::writeArray", aHandle, aFlags, aData, aTimeoutMS, aWritten));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aWritten);


        
        ArrayInConverter<ProcessInputFlag_T> TmpFlags(ComSafeArrayInArg(aFlags));
        ArrayInConverter<BYTE> TmpData(ComSafeArrayInArg(aData));
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_WRITEARRAY_ENTER(this, aHandle, (uint32_t)TmpFlags.array().size(), NULL /*for now*/, (uint32_t)TmpData.array().size(), NULL /*for now*/, aTimeoutMS);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = writeArray(aHandle,
                             TmpFlags.array(),
                             TmpData.array(),
                             aTimeoutMS,
                             aWritten);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_WRITEARRAY_RETURN(this, hrc, 0 /*normal*/, aHandle, (uint32_t)TmpFlags.array().size(), NULL /*for now*/, (uint32_t)TmpData.array().size(), NULL /*for now*/, aTimeoutMS, *aWritten);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_WRITEARRAY_RETURN(this, hrc, 1 /*hrc exception*/, aHandle, 0, 0, 0, 0, aTimeoutMS, *aWritten);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_WRITEARRAY_RETURN(this, hrc, 9 /*unhandled exception*/, aHandle, 0, 0, 0, 0, aTimeoutMS, *aWritten);
#endif
    }

    LogRelFlow(("{%p} %s: leave aWritten=%RU32 hrc=%Rhrc\n", this, "Process::writeArray", *aWritten, hrc));
    return hrc;
}

STDMETHODIMP ProcessWrap::Terminate()
{
    LogRelFlow(("{%p} %s:enter\n", this, "Process::terminate"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_TERMINATE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = terminate();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_TERMINATE_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_TERMINATE_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PROCESS_TERMINATE_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Process::terminate", hrc));
    return hrc;
}

STDMETHODIMP ProcessWrap::InternalAndReservedMethod1IProcess()
{
    return E_NOTIMPL;
}

STDMETHODIMP ProcessWrap::InternalAndReservedMethod2IProcess()
{
    return E_NOTIMPL;
}

STDMETHODIMP ProcessWrap::InternalAndReservedMethod3IProcess()
{
    return E_NOTIMPL;
}

STDMETHODIMP ProcessWrap::InternalAndReservedMethod4IProcess()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(ProcessWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(ProcessWrap, IProcess)
#endif // VBOX_WITH_XPCOM

