// ##### ENDFILE "RecordingScreenSettingsWrap.h"


// ##### BEGINFILE "RecordingSettingsWrap.h"
/** @file
 * VirtualBox API class wrapper header for IRecordingSettings.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#ifndef RecordingSettingsWrap_H_
#define RecordingSettingsWrap_H_
#ifndef RT_WITHOUT_PRAGMA_ONCE
# pragma once
#endif

#include "VirtualBoxBase.h"
#include "Wrapper.h"

class ATL_NO_VTABLE RecordingSettingsWrap
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IRecordingSettings)
{
    Q_OBJECT

public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(RecordingSettingsWrap, IRecordingSettings)
    DECLARE_NOT_AGGREGATABLE(RecordingSettingsWrap)
    DECLARE_PROTECT_FINAL_CONSTRUCT()

    BEGIN_COM_MAP(RecordingSettingsWrap)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IRecordingSettings)
        COM_INTERFACE_ENTRY2(IDispatch, IRecordingSettings)
        VBOX_TWEAK_INTERFACE_ENTRY(IRecordingSettings)
    END_COM_MAP()

    DECLARE_EMPTY_CTOR_DTOR(RecordingSettingsWrap)

    /** @name Public IRecordingSettings properties
     * @{ */
    STDMETHOD(COMGETTER(Enabled))(BOOL *aEnabled);
    STDMETHOD(COMSETTER(Enabled))(BOOL aEnabled);
    STDMETHOD(COMGETTER(Screens))(ComSafeArrayOut(IRecordingScreenSettings *, aScreens));
    /** @} */

    /** @name Public IRecordingSettings methods
     * @{ */
    STDMETHOD(GetScreenSettings)(ULONG aScreenId,
                                 IRecordingScreenSettings **aRecordScreenSettings);
    /** @} */

private:
    /** @name Wrapped IRecordingSettings properties
     * @{ */
    virtual HRESULT getEnabled(BOOL *aEnabled) = 0;
    virtual HRESULT setEnabled(BOOL aEnabled) = 0;
    virtual HRESULT getScreens(std::vector<ComPtr<IRecordingScreenSettings> > &aScreens) = 0;
    /** @} */

    /** @name Wrapped IRecordingSettings methods
     * @{ */
    virtual HRESULT getScreenSettings(ULONG aScreenId,
                                      ComPtr<IRecordingScreenSettings> &aRecordScreenSettings) = 0;
    /** @} */

private:
    DECLARE_CLS_COPY_CTOR_ASSIGN_NOOP(RecordingSettingsWrap); /* Shuts up MSC warning C4625. */

};

#endif // !RecordingSettingsWrap_H_

