// ##### ENDFILE "GuestSessionWrap.cpp"


// ##### BEGINFILE "GuestProcessWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IGuestProcess.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_GUESTPROCESS

#include "GuestProcessWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(GuestProcessWrap)

//
// IProcess properties
//

STDMETHODIMP GuestProcessWrap::COMGETTER(Arguments)(ComSafeArrayOut(BSTR, aArguments))
{
    LogRelFlow(("{%p} %s: enter aArguments=%p\n", this, "GuestProcess::getArguments", aArguments));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aArguments);
        ArrayBSTROutConverter TmpArguments(ComSafeArrayOutArg(aArguments));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_GET_ARGUMENTS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getArguments(TmpArguments.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_GET_ARGUMENTS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpArguments.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_GET_ARGUMENTS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_GET_ARGUMENTS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aArguments=%zu hrc=%Rhrc\n", this, "GuestProcess::getArguments", ComSafeArraySize(*aArguments), hrc));
    return hrc;
}

STDMETHODIMP GuestProcessWrap::COMGETTER(Environment)(ComSafeArrayOut(BSTR, aEnvironment))
{
    LogRelFlow(("{%p} %s: enter aEnvironment=%p\n", this, "GuestProcess::getEnvironment", aEnvironment));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEnvironment);
        ArrayBSTROutConverter TmpEnvironment(ComSafeArrayOutArg(aEnvironment));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_GET_ENVIRONMENT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEnvironment(TmpEnvironment.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_GET_ENVIRONMENT_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpEnvironment.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_GET_ENVIRONMENT_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_GET_ENVIRONMENT_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEnvironment=%zu hrc=%Rhrc\n", this, "GuestProcess::getEnvironment", ComSafeArraySize(*aEnvironment), hrc));
    return hrc;
}

STDMETHODIMP GuestProcessWrap::COMGETTER(EventSource)(IEventSource **aEventSource)
{
    LogRelFlow(("{%p} %s: enter aEventSource=%p\n", this, "GuestProcess::getEventSource", aEventSource));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEventSource);
        ComTypeOutConverter<IEventSource> TmpEventSource(aEventSource);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_GET_EVENTSOURCE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEventSource(TmpEventSource.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_GET_EVENTSOURCE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpEventSource.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_GET_EVENTSOURCE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_GET_EVENTSOURCE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEventSource=%p hrc=%Rhrc\n", this, "GuestProcess::getEventSource", *aEventSource, hrc));
    return hrc;
}

STDMETHODIMP GuestProcessWrap::COMGETTER(ExecutablePath)(BSTR *aExecutablePath)
{
    LogRelFlow(("{%p} %s: enter aExecutablePath=%p\n", this, "GuestProcess::getExecutablePath", aExecutablePath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aExecutablePath);
        BSTROutConverter TmpExecutablePath(aExecutablePath);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_GET_EXECUTABLEPATH_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getExecutablePath(TmpExecutablePath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_GET_EXECUTABLEPATH_RETURN(this, hrc, 0 /*normal*/,TmpExecutablePath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_GET_EXECUTABLEPATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_GET_EXECUTABLEPATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aExecutablePath=%ls hrc=%Rhrc\n", this, "GuestProcess::getExecutablePath", *aExecutablePath, hrc));
    return hrc;
}

STDMETHODIMP GuestProcessWrap::COMGETTER(ExitCode)(LONG *aExitCode)
{
    LogRelFlow(("{%p} %s: enter aExitCode=%p\n", this, "GuestProcess::getExitCode", aExitCode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aExitCode);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_GET_EXITCODE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getExitCode(aExitCode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_GET_EXITCODE_RETURN(this, hrc, 0 /*normal*/,*aExitCode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_GET_EXITCODE_RETURN(this, hrc, 1 /*hrc exception*/,*aExitCode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_GET_EXITCODE_RETURN(this, hrc, 9 /*unhandled exception*/,*aExitCode);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aExitCode=%RI32 hrc=%Rhrc\n", this, "GuestProcess::getExitCode", *aExitCode, hrc));
    return hrc;
}

STDMETHODIMP GuestProcessWrap::COMGETTER(Name)(BSTR *aName)
{
    LogRelFlow(("{%p} %s: enter aName=%p\n", this, "GuestProcess::getName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aName);
        BSTROutConverter TmpName(aName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_GET_NAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_GET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_GET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_GET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aName=%ls hrc=%Rhrc\n", this, "GuestProcess::getName", *aName, hrc));
    return hrc;
}

STDMETHODIMP GuestProcessWrap::COMGETTER(PID)(ULONG *aPID)
{
    LogRelFlow(("{%p} %s: enter aPID=%p\n", this, "GuestProcess::getPID", aPID));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPID);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_GET_PID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPID(aPID);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_GET_PID_RETURN(this, hrc, 0 /*normal*/,*aPID);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_GET_PID_RETURN(this, hrc, 1 /*hrc exception*/,*aPID);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_GET_PID_RETURN(this, hrc, 9 /*unhandled exception*/,*aPID);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPID=%RU32 hrc=%Rhrc\n", this, "GuestProcess::getPID", *aPID, hrc));
    return hrc;
}

STDMETHODIMP GuestProcessWrap::COMGETTER(Status)(ProcessStatus_T *aStatus)
{
    LogRelFlow(("{%p} %s: enter aStatus=%p\n", this, "GuestProcess::getStatus", aStatus));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aStatus);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_GET_STATUS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getStatus(aStatus);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_GET_STATUS_RETURN(this, hrc, 0 /*normal*/,*aStatus);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_GET_STATUS_RETURN(this, hrc, 1 /*hrc exception*/,*aStatus);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_GET_STATUS_RETURN(this, hrc, 9 /*unhandled exception*/,*aStatus);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aStatus=%RU32 hrc=%Rhrc\n", this, "GuestProcess::getStatus", *aStatus, hrc));
    return hrc;
}

STDMETHODIMP GuestProcessWrap::COMGETTER(InternalAndReservedAttribute1IProcess)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestProcessWrap::COMGETTER(InternalAndReservedAttribute2IProcess)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestProcessWrap::COMGETTER(InternalAndReservedAttribute3IProcess)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestProcessWrap::COMGETTER(InternalAndReservedAttribute4IProcess)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestProcessWrap::COMGETTER(InternalAndReservedAttribute5IProcess)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestProcessWrap::COMGETTER(InternalAndReservedAttribute6IProcess)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestProcessWrap::COMGETTER(InternalAndReservedAttribute7IProcess)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestProcessWrap::COMGETTER(InternalAndReservedAttribute8IProcess)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

//
// IGuestProcess properties
//

STDMETHODIMP GuestProcessWrap::COMGETTER(MidlDoesNotLikeEmptyInterfaces)(BOOL *aMidlDoesNotLikeEmptyInterfaces)
{
#if 0 /* This is a dummy attribute */
    LogRelFlow(("{%p} %s: enter aMidlDoesNotLikeEmptyInterfaces=%p\n", this, "GuestProcess::getMidlDoesNotLikeEmptyInterfaces", aMidlDoesNotLikeEmptyInterfaces));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMidlDoesNotLikeEmptyInterfaces);
        
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMidlDoesNotLikeEmptyInterfaces(aMidlDoesNotLikeEmptyInterfaces);
        }
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
    }

    LogRelFlow(("{%p} %s: leave *aMidlDoesNotLikeEmptyInterfaces=%RTbool hrc=%Rhrc\n", this, "GuestProcess::getMidlDoesNotLikeEmptyInterfaces", *aMidlDoesNotLikeEmptyInterfaces, hrc));
    return hrc;
#else  /* dummy attribute */
    NOREF(aMidlDoesNotLikeEmptyInterfaces);
    return E_FAIL;
#endif /* dummy attribute */
}


//
// IProcess methods
//

STDMETHODIMP GuestProcessWrap::WaitFor(ULONG aWaitFor,
                                       ULONG aTimeoutMS,
                                       ProcessWaitResult_T *aReason)
{
    LogRelFlow(("{%p} %s:enter aWaitFor=%RU32 aTimeoutMS=%RU32 aReason=%p\n", this, "GuestProcess::waitFor", aWaitFor, aTimeoutMS, aReason));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aReason);


        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_WAITFOR_ENTER(this, aWaitFor, aTimeoutMS);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = waitFor(aWaitFor,
                          aTimeoutMS,
                          aReason);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_WAITFOR_RETURN(this, hrc, 0 /*normal*/, aWaitFor, aTimeoutMS, *aReason);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_WAITFOR_RETURN(this, hrc, 1 /*hrc exception*/, aWaitFor, aTimeoutMS, *aReason);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_WAITFOR_RETURN(this, hrc, 9 /*unhandled exception*/, aWaitFor, aTimeoutMS, *aReason);
#endif
    }

    LogRelFlow(("{%p} %s: leave aReason=%RU32 hrc=%Rhrc\n", this, "GuestProcess::waitFor", *aReason, hrc));
    return hrc;
}

STDMETHODIMP GuestProcessWrap::WaitForArray(ComSafeArrayIn(ProcessWaitForFlag_T, aWaitFor),
                                            ULONG aTimeoutMS,
                                            ProcessWaitResult_T *aReason)
{
    LogRelFlow(("{%p} %s:enter aWaitFor=%zu aTimeoutMS=%RU32 aReason=%p\n", this, "GuestProcess::waitForArray", aWaitFor, aTimeoutMS, aReason));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aReason);


        ArrayInConverter<ProcessWaitForFlag_T> TmpWaitFor(ComSafeArrayInArg(aWaitFor));
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_WAITFORARRAY_ENTER(this, (uint32_t)TmpWaitFor.array().size(), NULL /*for now*/, aTimeoutMS);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = waitForArray(TmpWaitFor.array(),
                               aTimeoutMS,
                               aReason);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_WAITFORARRAY_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpWaitFor.array().size(), NULL /*for now*/, aTimeoutMS, *aReason);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_WAITFORARRAY_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, aTimeoutMS, *aReason);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_WAITFORARRAY_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, aTimeoutMS, *aReason);
#endif
    }

    LogRelFlow(("{%p} %s: leave aReason=%RU32 hrc=%Rhrc\n", this, "GuestProcess::waitForArray", *aReason, hrc));
    return hrc;
}

STDMETHODIMP GuestProcessWrap::Read(ULONG aHandle,
                                    ULONG aToRead,
                                    ULONG aTimeoutMS,
                                    ComSafeArrayOut(BYTE, aData))
{
    LogRelFlow(("{%p} %s:enter aHandle=%RU32 aToRead=%RU32 aTimeoutMS=%RU32 aData=%p\n", this, "GuestProcess::read", aHandle, aToRead, aTimeoutMS, aData));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aData);


        
        
        
        ArrayOutConverter<BYTE> TmpData(ComSafeArrayOutArg(aData));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_READ_ENTER(this, aHandle, aToRead, aTimeoutMS);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = read(aHandle,
                       aToRead,
                       aTimeoutMS,
                       TmpData.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_READ_RETURN(this, hrc, 0 /*normal*/, aHandle, aToRead, aTimeoutMS, (uint32_t)TmpData.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_READ_RETURN(this, hrc, 1 /*hrc exception*/, aHandle, aToRead, aTimeoutMS, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_READ_RETURN(this, hrc, 9 /*unhandled exception*/, aHandle, aToRead, aTimeoutMS, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aData=%zu hrc=%Rhrc\n", this, "GuestProcess::read", ComSafeArraySize(*aData), hrc));
    return hrc;
}

STDMETHODIMP GuestProcessWrap::Write(ULONG aHandle,
                                     ULONG aFlags,
                                     ComSafeArrayIn(BYTE, aData),
                                     ULONG aTimeoutMS,
                                     ULONG *aWritten)
{
    LogRelFlow(("{%p} %s:enter aHandle=%RU32 aFlags=%RU32 aData=%zu aTimeoutMS=%RU32 aWritten=%p\n", this, "GuestProcess::write", aHandle, aFlags, aData, aTimeoutMS, aWritten));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aWritten);


        
        
        ArrayInConverter<BYTE> TmpData(ComSafeArrayInArg(aData));
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_WRITE_ENTER(this, aHandle, aFlags, (uint32_t)TmpData.array().size(), NULL /*for now*/, aTimeoutMS);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = write(aHandle,
                        aFlags,
                        TmpData.array(),
                        aTimeoutMS,
                        aWritten);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_WRITE_RETURN(this, hrc, 0 /*normal*/, aHandle, aFlags, (uint32_t)TmpData.array().size(), NULL /*for now*/, aTimeoutMS, *aWritten);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_WRITE_RETURN(this, hrc, 1 /*hrc exception*/, aHandle, aFlags, 0, 0, aTimeoutMS, *aWritten);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_WRITE_RETURN(this, hrc, 9 /*unhandled exception*/, aHandle, aFlags, 0, 0, aTimeoutMS, *aWritten);
#endif
    }

    LogRelFlow(("{%p} %s: leave aWritten=%RU32 hrc=%Rhrc\n", this, "GuestProcess::write", *aWritten, hrc));
    return hrc;
}

STDMETHODIMP GuestProcessWrap::WriteArray(ULONG aHandle,
                                          ComSafeArrayIn(ProcessInputFlag_T, aFlags),
                                          ComSafeArrayIn(BYTE, aData),
                                          ULONG aTimeoutMS,
                                          ULONG *aWritten)
{
    LogRelFlow(("{%p} %s:enter aHandle=%RU32 aFlags=%zu aData=%zu aTimeoutMS=%RU32 aWritten=%p\n", this, "GuestProcess::writeArray", aHandle, aFlags, aData, aTimeoutMS, aWritten));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aWritten);


        
        ArrayInConverter<ProcessInputFlag_T> TmpFlags(ComSafeArrayInArg(aFlags));
        ArrayInConverter<BYTE> TmpData(ComSafeArrayInArg(aData));
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_WRITEARRAY_ENTER(this, aHandle, (uint32_t)TmpFlags.array().size(), NULL /*for now*/, (uint32_t)TmpData.array().size(), NULL /*for now*/, aTimeoutMS);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = writeArray(aHandle,
                             TmpFlags.array(),
                             TmpData.array(),
                             aTimeoutMS,
                             aWritten);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_WRITEARRAY_RETURN(this, hrc, 0 /*normal*/, aHandle, (uint32_t)TmpFlags.array().size(), NULL /*for now*/, (uint32_t)TmpData.array().size(), NULL /*for now*/, aTimeoutMS, *aWritten);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_WRITEARRAY_RETURN(this, hrc, 1 /*hrc exception*/, aHandle, 0, 0, 0, 0, aTimeoutMS, *aWritten);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_WRITEARRAY_RETURN(this, hrc, 9 /*unhandled exception*/, aHandle, 0, 0, 0, 0, aTimeoutMS, *aWritten);
#endif
    }

    LogRelFlow(("{%p} %s: leave aWritten=%RU32 hrc=%Rhrc\n", this, "GuestProcess::writeArray", *aWritten, hrc));
    return hrc;
}

STDMETHODIMP GuestProcessWrap::Terminate()
{
    LogRelFlow(("{%p} %s:enter\n", this, "GuestProcess::terminate"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_TERMINATE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = terminate();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_TERMINATE_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_TERMINATE_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTPROCESS_TERMINATE_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GuestProcess::terminate", hrc));
    return hrc;
}

STDMETHODIMP GuestProcessWrap::InternalAndReservedMethod1IProcess()
{
    return E_NOTIMPL;
}

STDMETHODIMP GuestProcessWrap::InternalAndReservedMethod2IProcess()
{
    return E_NOTIMPL;
}

STDMETHODIMP GuestProcessWrap::InternalAndReservedMethod3IProcess()
{
    return E_NOTIMPL;
}

STDMETHODIMP GuestProcessWrap::InternalAndReservedMethod4IProcess()
{
    return E_NOTIMPL;
}

//
// IGuestProcess methods
//

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestProcessWrap)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(GuestProcessWrap, IGuestProcess, IProcess)
#endif // VBOX_WITH_XPCOM

