// ##### ENDFILE "TokenWrap.h"


// ##### BEGINFILE "KeyboardWrap.h"
/** @file
 * VirtualBox API class wrapper header for IKeyboard.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#ifndef KeyboardWrap_H_
#define KeyboardWrap_H_
#ifndef RT_WITHOUT_PRAGMA_ONCE
# pragma once
#endif

#include "VirtualBoxBase.h"
#include "Wrapper.h"

class ATL_NO_VTABLE KeyboardWrap
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IKeyboard)
{
    Q_OBJECT

public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(KeyboardWrap, IKeyboard)
    DECLARE_NOT_AGGREGATABLE(KeyboardWrap)
    DECLARE_PROTECT_FINAL_CONSTRUCT()

    BEGIN_COM_MAP(KeyboardWrap)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IKeyboard)
        COM_INTERFACE_ENTRY2(IDispatch, IKeyboard)
        VBOX_TWEAK_INTERFACE_ENTRY(IKeyboard)
    END_COM_MAP()

    DECLARE_EMPTY_CTOR_DTOR(KeyboardWrap)

    /** @name Public IKeyboard properties
     * @{ */
    STDMETHOD(COMGETTER(KeyboardLEDs))(ComSafeArrayOut(KeyboardLED_T, aKeyboardLEDs));
    STDMETHOD(COMGETTER(EventSource))(IEventSource **aEventSource);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute1IKeyboard))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute2IKeyboard))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute3IKeyboard))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute4IKeyboard))(ULONG *aReserved);
    /** @} */

    /** @name Public IKeyboard methods
     * @{ */
    STDMETHOD(PutScancode)(LONG aScancode);
    STDMETHOD(PutScancodes)(ComSafeArrayIn(LONG, aScancodes),
                            ULONG *aCodesStored);
    STDMETHOD(PutCAD)();
    STDMETHOD(ReleaseKeys)();
    STDMETHOD(PutUsageCode)(LONG aUsageCode,
                            LONG aUsagePage,
                            BOOL aKeyRelease);
    STDMETHOD(InternalAndReservedMethod1IKeyboard)();
    STDMETHOD(InternalAndReservedMethod2IKeyboard)();
    STDMETHOD(InternalAndReservedMethod3IKeyboard)();
    STDMETHOD(InternalAndReservedMethod4IKeyboard)();
    /** @} */

private:
    /** @name Wrapped IKeyboard properties
     * @{ */
    virtual HRESULT getKeyboardLEDs(std::vector<KeyboardLED_T> &aKeyboardLEDs) = 0;
    virtual HRESULT getEventSource(ComPtr<IEventSource> &aEventSource) = 0;
    /** @} */

    /** @name Wrapped IKeyboard methods
     * @{ */
    virtual HRESULT putScancode(LONG aScancode) = 0;
    virtual HRESULT putScancodes(const std::vector<LONG> &aScancodes,
                                 ULONG *aCodesStored) = 0;
    virtual HRESULT putCAD() = 0;
    virtual HRESULT releaseKeys() = 0;
    virtual HRESULT putUsageCode(LONG aUsageCode,
                                 LONG aUsagePage,
                                 BOOL aKeyRelease) = 0;
    /** @} */

private:
    DECLARE_CLS_COPY_CTOR_ASSIGN_NOOP(KeyboardWrap); /* Shuts up MSC warning C4625. */

};

#endif // !KeyboardWrap_H_

