// ##### ENDFILE "ProcessWrap.cpp"


// ##### BEGINFILE "DirectoryWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IDirectory.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_DIRECTORY

#include "DirectoryWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(DirectoryWrap)

//
// IDirectory properties
//

STDMETHODIMP DirectoryWrap::COMGETTER(DirectoryName)(BSTR *aDirectoryName)
{
    LogRelFlow(("{%p} %s: enter aDirectoryName=%p\n", this, "Directory::getDirectoryName", aDirectoryName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDirectoryName);
        BSTROutConverter TmpDirectoryName(aDirectoryName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DIRECTORY_GET_DIRECTORYNAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDirectoryName(TmpDirectoryName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DIRECTORY_GET_DIRECTORYNAME_RETURN(this, hrc, 0 /*normal*/,TmpDirectoryName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DIRECTORY_GET_DIRECTORYNAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DIRECTORY_GET_DIRECTORYNAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDirectoryName=%ls hrc=%Rhrc\n", this, "Directory::getDirectoryName", *aDirectoryName, hrc));
    return hrc;
}

STDMETHODIMP DirectoryWrap::COMGETTER(Filter)(BSTR *aFilter)
{
    LogRelFlow(("{%p} %s: enter aFilter=%p\n", this, "Directory::getFilter", aFilter));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFilter);
        BSTROutConverter TmpFilter(aFilter);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DIRECTORY_GET_FILTER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getFilter(TmpFilter.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DIRECTORY_GET_FILTER_RETURN(this, hrc, 0 /*normal*/,TmpFilter.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DIRECTORY_GET_FILTER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DIRECTORY_GET_FILTER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aFilter=%ls hrc=%Rhrc\n", this, "Directory::getFilter", *aFilter, hrc));
    return hrc;
}

STDMETHODIMP DirectoryWrap::COMGETTER(InternalAndReservedAttribute1IDirectory)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DirectoryWrap::COMGETTER(InternalAndReservedAttribute2IDirectory)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DirectoryWrap::COMGETTER(InternalAndReservedAttribute3IDirectory)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DirectoryWrap::COMGETTER(InternalAndReservedAttribute4IDirectory)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DirectoryWrap::COMGETTER(InternalAndReservedAttribute5IDirectory)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DirectoryWrap::COMGETTER(InternalAndReservedAttribute6IDirectory)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DirectoryWrap::COMGETTER(InternalAndReservedAttribute7IDirectory)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DirectoryWrap::COMGETTER(InternalAndReservedAttribute8IDirectory)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IDirectory methods
//

STDMETHODIMP DirectoryWrap::Close()
{
    LogRelFlow(("{%p} %s:enter\n", this, "Directory::close"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DIRECTORY_CLOSE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = close();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DIRECTORY_CLOSE_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DIRECTORY_CLOSE_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DIRECTORY_CLOSE_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Directory::close", hrc));
    return hrc;
}

STDMETHODIMP DirectoryWrap::Read(IFsObjInfo **aObjInfo)
{
    LogRelFlow(("{%p} %s:enter aObjInfo=%p\n", this, "Directory::read", aObjInfo));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aObjInfo);


        ComTypeOutConverter<IFsObjInfo> TmpObjInfo(aObjInfo);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DIRECTORY_READ_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = read(TmpObjInfo.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DIRECTORY_READ_RETURN(this, hrc, 0 /*normal*/, (void *)TmpObjInfo.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DIRECTORY_READ_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DIRECTORY_READ_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aObjInfo=%p hrc=%Rhrc\n", this, "Directory::read", *aObjInfo, hrc));
    return hrc;
}

STDMETHODIMP DirectoryWrap::InternalAndReservedMethod1IDirectory()
{
    return E_NOTIMPL;
}

STDMETHODIMP DirectoryWrap::InternalAndReservedMethod2IDirectory()
{
    return E_NOTIMPL;
}

STDMETHODIMP DirectoryWrap::InternalAndReservedMethod3IDirectory()
{
    return E_NOTIMPL;
}

STDMETHODIMP DirectoryWrap::InternalAndReservedMethod4IDirectory()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(DirectoryWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(DirectoryWrap, IDirectory)
#endif // VBOX_WITH_XPCOM

