// ##### ENDFILE "VirtualSystemDescriptionWrap.cpp"


// ##### BEGINFILE "BIOSSettingsWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IBIOSSettings.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_BIOSSETTINGS

#include "BIOSSettingsWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(BIOSSettingsWrap)

//
// IBIOSSettings properties
//

STDMETHODIMP BIOSSettingsWrap::COMGETTER(LogoFadeIn)(BOOL *aLogoFadeIn)
{
    LogRelFlow(("{%p} %s: enter aLogoFadeIn=%p\n", this, "BIOSSettings::getLogoFadeIn", aLogoFadeIn));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLogoFadeIn);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_LOGOFADEIN_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLogoFadeIn(aLogoFadeIn);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_LOGOFADEIN_RETURN(this, hrc, 0 /*normal*/,*aLogoFadeIn != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_LOGOFADEIN_RETURN(this, hrc, 1 /*hrc exception*/,*aLogoFadeIn != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_LOGOFADEIN_RETURN(this, hrc, 9 /*unhandled exception*/,*aLogoFadeIn != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLogoFadeIn=%RTbool hrc=%Rhrc\n", this, "BIOSSettings::getLogoFadeIn", *aLogoFadeIn, hrc));
    return hrc;
}

STDMETHODIMP BIOSSettingsWrap::COMSETTER(LogoFadeIn)(BOOL aLogoFadeIn)
{
    LogRelFlow(("{%p} %s: enter aLogoFadeIn=%RTbool\n", this, "BIOSSettings::setLogoFadeIn", aLogoFadeIn));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_LOGOFADEIN_ENTER(this, aLogoFadeIn != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setLogoFadeIn(aLogoFadeIn != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_LOGOFADEIN_RETURN(this, hrc, 0 /*normal*/,aLogoFadeIn != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_LOGOFADEIN_RETURN(this, hrc, 1 /*hrc exception*/,aLogoFadeIn != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_LOGOFADEIN_RETURN(this, hrc, 9 /*unhandled exception*/,aLogoFadeIn != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "BIOSSettings::setLogoFadeIn", hrc));
    return hrc;
}

STDMETHODIMP BIOSSettingsWrap::COMGETTER(LogoFadeOut)(BOOL *aLogoFadeOut)
{
    LogRelFlow(("{%p} %s: enter aLogoFadeOut=%p\n", this, "BIOSSettings::getLogoFadeOut", aLogoFadeOut));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLogoFadeOut);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_LOGOFADEOUT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLogoFadeOut(aLogoFadeOut);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_LOGOFADEOUT_RETURN(this, hrc, 0 /*normal*/,*aLogoFadeOut != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_LOGOFADEOUT_RETURN(this, hrc, 1 /*hrc exception*/,*aLogoFadeOut != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_LOGOFADEOUT_RETURN(this, hrc, 9 /*unhandled exception*/,*aLogoFadeOut != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLogoFadeOut=%RTbool hrc=%Rhrc\n", this, "BIOSSettings::getLogoFadeOut", *aLogoFadeOut, hrc));
    return hrc;
}

STDMETHODIMP BIOSSettingsWrap::COMSETTER(LogoFadeOut)(BOOL aLogoFadeOut)
{
    LogRelFlow(("{%p} %s: enter aLogoFadeOut=%RTbool\n", this, "BIOSSettings::setLogoFadeOut", aLogoFadeOut));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_LOGOFADEOUT_ENTER(this, aLogoFadeOut != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setLogoFadeOut(aLogoFadeOut != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_LOGOFADEOUT_RETURN(this, hrc, 0 /*normal*/,aLogoFadeOut != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_LOGOFADEOUT_RETURN(this, hrc, 1 /*hrc exception*/,aLogoFadeOut != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_LOGOFADEOUT_RETURN(this, hrc, 9 /*unhandled exception*/,aLogoFadeOut != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "BIOSSettings::setLogoFadeOut", hrc));
    return hrc;
}

STDMETHODIMP BIOSSettingsWrap::COMGETTER(LogoDisplayTime)(ULONG *aLogoDisplayTime)
{
    LogRelFlow(("{%p} %s: enter aLogoDisplayTime=%p\n", this, "BIOSSettings::getLogoDisplayTime", aLogoDisplayTime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLogoDisplayTime);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_LOGODISPLAYTIME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLogoDisplayTime(aLogoDisplayTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_LOGODISPLAYTIME_RETURN(this, hrc, 0 /*normal*/,*aLogoDisplayTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_LOGODISPLAYTIME_RETURN(this, hrc, 1 /*hrc exception*/,*aLogoDisplayTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_LOGODISPLAYTIME_RETURN(this, hrc, 9 /*unhandled exception*/,*aLogoDisplayTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLogoDisplayTime=%RU32 hrc=%Rhrc\n", this, "BIOSSettings::getLogoDisplayTime", *aLogoDisplayTime, hrc));
    return hrc;
}

STDMETHODIMP BIOSSettingsWrap::COMSETTER(LogoDisplayTime)(ULONG aLogoDisplayTime)
{
    LogRelFlow(("{%p} %s: enter aLogoDisplayTime=%RU32\n", this, "BIOSSettings::setLogoDisplayTime", aLogoDisplayTime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_LOGODISPLAYTIME_ENTER(this, aLogoDisplayTime);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setLogoDisplayTime(aLogoDisplayTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_LOGODISPLAYTIME_RETURN(this, hrc, 0 /*normal*/,aLogoDisplayTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_LOGODISPLAYTIME_RETURN(this, hrc, 1 /*hrc exception*/,aLogoDisplayTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_LOGODISPLAYTIME_RETURN(this, hrc, 9 /*unhandled exception*/,aLogoDisplayTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "BIOSSettings::setLogoDisplayTime", hrc));
    return hrc;
}

STDMETHODIMP BIOSSettingsWrap::COMGETTER(LogoImagePath)(BSTR *aLogoImagePath)
{
    LogRelFlow(("{%p} %s: enter aLogoImagePath=%p\n", this, "BIOSSettings::getLogoImagePath", aLogoImagePath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLogoImagePath);
        BSTROutConverter TmpLogoImagePath(aLogoImagePath);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_LOGOIMAGEPATH_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLogoImagePath(TmpLogoImagePath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_LOGOIMAGEPATH_RETURN(this, hrc, 0 /*normal*/,TmpLogoImagePath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_LOGOIMAGEPATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_LOGOIMAGEPATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLogoImagePath=%ls hrc=%Rhrc\n", this, "BIOSSettings::getLogoImagePath", *aLogoImagePath, hrc));
    return hrc;
}

STDMETHODIMP BIOSSettingsWrap::COMSETTER(LogoImagePath)(IN_BSTR aLogoImagePath)
{
    LogRelFlow(("{%p} %s: enter aLogoImagePath=%ls\n", this, "BIOSSettings::setLogoImagePath", aLogoImagePath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpLogoImagePath(aLogoImagePath);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_LOGOIMAGEPATH_ENTER(this, TmpLogoImagePath.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setLogoImagePath(TmpLogoImagePath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_LOGOIMAGEPATH_RETURN(this, hrc, 0 /*normal*/,TmpLogoImagePath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_LOGOIMAGEPATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_LOGOIMAGEPATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "BIOSSettings::setLogoImagePath", hrc));
    return hrc;
}

STDMETHODIMP BIOSSettingsWrap::COMGETTER(BootMenuMode)(BIOSBootMenuMode_T *aBootMenuMode)
{
    LogRelFlow(("{%p} %s: enter aBootMenuMode=%p\n", this, "BIOSSettings::getBootMenuMode", aBootMenuMode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aBootMenuMode);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_BOOTMENUMODE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getBootMenuMode(aBootMenuMode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_BOOTMENUMODE_RETURN(this, hrc, 0 /*normal*/,*aBootMenuMode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_BOOTMENUMODE_RETURN(this, hrc, 1 /*hrc exception*/,*aBootMenuMode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_BOOTMENUMODE_RETURN(this, hrc, 9 /*unhandled exception*/,*aBootMenuMode);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aBootMenuMode=%RU32 hrc=%Rhrc\n", this, "BIOSSettings::getBootMenuMode", *aBootMenuMode, hrc));
    return hrc;
}

STDMETHODIMP BIOSSettingsWrap::COMSETTER(BootMenuMode)(BIOSBootMenuMode_T aBootMenuMode)
{
    LogRelFlow(("{%p} %s: enter aBootMenuMode=%RU32\n", this, "BIOSSettings::setBootMenuMode", aBootMenuMode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_BOOTMENUMODE_ENTER(this, aBootMenuMode);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setBootMenuMode(aBootMenuMode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_BOOTMENUMODE_RETURN(this, hrc, 0 /*normal*/,aBootMenuMode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_BOOTMENUMODE_RETURN(this, hrc, 1 /*hrc exception*/,aBootMenuMode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_BOOTMENUMODE_RETURN(this, hrc, 9 /*unhandled exception*/,aBootMenuMode);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "BIOSSettings::setBootMenuMode", hrc));
    return hrc;
}

STDMETHODIMP BIOSSettingsWrap::COMGETTER(ACPIEnabled)(BOOL *aACPIEnabled)
{
    LogRelFlow(("{%p} %s: enter aACPIEnabled=%p\n", this, "BIOSSettings::getACPIEnabled", aACPIEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aACPIEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_ACPIENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getACPIEnabled(aACPIEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_ACPIENABLED_RETURN(this, hrc, 0 /*normal*/,*aACPIEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_ACPIENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aACPIEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_ACPIENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aACPIEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aACPIEnabled=%RTbool hrc=%Rhrc\n", this, "BIOSSettings::getACPIEnabled", *aACPIEnabled, hrc));
    return hrc;
}

STDMETHODIMP BIOSSettingsWrap::COMSETTER(ACPIEnabled)(BOOL aACPIEnabled)
{
    LogRelFlow(("{%p} %s: enter aACPIEnabled=%RTbool\n", this, "BIOSSettings::setACPIEnabled", aACPIEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_ACPIENABLED_ENTER(this, aACPIEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setACPIEnabled(aACPIEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_ACPIENABLED_RETURN(this, hrc, 0 /*normal*/,aACPIEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_ACPIENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aACPIEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_ACPIENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aACPIEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "BIOSSettings::setACPIEnabled", hrc));
    return hrc;
}

STDMETHODIMP BIOSSettingsWrap::COMGETTER(IOAPICEnabled)(BOOL *aIOAPICEnabled)
{
    LogRelFlow(("{%p} %s: enter aIOAPICEnabled=%p\n", this, "BIOSSettings::getIOAPICEnabled", aIOAPICEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIOAPICEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_IOAPICENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getIOAPICEnabled(aIOAPICEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_IOAPICENABLED_RETURN(this, hrc, 0 /*normal*/,*aIOAPICEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_IOAPICENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aIOAPICEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_IOAPICENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aIOAPICEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIOAPICEnabled=%RTbool hrc=%Rhrc\n", this, "BIOSSettings::getIOAPICEnabled", *aIOAPICEnabled, hrc));
    return hrc;
}

STDMETHODIMP BIOSSettingsWrap::COMSETTER(IOAPICEnabled)(BOOL aIOAPICEnabled)
{
    LogRelFlow(("{%p} %s: enter aIOAPICEnabled=%RTbool\n", this, "BIOSSettings::setIOAPICEnabled", aIOAPICEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_IOAPICENABLED_ENTER(this, aIOAPICEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setIOAPICEnabled(aIOAPICEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_IOAPICENABLED_RETURN(this, hrc, 0 /*normal*/,aIOAPICEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_IOAPICENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aIOAPICEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_IOAPICENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aIOAPICEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "BIOSSettings::setIOAPICEnabled", hrc));
    return hrc;
}

STDMETHODIMP BIOSSettingsWrap::COMGETTER(APICMode)(APICMode_T *aAPICMode)
{
    LogRelFlow(("{%p} %s: enter aAPICMode=%p\n", this, "BIOSSettings::getAPICMode", aAPICMode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAPICMode);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_APICMODE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAPICMode(aAPICMode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_APICMODE_RETURN(this, hrc, 0 /*normal*/,*aAPICMode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_APICMODE_RETURN(this, hrc, 1 /*hrc exception*/,*aAPICMode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_APICMODE_RETURN(this, hrc, 9 /*unhandled exception*/,*aAPICMode);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAPICMode=%RU32 hrc=%Rhrc\n", this, "BIOSSettings::getAPICMode", *aAPICMode, hrc));
    return hrc;
}

STDMETHODIMP BIOSSettingsWrap::COMSETTER(APICMode)(APICMode_T aAPICMode)
{
    LogRelFlow(("{%p} %s: enter aAPICMode=%RU32\n", this, "BIOSSettings::setAPICMode", aAPICMode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_APICMODE_ENTER(this, aAPICMode);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAPICMode(aAPICMode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_APICMODE_RETURN(this, hrc, 0 /*normal*/,aAPICMode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_APICMODE_RETURN(this, hrc, 1 /*hrc exception*/,aAPICMode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_APICMODE_RETURN(this, hrc, 9 /*unhandled exception*/,aAPICMode);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "BIOSSettings::setAPICMode", hrc));
    return hrc;
}

STDMETHODIMP BIOSSettingsWrap::COMGETTER(TimeOffset)(LONG64 *aTimeOffset)
{
    LogRelFlow(("{%p} %s: enter aTimeOffset=%p\n", this, "BIOSSettings::getTimeOffset", aTimeOffset));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aTimeOffset);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_TIMEOFFSET_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getTimeOffset(aTimeOffset);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_TIMEOFFSET_RETURN(this, hrc, 0 /*normal*/,*aTimeOffset);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_TIMEOFFSET_RETURN(this, hrc, 1 /*hrc exception*/,*aTimeOffset);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_TIMEOFFSET_RETURN(this, hrc, 9 /*unhandled exception*/,*aTimeOffset);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aTimeOffset=%RI64 hrc=%Rhrc\n", this, "BIOSSettings::getTimeOffset", *aTimeOffset, hrc));
    return hrc;
}

STDMETHODIMP BIOSSettingsWrap::COMSETTER(TimeOffset)(LONG64 aTimeOffset)
{
    LogRelFlow(("{%p} %s: enter aTimeOffset=%RI64\n", this, "BIOSSettings::setTimeOffset", aTimeOffset));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_TIMEOFFSET_ENTER(this, aTimeOffset);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setTimeOffset(aTimeOffset);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_TIMEOFFSET_RETURN(this, hrc, 0 /*normal*/,aTimeOffset);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_TIMEOFFSET_RETURN(this, hrc, 1 /*hrc exception*/,aTimeOffset);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_TIMEOFFSET_RETURN(this, hrc, 9 /*unhandled exception*/,aTimeOffset);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "BIOSSettings::setTimeOffset", hrc));
    return hrc;
}

STDMETHODIMP BIOSSettingsWrap::COMGETTER(PXEDebugEnabled)(BOOL *aPXEDebugEnabled)
{
    LogRelFlow(("{%p} %s: enter aPXEDebugEnabled=%p\n", this, "BIOSSettings::getPXEDebugEnabled", aPXEDebugEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPXEDebugEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_PXEDEBUGENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPXEDebugEnabled(aPXEDebugEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_PXEDEBUGENABLED_RETURN(this, hrc, 0 /*normal*/,*aPXEDebugEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_PXEDEBUGENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aPXEDebugEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_PXEDEBUGENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aPXEDebugEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPXEDebugEnabled=%RTbool hrc=%Rhrc\n", this, "BIOSSettings::getPXEDebugEnabled", *aPXEDebugEnabled, hrc));
    return hrc;
}

STDMETHODIMP BIOSSettingsWrap::COMSETTER(PXEDebugEnabled)(BOOL aPXEDebugEnabled)
{
    LogRelFlow(("{%p} %s: enter aPXEDebugEnabled=%RTbool\n", this, "BIOSSettings::setPXEDebugEnabled", aPXEDebugEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_PXEDEBUGENABLED_ENTER(this, aPXEDebugEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setPXEDebugEnabled(aPXEDebugEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_PXEDEBUGENABLED_RETURN(this, hrc, 0 /*normal*/,aPXEDebugEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_PXEDEBUGENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aPXEDebugEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_PXEDEBUGENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aPXEDebugEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "BIOSSettings::setPXEDebugEnabled", hrc));
    return hrc;
}

STDMETHODIMP BIOSSettingsWrap::COMGETTER(NonVolatileStorageFile)(BSTR *aNonVolatileStorageFile)
{
    LogRelFlow(("{%p} %s: enter aNonVolatileStorageFile=%p\n", this, "BIOSSettings::getNonVolatileStorageFile", aNonVolatileStorageFile));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNonVolatileStorageFile);
        BSTROutConverter TmpNonVolatileStorageFile(aNonVolatileStorageFile);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_NONVOLATILESTORAGEFILE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getNonVolatileStorageFile(TmpNonVolatileStorageFile.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_NONVOLATILESTORAGEFILE_RETURN(this, hrc, 0 /*normal*/,TmpNonVolatileStorageFile.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_NONVOLATILESTORAGEFILE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_NONVOLATILESTORAGEFILE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNonVolatileStorageFile=%ls hrc=%Rhrc\n", this, "BIOSSettings::getNonVolatileStorageFile", *aNonVolatileStorageFile, hrc));
    return hrc;
}

STDMETHODIMP BIOSSettingsWrap::COMGETTER(SMBIOSUuidLittleEndian)(BOOL *aSMBIOSUuidLittleEndian)
{
    LogRelFlow(("{%p} %s: enter aSMBIOSUuidLittleEndian=%p\n", this, "BIOSSettings::getSMBIOSUuidLittleEndian", aSMBIOSUuidLittleEndian));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSMBIOSUuidLittleEndian);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_SMBIOSUUIDLITTLEENDIAN_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSMBIOSUuidLittleEndian(aSMBIOSUuidLittleEndian);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_SMBIOSUUIDLITTLEENDIAN_RETURN(this, hrc, 0 /*normal*/,*aSMBIOSUuidLittleEndian != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_SMBIOSUUIDLITTLEENDIAN_RETURN(this, hrc, 1 /*hrc exception*/,*aSMBIOSUuidLittleEndian != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_GET_SMBIOSUUIDLITTLEENDIAN_RETURN(this, hrc, 9 /*unhandled exception*/,*aSMBIOSUuidLittleEndian != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSMBIOSUuidLittleEndian=%RTbool hrc=%Rhrc\n", this, "BIOSSettings::getSMBIOSUuidLittleEndian", *aSMBIOSUuidLittleEndian, hrc));
    return hrc;
}

STDMETHODIMP BIOSSettingsWrap::COMSETTER(SMBIOSUuidLittleEndian)(BOOL aSMBIOSUuidLittleEndian)
{
    LogRelFlow(("{%p} %s: enter aSMBIOSUuidLittleEndian=%RTbool\n", this, "BIOSSettings::setSMBIOSUuidLittleEndian", aSMBIOSUuidLittleEndian));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_SMBIOSUUIDLITTLEENDIAN_ENTER(this, aSMBIOSUuidLittleEndian != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setSMBIOSUuidLittleEndian(aSMBIOSUuidLittleEndian != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_SMBIOSUUIDLITTLEENDIAN_RETURN(this, hrc, 0 /*normal*/,aSMBIOSUuidLittleEndian != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_SMBIOSUUIDLITTLEENDIAN_RETURN(this, hrc, 1 /*hrc exception*/,aSMBIOSUuidLittleEndian != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BIOSSETTINGS_SET_SMBIOSUUIDLITTLEENDIAN_RETURN(this, hrc, 9 /*unhandled exception*/,aSMBIOSUuidLittleEndian != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "BIOSSettings::setSMBIOSUuidLittleEndian", hrc));
    return hrc;
}

STDMETHODIMP BIOSSettingsWrap::COMGETTER(InternalAndReservedAttribute1IBIOSSettings)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP BIOSSettingsWrap::COMGETTER(InternalAndReservedAttribute2IBIOSSettings)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP BIOSSettingsWrap::COMGETTER(InternalAndReservedAttribute3IBIOSSettings)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP BIOSSettingsWrap::COMGETTER(InternalAndReservedAttribute4IBIOSSettings)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP BIOSSettingsWrap::COMGETTER(InternalAndReservedAttribute5IBIOSSettings)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP BIOSSettingsWrap::COMGETTER(InternalAndReservedAttribute6IBIOSSettings)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP BIOSSettingsWrap::COMGETTER(InternalAndReservedAttribute7IBIOSSettings)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP BIOSSettingsWrap::COMGETTER(InternalAndReservedAttribute8IBIOSSettings)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IBIOSSettings methods
//

STDMETHODIMP BIOSSettingsWrap::InternalAndReservedMethod1IBIOSSettings()
{
    return E_NOTIMPL;
}

STDMETHODIMP BIOSSettingsWrap::InternalAndReservedMethod2IBIOSSettings()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(BIOSSettingsWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(BIOSSettingsWrap, IBIOSSettings)
#endif // VBOX_WITH_XPCOM

