// ##### ENDFILE "VirtualSystemDescriptionFormWrap.cpp"


// ##### BEGINFILE "CloudNetworkEnvironmentInfoWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for ICloudNetworkEnvironmentInfo.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_CLOUDNETWORKENVIRONMENTINFO

#include "CloudNetworkEnvironmentInfoWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(CloudNetworkEnvironmentInfoWrap)

//
// ICloudNetworkEnvironmentInfo properties
//

STDMETHODIMP CloudNetworkEnvironmentInfoWrap::COMGETTER(TunnelNetworkId)(BSTR *aTunnelNetworkId)
{
    LogRelFlow(("{%p} %s: enter aTunnelNetworkId=%p\n", this, "CloudNetworkEnvironmentInfo::getTunnelNetworkId", aTunnelNetworkId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aTunnelNetworkId);
        BSTROutConverter TmpTunnelNetworkId(aTunnelNetworkId);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORKENVIRONMENTINFO_GET_TUNNELNETWORKID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getTunnelNetworkId(TmpTunnelNetworkId.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORKENVIRONMENTINFO_GET_TUNNELNETWORKID_RETURN(this, hrc, 0 /*normal*/,TmpTunnelNetworkId.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORKENVIRONMENTINFO_GET_TUNNELNETWORKID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORKENVIRONMENTINFO_GET_TUNNELNETWORKID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aTunnelNetworkId=%ls hrc=%Rhrc\n", this, "CloudNetworkEnvironmentInfo::getTunnelNetworkId", *aTunnelNetworkId, hrc));
    return hrc;
}

STDMETHODIMP CloudNetworkEnvironmentInfoWrap::COMGETTER(InternalAndReservedAttribute1ICloudNetworkEnvironmentInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudNetworkEnvironmentInfoWrap::COMGETTER(InternalAndReservedAttribute2ICloudNetworkEnvironmentInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudNetworkEnvironmentInfoWrap::COMGETTER(InternalAndReservedAttribute3ICloudNetworkEnvironmentInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudNetworkEnvironmentInfoWrap::COMGETTER(InternalAndReservedAttribute4ICloudNetworkEnvironmentInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudNetworkEnvironmentInfoWrap::COMGETTER(InternalAndReservedAttribute5ICloudNetworkEnvironmentInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudNetworkEnvironmentInfoWrap::COMGETTER(InternalAndReservedAttribute6ICloudNetworkEnvironmentInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudNetworkEnvironmentInfoWrap::COMGETTER(InternalAndReservedAttribute7ICloudNetworkEnvironmentInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// ICloudNetworkEnvironmentInfo methods
//

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(CloudNetworkEnvironmentInfoWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(CloudNetworkEnvironmentInfoWrap, ICloudNetworkEnvironmentInfo)
#endif // VBOX_WITH_XPCOM

