// ##### ENDFILE "CloudClientWrap.cpp"


// ##### BEGINFILE "CloudProviderWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for ICloudProvider.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_CLOUDPROVIDER

#include "CloudProviderWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(CloudProviderWrap)

//
// ICloudProvider properties
//

STDMETHODIMP CloudProviderWrap::COMGETTER(Name)(BSTR *aName)
{
    LogRelFlow(("{%p} %s: enter aName=%p\n", this, "CloudProvider::getName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aName);
        BSTROutConverter TmpName(aName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_GET_NAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_GET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_GET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_GET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aName=%ls hrc=%Rhrc\n", this, "CloudProvider::getName", *aName, hrc));
    return hrc;
}

STDMETHODIMP CloudProviderWrap::COMGETTER(ShortName)(BSTR *aShortName)
{
    LogRelFlow(("{%p} %s: enter aShortName=%p\n", this, "CloudProvider::getShortName", aShortName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aShortName);
        BSTROutConverter TmpShortName(aShortName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_GET_SHORTNAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getShortName(TmpShortName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_GET_SHORTNAME_RETURN(this, hrc, 0 /*normal*/,TmpShortName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_GET_SHORTNAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_GET_SHORTNAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aShortName=%ls hrc=%Rhrc\n", this, "CloudProvider::getShortName", *aShortName, hrc));
    return hrc;
}

STDMETHODIMP CloudProviderWrap::COMGETTER(Id)(BSTR *aId)
{
    LogRelFlow(("{%p} %s: enter aId=%p\n", this, "CloudProvider::getId", aId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aId);
        UuidOutConverter TmpId(aId);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_GET_ID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getId(TmpId.uuid());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_GET_ID_RETURN(this, hrc, 0 /*normal*/,TmpId.uuid().toStringCurly().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_GET_ID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_GET_ID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aId=%ls hrc=%Rhrc\n", this, "CloudProvider::getId", *aId, hrc));
    return hrc;
}

STDMETHODIMP CloudProviderWrap::COMGETTER(Profiles)(ComSafeArrayOut(ICloudProfile *, aProfiles))
{
    LogRelFlow(("{%p} %s: enter aProfiles=%p\n", this, "CloudProvider::getProfiles", aProfiles));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProfiles);
        ArrayComTypeOutConverter<ICloudProfile> TmpProfiles(ComSafeArrayOutArg(aProfiles));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_GET_PROFILES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProfiles(TmpProfiles.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_GET_PROFILES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpProfiles.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_GET_PROFILES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_GET_PROFILES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aProfiles=%zu hrc=%Rhrc\n", this, "CloudProvider::getProfiles", ComSafeArraySize(*aProfiles), hrc));
    return hrc;
}

STDMETHODIMP CloudProviderWrap::COMGETTER(ProfileNames)(ComSafeArrayOut(BSTR, aProfileNames))
{
    LogRelFlow(("{%p} %s: enter aProfileNames=%p\n", this, "CloudProvider::getProfileNames", aProfileNames));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProfileNames);
        ArrayBSTROutConverter TmpProfileNames(ComSafeArrayOutArg(aProfileNames));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_GET_PROFILENAMES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProfileNames(TmpProfileNames.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_GET_PROFILENAMES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpProfileNames.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_GET_PROFILENAMES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_GET_PROFILENAMES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aProfileNames=%zu hrc=%Rhrc\n", this, "CloudProvider::getProfileNames", ComSafeArraySize(*aProfileNames), hrc));
    return hrc;
}

STDMETHODIMP CloudProviderWrap::COMGETTER(SupportedPropertyNames)(ComSafeArrayOut(BSTR, aSupportedPropertyNames))
{
    LogRelFlow(("{%p} %s: enter aSupportedPropertyNames=%p\n", this, "CloudProvider::getSupportedPropertyNames", aSupportedPropertyNames));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedPropertyNames);
        ArrayBSTROutConverter TmpSupportedPropertyNames(ComSafeArrayOutArg(aSupportedPropertyNames));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_GET_SUPPORTEDPROPERTYNAMES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedPropertyNames(TmpSupportedPropertyNames.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_GET_SUPPORTEDPROPERTYNAMES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedPropertyNames.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_GET_SUPPORTEDPROPERTYNAMES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_GET_SUPPORTEDPROPERTYNAMES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedPropertyNames=%zu hrc=%Rhrc\n", this, "CloudProvider::getSupportedPropertyNames", ComSafeArraySize(*aSupportedPropertyNames), hrc));
    return hrc;
}

STDMETHODIMP CloudProviderWrap::COMGETTER(InternalAndReservedAttribute1ICloudProvider)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudProviderWrap::COMGETTER(InternalAndReservedAttribute2ICloudProvider)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudProviderWrap::COMGETTER(InternalAndReservedAttribute3ICloudProvider)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudProviderWrap::COMGETTER(InternalAndReservedAttribute4ICloudProvider)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudProviderWrap::COMGETTER(InternalAndReservedAttribute5ICloudProvider)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudProviderWrap::COMGETTER(InternalAndReservedAttribute6ICloudProvider)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudProviderWrap::COMGETTER(InternalAndReservedAttribute7ICloudProvider)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudProviderWrap::COMGETTER(InternalAndReservedAttribute8ICloudProvider)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudProviderWrap::COMGETTER(InternalAndReservedAttribute9ICloudProvider)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudProviderWrap::COMGETTER(InternalAndReservedAttribute10ICloudProvider)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudProviderWrap::COMGETTER(InternalAndReservedAttribute11ICloudProvider)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudProviderWrap::COMGETTER(InternalAndReservedAttribute12ICloudProvider)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudProviderWrap::COMGETTER(InternalAndReservedAttribute13ICloudProvider)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudProviderWrap::COMGETTER(InternalAndReservedAttribute14ICloudProvider)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudProviderWrap::COMGETTER(InternalAndReservedAttribute15ICloudProvider)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudProviderWrap::COMGETTER(InternalAndReservedAttribute16ICloudProvider)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// ICloudProvider methods
//

STDMETHODIMP CloudProviderWrap::GetPropertyDescription(IN_BSTR aName,
                                                       BSTR *aDescription)
{
    LogRelFlow(("{%p} %s:enter aName=%ls aDescription=%p\n", this, "CloudProvider::getPropertyDescription", aName, aDescription));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDescription);


        BSTRInConverter TmpName(aName);
        BSTROutConverter TmpDescription(aDescription);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_GETPROPERTYDESCRIPTION_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPropertyDescription(TmpName.str(),
                                         TmpDescription.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_GETPROPERTYDESCRIPTION_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), TmpDescription.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_GETPROPERTYDESCRIPTION_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_GETPROPERTYDESCRIPTION_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aDescription=%ls hrc=%Rhrc\n", this, "CloudProvider::getPropertyDescription", *aDescription, hrc));
    return hrc;
}

STDMETHODIMP CloudProviderWrap::CreateProfile(IN_BSTR aProfileName,
                                              ComSafeArrayIn(IN_BSTR, aNames),
                                              ComSafeArrayIn(IN_BSTR, aValues))
{
    LogRelFlow(("{%p} %s:enter aProfileName=%ls aNames=%zu aValues=%zu\n", this, "CloudProvider::createProfile", aProfileName, aNames, aValues));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpProfileName(aProfileName);
        ArrayBSTRInConverter TmpNames(ComSafeArrayInArg(aNames));
        ArrayBSTRInConverter TmpValues(ComSafeArrayInArg(aValues));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_CREATEPROFILE_ENTER(this, TmpProfileName.str().c_str(), (uint32_t)TmpNames.array().size(), NULL /*for now*/, (uint32_t)TmpValues.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = createProfile(TmpProfileName.str(),
                                TmpNames.array(),
                                TmpValues.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_CREATEPROFILE_RETURN(this, hrc, 0 /*normal*/, TmpProfileName.str().c_str(), (uint32_t)TmpNames.array().size(), NULL /*for now*/, (uint32_t)TmpValues.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_CREATEPROFILE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_CREATEPROFILE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "CloudProvider::createProfile", hrc));
    return hrc;
}

STDMETHODIMP CloudProviderWrap::ImportProfiles()
{
    LogRelFlow(("{%p} %s:enter\n", this, "CloudProvider::importProfiles"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_IMPORTPROFILES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = importProfiles();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_IMPORTPROFILES_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_IMPORTPROFILES_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_IMPORTPROFILES_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "CloudProvider::importProfiles", hrc));
    return hrc;
}

STDMETHODIMP CloudProviderWrap::RestoreProfiles()
{
    LogRelFlow(("{%p} %s:enter\n", this, "CloudProvider::restoreProfiles"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_RESTOREPROFILES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = restoreProfiles();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_RESTOREPROFILES_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_RESTOREPROFILES_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_RESTOREPROFILES_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "CloudProvider::restoreProfiles", hrc));
    return hrc;
}

STDMETHODIMP CloudProviderWrap::SaveProfiles()
{
    LogRelFlow(("{%p} %s:enter\n", this, "CloudProvider::saveProfiles"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_SAVEPROFILES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = saveProfiles();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_SAVEPROFILES_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_SAVEPROFILES_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_SAVEPROFILES_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "CloudProvider::saveProfiles", hrc));
    return hrc;
}

STDMETHODIMP CloudProviderWrap::GetProfileByName(IN_BSTR aProfileName,
                                                 ICloudProfile **aProfile)
{
    LogRelFlow(("{%p} %s:enter aProfileName=%ls aProfile=%p\n", this, "CloudProvider::getProfileByName", aProfileName, aProfile));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProfile);


        BSTRInConverter TmpProfileName(aProfileName);
        ComTypeOutConverter<ICloudProfile> TmpProfile(aProfile);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_GETPROFILEBYNAME_ENTER(this, TmpProfileName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProfileByName(TmpProfileName.str(),
                                   TmpProfile.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_GETPROFILEBYNAME_RETURN(this, hrc, 0 /*normal*/, TmpProfileName.str().c_str(), (void *)TmpProfile.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_GETPROFILEBYNAME_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_GETPROFILEBYNAME_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProfile=%p hrc=%Rhrc\n", this, "CloudProvider::getProfileByName", *aProfile, hrc));
    return hrc;
}

STDMETHODIMP CloudProviderWrap::PrepareUninstall()
{
    LogRelFlow(("{%p} %s:enter\n", this, "CloudProvider::prepareUninstall"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_PREPAREUNINSTALL_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = prepareUninstall(autoCaller);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_PREPAREUNINSTALL_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_PREPAREUNINSTALL_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDER_PREPAREUNINSTALL_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "CloudProvider::prepareUninstall", hrc));
    return hrc;
}

STDMETHODIMP CloudProviderWrap::InternalAndReservedMethod1ICloudProvider()
{
    return E_NOTIMPL;
}

STDMETHODIMP CloudProviderWrap::InternalAndReservedMethod2ICloudProvider()
{
    return E_NOTIMPL;
}

STDMETHODIMP CloudProviderWrap::InternalAndReservedMethod3ICloudProvider()
{
    return E_NOTIMPL;
}

STDMETHODIMP CloudProviderWrap::InternalAndReservedMethod4ICloudProvider()
{
    return E_NOTIMPL;
}

STDMETHODIMP CloudProviderWrap::InternalAndReservedMethod5ICloudProvider()
{
    return E_NOTIMPL;
}

STDMETHODIMP CloudProviderWrap::InternalAndReservedMethod6ICloudProvider()
{
    return E_NOTIMPL;
}

STDMETHODIMP CloudProviderWrap::InternalAndReservedMethod7ICloudProvider()
{
    return E_NOTIMPL;
}

STDMETHODIMP CloudProviderWrap::InternalAndReservedMethod8ICloudProvider()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(CloudProviderWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(CloudProviderWrap, ICloudProvider)
#endif // VBOX_WITH_XPCOM

