// ##### ENDFILE "BandwidthControlWrap.cpp"


// ##### BEGINFILE "EventListenerWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IEventListener.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_EVENTLISTENER

#include "EventListenerWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(EventListenerWrap)

//
// IEventListener properties
//


//
// IEventListener methods
//

STDMETHODIMP EventListenerWrap::HandleEvent(IEvent *aEvent)
{
    LogRelFlow(("{%p} %s:enter aEvent=%p\n", this, "EventListener::handleEvent", aEvent));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ComTypeInConverter<IEvent> TmpEvent(aEvent);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENTLISTENER_HANDLEEVENT_ENTER(this, (void *)TmpEvent.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = handleEvent(TmpEvent.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENTLISTENER_HANDLEEVENT_RETURN(this, hrc, 0 /*normal*/, (void *)TmpEvent.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENTLISTENER_HANDLEEVENT_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EVENTLISTENER_HANDLEEVENT_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "EventListener::handleEvent", hrc));
    return hrc;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(EventListenerWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(EventListenerWrap, IEventListener)
#endif // VBOX_WITH_XPCOM

