// ##### ENDFILE "ExtPackBaseWrap.cpp"


// ##### BEGINFILE "ExtPackFileWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IExtPackFile.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_EXTPACKFILE

#include "ExtPackFileWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(ExtPackFileWrap)

//
// IExtPackBase properties
//

STDMETHODIMP ExtPackFileWrap::COMGETTER(Name)(BSTR *aName)
{
    LogRelFlow(("{%p} %s: enter aName=%p\n", this, "ExtPackFile::getName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aName);
        BSTROutConverter TmpName(aName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_NAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aName=%ls hrc=%Rhrc\n", this, "ExtPackFile::getName", *aName, hrc));
    return hrc;
}

STDMETHODIMP ExtPackFileWrap::COMGETTER(Description)(BSTR *aDescription)
{
    LogRelFlow(("{%p} %s: enter aDescription=%p\n", this, "ExtPackFile::getDescription", aDescription));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDescription);
        BSTROutConverter TmpDescription(aDescription);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_DESCRIPTION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDescription(TmpDescription.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_DESCRIPTION_RETURN(this, hrc, 0 /*normal*/,TmpDescription.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_DESCRIPTION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_DESCRIPTION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDescription=%ls hrc=%Rhrc\n", this, "ExtPackFile::getDescription", *aDescription, hrc));
    return hrc;
}

STDMETHODIMP ExtPackFileWrap::COMGETTER(Version)(BSTR *aVersion)
{
    LogRelFlow(("{%p} %s: enter aVersion=%p\n", this, "ExtPackFile::getVersion", aVersion));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVersion);
        BSTROutConverter TmpVersion(aVersion);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_VERSION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVersion(TmpVersion.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_VERSION_RETURN(this, hrc, 0 /*normal*/,TmpVersion.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_VERSION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_VERSION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVersion=%ls hrc=%Rhrc\n", this, "ExtPackFile::getVersion", *aVersion, hrc));
    return hrc;
}

STDMETHODIMP ExtPackFileWrap::COMGETTER(Revision)(ULONG *aRevision)
{
    LogRelFlow(("{%p} %s: enter aRevision=%p\n", this, "ExtPackFile::getRevision", aRevision));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRevision);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_REVISION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRevision(aRevision);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_REVISION_RETURN(this, hrc, 0 /*normal*/,*aRevision);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_REVISION_RETURN(this, hrc, 1 /*hrc exception*/,*aRevision);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_REVISION_RETURN(this, hrc, 9 /*unhandled exception*/,*aRevision);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRevision=%RU32 hrc=%Rhrc\n", this, "ExtPackFile::getRevision", *aRevision, hrc));
    return hrc;
}

STDMETHODIMP ExtPackFileWrap::COMGETTER(Edition)(BSTR *aEdition)
{
    LogRelFlow(("{%p} %s: enter aEdition=%p\n", this, "ExtPackFile::getEdition", aEdition));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEdition);
        BSTROutConverter TmpEdition(aEdition);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_EDITION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEdition(TmpEdition.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_EDITION_RETURN(this, hrc, 0 /*normal*/,TmpEdition.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_EDITION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_EDITION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEdition=%ls hrc=%Rhrc\n", this, "ExtPackFile::getEdition", *aEdition, hrc));
    return hrc;
}

STDMETHODIMP ExtPackFileWrap::COMGETTER(VRDEModule)(BSTR *aVRDEModule)
{
    LogRelFlow(("{%p} %s: enter aVRDEModule=%p\n", this, "ExtPackFile::getVRDEModule", aVRDEModule));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVRDEModule);
        BSTROutConverter TmpVRDEModule(aVRDEModule);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_VRDEMODULE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVRDEModule(TmpVRDEModule.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_VRDEMODULE_RETURN(this, hrc, 0 /*normal*/,TmpVRDEModule.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_VRDEMODULE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_VRDEMODULE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVRDEModule=%ls hrc=%Rhrc\n", this, "ExtPackFile::getVRDEModule", *aVRDEModule, hrc));
    return hrc;
}

STDMETHODIMP ExtPackFileWrap::COMGETTER(PlugIns)(ComSafeArrayOut(IExtPackPlugIn *, aPlugIns))
{
    LogRelFlow(("{%p} %s: enter aPlugIns=%p\n", this, "ExtPackFile::getPlugIns", aPlugIns));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPlugIns);
        ArrayComTypeOutConverter<IExtPackPlugIn> TmpPlugIns(ComSafeArrayOutArg(aPlugIns));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_PLUGINS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPlugIns(TmpPlugIns.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_PLUGINS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpPlugIns.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_PLUGINS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_PLUGINS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPlugIns=%zu hrc=%Rhrc\n", this, "ExtPackFile::getPlugIns", ComSafeArraySize(*aPlugIns), hrc));
    return hrc;
}

STDMETHODIMP ExtPackFileWrap::COMGETTER(Usable)(BOOL *aUsable)
{
    LogRelFlow(("{%p} %s: enter aUsable=%p\n", this, "ExtPackFile::getUsable", aUsable));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUsable);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_USABLE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUsable(aUsable);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_USABLE_RETURN(this, hrc, 0 /*normal*/,*aUsable != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_USABLE_RETURN(this, hrc, 1 /*hrc exception*/,*aUsable != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_USABLE_RETURN(this, hrc, 9 /*unhandled exception*/,*aUsable != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUsable=%RTbool hrc=%Rhrc\n", this, "ExtPackFile::getUsable", *aUsable, hrc));
    return hrc;
}

STDMETHODIMP ExtPackFileWrap::COMGETTER(WhyUnusable)(BSTR *aWhyUnusable)
{
    LogRelFlow(("{%p} %s: enter aWhyUnusable=%p\n", this, "ExtPackFile::getWhyUnusable", aWhyUnusable));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aWhyUnusable);
        BSTROutConverter TmpWhyUnusable(aWhyUnusable);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_WHYUNUSABLE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getWhyUnusable(TmpWhyUnusable.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_WHYUNUSABLE_RETURN(this, hrc, 0 /*normal*/,TmpWhyUnusable.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_WHYUNUSABLE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_WHYUNUSABLE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aWhyUnusable=%ls hrc=%Rhrc\n", this, "ExtPackFile::getWhyUnusable", *aWhyUnusable, hrc));
    return hrc;
}

STDMETHODIMP ExtPackFileWrap::COMGETTER(ShowLicense)(BOOL *aShowLicense)
{
    LogRelFlow(("{%p} %s: enter aShowLicense=%p\n", this, "ExtPackFile::getShowLicense", aShowLicense));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aShowLicense);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_SHOWLICENSE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getShowLicense(aShowLicense);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_SHOWLICENSE_RETURN(this, hrc, 0 /*normal*/,*aShowLicense != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_SHOWLICENSE_RETURN(this, hrc, 1 /*hrc exception*/,*aShowLicense != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_SHOWLICENSE_RETURN(this, hrc, 9 /*unhandled exception*/,*aShowLicense != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aShowLicense=%RTbool hrc=%Rhrc\n", this, "ExtPackFile::getShowLicense", *aShowLicense, hrc));
    return hrc;
}

STDMETHODIMP ExtPackFileWrap::COMGETTER(License)(BSTR *aLicense)
{
    LogRelFlow(("{%p} %s: enter aLicense=%p\n", this, "ExtPackFile::getLicense", aLicense));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLicense);
        BSTROutConverter TmpLicense(aLicense);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_LICENSE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLicense(TmpLicense.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_LICENSE_RETURN(this, hrc, 0 /*normal*/,TmpLicense.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_LICENSE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_LICENSE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLicense=%ls hrc=%Rhrc\n", this, "ExtPackFile::getLicense", *aLicense, hrc));
    return hrc;
}

STDMETHODIMP ExtPackFileWrap::COMGETTER(InternalAndReservedAttribute1IExtPackBase)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackFileWrap::COMGETTER(InternalAndReservedAttribute2IExtPackBase)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackFileWrap::COMGETTER(InternalAndReservedAttribute3IExtPackBase)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackFileWrap::COMGETTER(InternalAndReservedAttribute4IExtPackBase)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackFileWrap::COMGETTER(InternalAndReservedAttribute5IExtPackBase)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackFileWrap::COMGETTER(InternalAndReservedAttribute6IExtPackBase)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackFileWrap::COMGETTER(InternalAndReservedAttribute7IExtPackBase)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackFileWrap::COMGETTER(InternalAndReservedAttribute8IExtPackBase)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

//
// IExtPackFile properties
//

STDMETHODIMP ExtPackFileWrap::COMGETTER(FilePath)(BSTR *aFilePath)
{
    LogRelFlow(("{%p} %s: enter aFilePath=%p\n", this, "ExtPackFile::getFilePath", aFilePath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFilePath);
        BSTROutConverter TmpFilePath(aFilePath);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_FILEPATH_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getFilePath(TmpFilePath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_FILEPATH_RETURN(this, hrc, 0 /*normal*/,TmpFilePath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_FILEPATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_GET_FILEPATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aFilePath=%ls hrc=%Rhrc\n", this, "ExtPackFile::getFilePath", *aFilePath, hrc));
    return hrc;
}

STDMETHODIMP ExtPackFileWrap::COMGETTER(InternalAndReservedAttribute1IExtPackFile)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackFileWrap::COMGETTER(InternalAndReservedAttribute2IExtPackFile)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackFileWrap::COMGETTER(InternalAndReservedAttribute3IExtPackFile)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackFileWrap::COMGETTER(InternalAndReservedAttribute4IExtPackFile)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IExtPackBase methods
//

STDMETHODIMP ExtPackFileWrap::QueryLicense(IN_BSTR aPreferredLocale,
                                           IN_BSTR aPreferredLanguage,
                                           IN_BSTR aFormat,
                                           BSTR *aLicenseText)
{
    LogRelFlow(("{%p} %s:enter aPreferredLocale=%ls aPreferredLanguage=%ls aFormat=%ls aLicenseText=%p\n", this, "ExtPackFile::queryLicense", aPreferredLocale, aPreferredLanguage, aFormat, aLicenseText));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLicenseText);


        BSTRInConverter TmpPreferredLocale(aPreferredLocale);
        BSTRInConverter TmpPreferredLanguage(aPreferredLanguage);
        BSTRInConverter TmpFormat(aFormat);
        BSTROutConverter TmpLicenseText(aLicenseText);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_QUERYLICENSE_ENTER(this, TmpPreferredLocale.str().c_str(), TmpPreferredLanguage.str().c_str(), TmpFormat.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = queryLicense(TmpPreferredLocale.str(),
                               TmpPreferredLanguage.str(),
                               TmpFormat.str(),
                               TmpLicenseText.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_QUERYLICENSE_RETURN(this, hrc, 0 /*normal*/, TmpPreferredLocale.str().c_str(), TmpPreferredLanguage.str().c_str(), TmpFormat.str().c_str(), TmpLicenseText.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_QUERYLICENSE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_QUERYLICENSE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aLicenseText=%ls hrc=%Rhrc\n", this, "ExtPackFile::queryLicense", *aLicenseText, hrc));
    return hrc;
}

STDMETHODIMP ExtPackFileWrap::InternalAndReservedMethod1IExtPackBase()
{
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackFileWrap::InternalAndReservedMethod2IExtPackBase()
{
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackFileWrap::InternalAndReservedMethod3IExtPackBase()
{
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackFileWrap::InternalAndReservedMethod4IExtPackBase()
{
    return E_NOTIMPL;
}

//
// IExtPackFile methods
//

STDMETHODIMP ExtPackFileWrap::Install(BOOL aReplace,
                                      IN_BSTR aDisplayInfo,
                                      IProgress **aProgess)
{
    LogRelFlow(("{%p} %s:enter aReplace=%RTbool aDisplayInfo=%ls aProgess=%p\n", this, "ExtPackFile::install", aReplace, aDisplayInfo, aProgess));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgess);


        
        BSTRInConverter TmpDisplayInfo(aDisplayInfo);
        ComTypeOutConverter<IProgress> TmpProgess(aProgess);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_INSTALL_ENTER(this, aReplace != FALSE, TmpDisplayInfo.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = install(aReplace != FALSE,
                          TmpDisplayInfo.str(),
                          TmpProgess.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_INSTALL_RETURN(this, hrc, 0 /*normal*/, aReplace != FALSE, TmpDisplayInfo.str().c_str(), (void *)TmpProgess.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_INSTALL_RETURN(this, hrc, 1 /*hrc exception*/, aReplace != FALSE, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACKFILE_INSTALL_RETURN(this, hrc, 9 /*unhandled exception*/, aReplace != FALSE, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgess=%p hrc=%Rhrc\n", this, "ExtPackFile::install", *aProgess, hrc));
    return hrc;
}

STDMETHODIMP ExtPackFileWrap::InternalAndReservedMethod1IExtPackFile()
{
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackFileWrap::InternalAndReservedMethod2IExtPackFile()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(ExtPackFileWrap)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(ExtPackFileWrap, IExtPackFile, IExtPackBase)
#endif // VBOX_WITH_XPCOM

