// ##### ENDFILE "GuestDnDTargetWrap.h"


// ##### BEGINFILE "GuestSessionWrap.h"
/** @file
 * VirtualBox API class wrapper header for IGuestSession.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#ifndef GuestSessionWrap_H_
#define GuestSessionWrap_H_
#ifndef RT_WITHOUT_PRAGMA_ONCE
# pragma once
#endif

#include "VirtualBoxBase.h"
#include "Wrapper.h"

class ATL_NO_VTABLE GuestSessionWrap
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IGuestSession)
{
    Q_OBJECT

public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(GuestSessionWrap, IGuestSession)
    DECLARE_NOT_AGGREGATABLE(GuestSessionWrap)
    DECLARE_PROTECT_FINAL_CONSTRUCT()

    BEGIN_COM_MAP(GuestSessionWrap)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IGuestSession)
        COM_INTERFACE_ENTRY2(IDispatch, IGuestSession)
        VBOX_TWEAK_INTERFACE_ENTRY(IGuestSession)
    END_COM_MAP()

    DECLARE_EMPTY_CTOR_DTOR(GuestSessionWrap)

    /** @name Public IGuestSession properties
     * @{ */
    STDMETHOD(COMGETTER(User))(BSTR *aUser);
    STDMETHOD(COMGETTER(Domain))(BSTR *aDomain);
    STDMETHOD(COMGETTER(Name))(BSTR *aName);
    STDMETHOD(COMGETTER(Id))(ULONG *aId);
    STDMETHOD(COMGETTER(Timeout))(ULONG *aTimeout);
    STDMETHOD(COMSETTER(Timeout))(ULONG aTimeout);
    STDMETHOD(COMGETTER(ProtocolVersion))(ULONG *aProtocolVersion);
    STDMETHOD(COMGETTER(Status))(GuestSessionStatus_T *aStatus);
    STDMETHOD(COMGETTER(EnvironmentChanges))(ComSafeArrayOut(BSTR, aEnvironmentChanges));
    STDMETHOD(COMSETTER(EnvironmentChanges))(ComSafeArrayIn(IN_BSTR, aEnvironmentChanges));
    STDMETHOD(COMGETTER(EnvironmentBase))(ComSafeArrayOut(BSTR, aEnvironmentBase));
    STDMETHOD(COMGETTER(Processes))(ComSafeArrayOut(IGuestProcess *, aProcesses));
    STDMETHOD(COMGETTER(PathStyle))(PathStyle_T *aPathStyle);
    STDMETHOD(COMGETTER(CurrentDirectory))(BSTR *aCurrentDirectory);
    STDMETHOD(COMSETTER(CurrentDirectory))(IN_BSTR aCurrentDirectory);
    STDMETHOD(COMGETTER(UserHome))(BSTR *aUserHome);
    STDMETHOD(COMGETTER(UserDocuments))(BSTR *aUserDocuments);
    STDMETHOD(COMGETTER(Directories))(ComSafeArrayOut(IGuestDirectory *, aDirectories));
    STDMETHOD(COMGETTER(Files))(ComSafeArrayOut(IGuestFile *, aFiles));
    STDMETHOD(COMGETTER(EventSource))(IEventSource **aEventSource);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute1IGuestSession))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute2IGuestSession))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute3IGuestSession))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute4IGuestSession))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute5IGuestSession))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute6IGuestSession))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute7IGuestSession))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute8IGuestSession))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute9IGuestSession))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute10IGuestSession))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute11IGuestSession))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute12IGuestSession))(ULONG *aReserved);
    /** @} */

    /** @name Public IGuestSession methods
     * @{ */
    STDMETHOD(Close)();
    STDMETHOD(CopyFromGuest)(ComSafeArrayIn(IN_BSTR, aSources),
                             ComSafeArrayIn(IN_BSTR, aFilters),
                             ComSafeArrayIn(IN_BSTR, aFlags),
                             IN_BSTR aDestination,
                             IProgress **aProgress);
    STDMETHOD(CopyToGuest)(ComSafeArrayIn(IN_BSTR, aSources),
                           ComSafeArrayIn(IN_BSTR, aFilters),
                           ComSafeArrayIn(IN_BSTR, aFlags),
                           IN_BSTR aDestination,
                           IProgress **aProgress);
    STDMETHOD(DirectoryCopy)(IN_BSTR aSource,
                             IN_BSTR aDestination,
                             ComSafeArrayIn(DirectoryCopyFlag_T, aFlags),
                             IProgress **aProgress);
    STDMETHOD(DirectoryCopyFromGuest)(IN_BSTR aSource,
                                      IN_BSTR aDestination,
                                      ComSafeArrayIn(DirectoryCopyFlag_T, aFlags),
                                      IProgress **aProgress);
    STDMETHOD(DirectoryCopyToGuest)(IN_BSTR aSource,
                                    IN_BSTR aDestination,
                                    ComSafeArrayIn(DirectoryCopyFlag_T, aFlags),
                                    IProgress **aProgress);
    STDMETHOD(DirectoryCreate)(IN_BSTR aPath,
                               ULONG aMode,
                               ComSafeArrayIn(DirectoryCreateFlag_T, aFlags));
    STDMETHOD(DirectoryCreateTemp)(IN_BSTR aTemplateName,
                                   ULONG aMode,
                                   IN_BSTR aPath,
                                   BOOL aSecure,
                                   BSTR *aDirectory);
    STDMETHOD(DirectoryExists)(IN_BSTR aPath,
                               BOOL aFollowSymlinks,
                               BOOL *aExists);
    STDMETHOD(DirectoryOpen)(IN_BSTR aPath,
                             IN_BSTR aFilter,
                             ComSafeArrayIn(DirectoryOpenFlag_T, aFlags),
                             IGuestDirectory **aDirectory);
    STDMETHOD(DirectoryRemove)(IN_BSTR aPath);
    STDMETHOD(DirectoryRemoveRecursive)(IN_BSTR aPath,
                                        ComSafeArrayIn(DirectoryRemoveRecFlag_T, aFlags),
                                        IProgress **aProgress);
    STDMETHOD(EnvironmentScheduleSet)(IN_BSTR aName,
                                      IN_BSTR aValue);
    STDMETHOD(EnvironmentScheduleUnset)(IN_BSTR aName);
    STDMETHOD(EnvironmentGetBaseVariable)(IN_BSTR aName,
                                          BSTR *aValue);
    STDMETHOD(EnvironmentDoesBaseVariableExist)(IN_BSTR aName,
                                                BOOL *aExists);
    STDMETHOD(FileCopy)(IN_BSTR aSource,
                        IN_BSTR aDestination,
                        ComSafeArrayIn(FileCopyFlag_T, aFlags),
                        IProgress **aProgress);
    STDMETHOD(FileCopyFromGuest)(IN_BSTR aSource,
                                 IN_BSTR aDestination,
                                 ComSafeArrayIn(FileCopyFlag_T, aFlags),
                                 IProgress **aProgress);
    STDMETHOD(FileCopyToGuest)(IN_BSTR aSource,
                               IN_BSTR aDestination,
                               ComSafeArrayIn(FileCopyFlag_T, aFlags),
                               IProgress **aProgress);
    STDMETHOD(FileCreateTemp)(IN_BSTR aTemplateName,
                              ULONG aMode,
                              IN_BSTR aPath,
                              BOOL aSecure,
                              IGuestFile **aFile);
    STDMETHOD(FileExists)(IN_BSTR aPath,
                          BOOL aFollowSymlinks,
                          BOOL *aExists);
    STDMETHOD(FileOpen)(IN_BSTR aPath,
                        FileAccessMode_T aAccessMode,
                        FileOpenAction_T aOpenAction,
                        ULONG aCreationMode,
                        IGuestFile **aFile);
    STDMETHOD(FileOpenEx)(IN_BSTR aPath,
                          FileAccessMode_T aAccessMode,
                          FileOpenAction_T aOpenAction,
                          FileSharingMode_T aSharingMode,
                          ULONG aCreationMode,
                          ComSafeArrayIn(FileOpenExFlag_T, aFlags),
                          IGuestFile **aFile);
    STDMETHOD(FileQuerySize)(IN_BSTR aPath,
                             BOOL aFollowSymlinks,
                             LONG64 *aSize);
    STDMETHOD(FsObjExists)(IN_BSTR aPath,
                           BOOL aFollowSymlinks,
                           BOOL *aExists);
    STDMETHOD(FsObjQueryInfo)(IN_BSTR aPath,
                              BOOL aFollowSymlinks,
                              IGuestFsObjInfo **aInfo);
    STDMETHOD(FsObjRemove)(IN_BSTR aPath);
    STDMETHOD(FsObjRemoveArray)(ComSafeArrayIn(IN_BSTR, aPath),
                                IProgress **aProgress);
    STDMETHOD(FsObjRename)(IN_BSTR aOldPath,
                           IN_BSTR aNewPath,
                           ComSafeArrayIn(FsObjRenameFlag_T, aFlags));
    STDMETHOD(FsObjMove)(IN_BSTR aSource,
                         IN_BSTR aDestination,
                         ComSafeArrayIn(FsObjMoveFlag_T, aFlags),
                         IProgress **aProgress);
    STDMETHOD(FsObjMoveArray)(ComSafeArrayIn(IN_BSTR, aSource),
                              IN_BSTR aDestination,
                              ComSafeArrayIn(FsObjMoveFlag_T, aFlags),
                              IProgress **aProgress);
    STDMETHOD(FsObjCopyArray)(ComSafeArrayIn(IN_BSTR, aSource),
                              IN_BSTR aDestination,
                              ComSafeArrayIn(FileCopyFlag_T, aFlags),
                              IProgress **aProgress);
    STDMETHOD(FsObjSetACL)(IN_BSTR aPath,
                           BOOL aFollowSymlinks,
                           IN_BSTR aAcl,
                           ULONG aMode);
    STDMETHOD(ProcessCreate)(IN_BSTR aExecutable,
                             ComSafeArrayIn(IN_BSTR, aArguments),
                             ComSafeArrayIn(IN_BSTR, aEnvironmentChanges),
                             ComSafeArrayIn(ProcessCreateFlag_T, aFlags),
                             ULONG aTimeoutMS,
                             IGuestProcess **aGuestProcess);
    STDMETHOD(ProcessCreateEx)(IN_BSTR aExecutable,
                               ComSafeArrayIn(IN_BSTR, aArguments),
                               ComSafeArrayIn(IN_BSTR, aEnvironmentChanges),
                               ComSafeArrayIn(ProcessCreateFlag_T, aFlags),
                               ULONG aTimeoutMS,
                               ProcessPriority_T aPriority,
                               ComSafeArrayIn(LONG, aAffinity),
                               IGuestProcess **aGuestProcess);
    STDMETHOD(ProcessGet)(ULONG aPid,
                          IGuestProcess **aGuestProcess);
    STDMETHOD(SymlinkCreate)(IN_BSTR aSymlink,
                             IN_BSTR aTarget,
                             SymlinkType_T aType);
    STDMETHOD(SymlinkExists)(IN_BSTR aSymlink,
                             BOOL *aExists);
    STDMETHOD(SymlinkRead)(IN_BSTR aSymlink,
                           ComSafeArrayIn(SymlinkReadFlag_T, aFlags),
                           BSTR *aTarget);
    STDMETHOD(WaitFor)(ULONG aWaitFor,
                       ULONG aTimeoutMS,
                       GuestSessionWaitResult_T *aReason);
    STDMETHOD(WaitForArray)(ComSafeArrayIn(GuestSessionWaitForFlag_T, aWaitFor),
                            ULONG aTimeoutMS,
                            GuestSessionWaitResult_T *aReason);
    STDMETHOD(InternalAndReservedMethod1IGuestSession)();
    STDMETHOD(InternalAndReservedMethod2IGuestSession)();
    STDMETHOD(InternalAndReservedMethod3IGuestSession)();
    STDMETHOD(InternalAndReservedMethod4IGuestSession)();
    STDMETHOD(InternalAndReservedMethod5IGuestSession)();
    STDMETHOD(InternalAndReservedMethod6IGuestSession)();
    STDMETHOD(InternalAndReservedMethod7IGuestSession)();
    STDMETHOD(InternalAndReservedMethod8IGuestSession)();
    /** @} */

private:
    /** @name Wrapped IGuestSession properties
     * @{ */
    virtual HRESULT getUser(com::Utf8Str &aUser) = 0;
    virtual HRESULT getDomain(com::Utf8Str &aDomain) = 0;
    virtual HRESULT getName(com::Utf8Str &aName) = 0;
    virtual HRESULT getId(ULONG *aId) = 0;
    virtual HRESULT getTimeout(ULONG *aTimeout) = 0;
    virtual HRESULT setTimeout(ULONG aTimeout) = 0;
    virtual HRESULT getProtocolVersion(ULONG *aProtocolVersion) = 0;
    virtual HRESULT getStatus(GuestSessionStatus_T *aStatus) = 0;
    virtual HRESULT getEnvironmentChanges(std::vector<com::Utf8Str> &aEnvironmentChanges) = 0;
    virtual HRESULT setEnvironmentChanges(const std::vector<com::Utf8Str> &aEnvironmentChanges) = 0;
    virtual HRESULT getEnvironmentBase(std::vector<com::Utf8Str> &aEnvironmentBase) = 0;
    virtual HRESULT getProcesses(std::vector<ComPtr<IGuestProcess> > &aProcesses) = 0;
    virtual HRESULT getPathStyle(PathStyle_T *aPathStyle) = 0;
    virtual HRESULT getCurrentDirectory(com::Utf8Str &aCurrentDirectory) = 0;
    virtual HRESULT setCurrentDirectory(const com::Utf8Str &aCurrentDirectory) = 0;
    virtual HRESULT getUserHome(com::Utf8Str &aUserHome) = 0;
    virtual HRESULT getUserDocuments(com::Utf8Str &aUserDocuments) = 0;
    virtual HRESULT getDirectories(std::vector<ComPtr<IGuestDirectory> > &aDirectories) = 0;
    virtual HRESULT getFiles(std::vector<ComPtr<IGuestFile> > &aFiles) = 0;
    virtual HRESULT getEventSource(ComPtr<IEventSource> &aEventSource) = 0;
    /** @} */

    /** @name Wrapped IGuestSession methods
     * @{ */
    virtual HRESULT close() = 0;
    virtual HRESULT copyFromGuest(const std::vector<com::Utf8Str> &aSources,
                                  const std::vector<com::Utf8Str> &aFilters,
                                  const std::vector<com::Utf8Str> &aFlags,
                                  const com::Utf8Str &aDestination,
                                  ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT copyToGuest(const std::vector<com::Utf8Str> &aSources,
                                const std::vector<com::Utf8Str> &aFilters,
                                const std::vector<com::Utf8Str> &aFlags,
                                const com::Utf8Str &aDestination,
                                ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT directoryCopy(const com::Utf8Str &aSource,
                                  const com::Utf8Str &aDestination,
                                  const std::vector<DirectoryCopyFlag_T> &aFlags,
                                  ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT directoryCopyFromGuest(const com::Utf8Str &aSource,
                                           const com::Utf8Str &aDestination,
                                           const std::vector<DirectoryCopyFlag_T> &aFlags,
                                           ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT directoryCopyToGuest(const com::Utf8Str &aSource,
                                         const com::Utf8Str &aDestination,
                                         const std::vector<DirectoryCopyFlag_T> &aFlags,
                                         ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT directoryCreate(const com::Utf8Str &aPath,
                                    ULONG aMode,
                                    const std::vector<DirectoryCreateFlag_T> &aFlags) = 0;
    virtual HRESULT directoryCreateTemp(const com::Utf8Str &aTemplateName,
                                        ULONG aMode,
                                        const com::Utf8Str &aPath,
                                        BOOL aSecure,
                                        com::Utf8Str &aDirectory) = 0;
    virtual HRESULT directoryExists(const com::Utf8Str &aPath,
                                    BOOL aFollowSymlinks,
                                    BOOL *aExists) = 0;
    virtual HRESULT directoryOpen(const com::Utf8Str &aPath,
                                  const com::Utf8Str &aFilter,
                                  const std::vector<DirectoryOpenFlag_T> &aFlags,
                                  ComPtr<IGuestDirectory> &aDirectory) = 0;
    virtual HRESULT directoryRemove(const com::Utf8Str &aPath) = 0;
    virtual HRESULT directoryRemoveRecursive(const com::Utf8Str &aPath,
                                             const std::vector<DirectoryRemoveRecFlag_T> &aFlags,
                                             ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT environmentScheduleSet(const com::Utf8Str &aName,
                                           const com::Utf8Str &aValue) = 0;
    virtual HRESULT environmentScheduleUnset(const com::Utf8Str &aName) = 0;
    virtual HRESULT environmentGetBaseVariable(const com::Utf8Str &aName,
                                               com::Utf8Str &aValue) = 0;
    virtual HRESULT environmentDoesBaseVariableExist(const com::Utf8Str &aName,
                                                     BOOL *aExists) = 0;
    virtual HRESULT fileCopy(const com::Utf8Str &aSource,
                             const com::Utf8Str &aDestination,
                             const std::vector<FileCopyFlag_T> &aFlags,
                             ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT fileCopyFromGuest(const com::Utf8Str &aSource,
                                      const com::Utf8Str &aDestination,
                                      const std::vector<FileCopyFlag_T> &aFlags,
                                      ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT fileCopyToGuest(const com::Utf8Str &aSource,
                                    const com::Utf8Str &aDestination,
                                    const std::vector<FileCopyFlag_T> &aFlags,
                                    ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT fileCreateTemp(const com::Utf8Str &aTemplateName,
                                   ULONG aMode,
                                   const com::Utf8Str &aPath,
                                   BOOL aSecure,
                                   ComPtr<IGuestFile> &aFile) = 0;
    virtual HRESULT fileExists(const com::Utf8Str &aPath,
                               BOOL aFollowSymlinks,
                               BOOL *aExists) = 0;
    virtual HRESULT fileOpen(const com::Utf8Str &aPath,
                             FileAccessMode_T aAccessMode,
                             FileOpenAction_T aOpenAction,
                             ULONG aCreationMode,
                             ComPtr<IGuestFile> &aFile) = 0;
    virtual HRESULT fileOpenEx(const com::Utf8Str &aPath,
                               FileAccessMode_T aAccessMode,
                               FileOpenAction_T aOpenAction,
                               FileSharingMode_T aSharingMode,
                               ULONG aCreationMode,
                               const std::vector<FileOpenExFlag_T> &aFlags,
                               ComPtr<IGuestFile> &aFile) = 0;
    virtual HRESULT fileQuerySize(const com::Utf8Str &aPath,
                                  BOOL aFollowSymlinks,
                                  LONG64 *aSize) = 0;
    virtual HRESULT fsObjExists(const com::Utf8Str &aPath,
                                BOOL aFollowSymlinks,
                                BOOL *aExists) = 0;
    virtual HRESULT fsObjQueryInfo(const com::Utf8Str &aPath,
                                   BOOL aFollowSymlinks,
                                   ComPtr<IGuestFsObjInfo> &aInfo) = 0;
    virtual HRESULT fsObjRemove(const com::Utf8Str &aPath) = 0;
    virtual HRESULT fsObjRemoveArray(const std::vector<com::Utf8Str> &aPath,
                                     ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT fsObjRename(const com::Utf8Str &aOldPath,
                                const com::Utf8Str &aNewPath,
                                const std::vector<FsObjRenameFlag_T> &aFlags) = 0;
    virtual HRESULT fsObjMove(const com::Utf8Str &aSource,
                              const com::Utf8Str &aDestination,
                              const std::vector<FsObjMoveFlag_T> &aFlags,
                              ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT fsObjMoveArray(const std::vector<com::Utf8Str> &aSource,
                                   const com::Utf8Str &aDestination,
                                   const std::vector<FsObjMoveFlag_T> &aFlags,
                                   ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT fsObjCopyArray(const std::vector<com::Utf8Str> &aSource,
                                   const com::Utf8Str &aDestination,
                                   const std::vector<FileCopyFlag_T> &aFlags,
                                   ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT fsObjSetACL(const com::Utf8Str &aPath,
                                BOOL aFollowSymlinks,
                                const com::Utf8Str &aAcl,
                                ULONG aMode) = 0;
    virtual HRESULT processCreate(const com::Utf8Str &aExecutable,
                                  const std::vector<com::Utf8Str> &aArguments,
                                  const std::vector<com::Utf8Str> &aEnvironmentChanges,
                                  const std::vector<ProcessCreateFlag_T> &aFlags,
                                  ULONG aTimeoutMS,
                                  ComPtr<IGuestProcess> &aGuestProcess) = 0;
    virtual HRESULT processCreateEx(const com::Utf8Str &aExecutable,
                                    const std::vector<com::Utf8Str> &aArguments,
                                    const std::vector<com::Utf8Str> &aEnvironmentChanges,
                                    const std::vector<ProcessCreateFlag_T> &aFlags,
                                    ULONG aTimeoutMS,
                                    ProcessPriority_T aPriority,
                                    const std::vector<LONG> &aAffinity,
                                    ComPtr<IGuestProcess> &aGuestProcess) = 0;
    virtual HRESULT processGet(ULONG aPid,
                               ComPtr<IGuestProcess> &aGuestProcess) = 0;
    virtual HRESULT symlinkCreate(const com::Utf8Str &aSymlink,
                                  const com::Utf8Str &aTarget,
                                  SymlinkType_T aType) = 0;
    virtual HRESULT symlinkExists(const com::Utf8Str &aSymlink,
                                  BOOL *aExists) = 0;
    virtual HRESULT symlinkRead(const com::Utf8Str &aSymlink,
                                const std::vector<SymlinkReadFlag_T> &aFlags,
                                com::Utf8Str &aTarget) = 0;
    virtual HRESULT waitFor(ULONG aWaitFor,
                            ULONG aTimeoutMS,
                            GuestSessionWaitResult_T *aReason) = 0;
    virtual HRESULT waitForArray(const std::vector<GuestSessionWaitForFlag_T> &aWaitFor,
                                 ULONG aTimeoutMS,
                                 GuestSessionWaitResult_T *aReason) = 0;
    /** @} */

private:
    DECLARE_CLS_COPY_CTOR_ASSIGN_NOOP(GuestSessionWrap); /* Shuts up MSC warning C4625. */

};

#endif // !GuestSessionWrap_H_

