// ##### ENDFILE "FormValueWrap.cpp"


// ##### BEGINFILE "RangedIntegerFormValueWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IRangedIntegerFormValue.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_RANGEDINTEGERFORMVALUE

#include "RangedIntegerFormValueWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(RangedIntegerFormValueWrap)

//
// IFormValue properties
//

STDMETHODIMP RangedIntegerFormValueWrap::COMGETTER(Type)(FormValueType_T *aType)
{
    LogRelFlow(("{%p} %s: enter aType=%p\n", this, "RangedIntegerFormValue::getType", aType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_TYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getType(aType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_TYPE_RETURN(this, hrc, 0 /*normal*/,*aType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_TYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_TYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aType=%RU32 hrc=%Rhrc\n", this, "RangedIntegerFormValue::getType", *aType, hrc));
    return hrc;
}

STDMETHODIMP RangedIntegerFormValueWrap::COMGETTER(Generation)(LONG *aGeneration)
{
    LogRelFlow(("{%p} %s: enter aGeneration=%p\n", this, "RangedIntegerFormValue::getGeneration", aGeneration));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aGeneration);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_GENERATION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getGeneration(aGeneration);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_GENERATION_RETURN(this, hrc, 0 /*normal*/,*aGeneration);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_GENERATION_RETURN(this, hrc, 1 /*hrc exception*/,*aGeneration);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_GENERATION_RETURN(this, hrc, 9 /*unhandled exception*/,*aGeneration);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aGeneration=%RI32 hrc=%Rhrc\n", this, "RangedIntegerFormValue::getGeneration", *aGeneration, hrc));
    return hrc;
}

STDMETHODIMP RangedIntegerFormValueWrap::COMGETTER(Enabled)(BOOL *aEnabled)
{
    LogRelFlow(("{%p} %s: enter aEnabled=%p\n", this, "RangedIntegerFormValue::getEnabled", aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_ENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEnabled(aEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_ENABLED_RETURN(this, hrc, 0 /*normal*/,*aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_ENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_ENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEnabled=%RTbool hrc=%Rhrc\n", this, "RangedIntegerFormValue::getEnabled", *aEnabled, hrc));
    return hrc;
}

STDMETHODIMP RangedIntegerFormValueWrap::COMGETTER(Visible)(BOOL *aVisible)
{
    LogRelFlow(("{%p} %s: enter aVisible=%p\n", this, "RangedIntegerFormValue::getVisible", aVisible));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVisible);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_VISIBLE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVisible(aVisible);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_VISIBLE_RETURN(this, hrc, 0 /*normal*/,*aVisible != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_VISIBLE_RETURN(this, hrc, 1 /*hrc exception*/,*aVisible != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_VISIBLE_RETURN(this, hrc, 9 /*unhandled exception*/,*aVisible != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVisible=%RTbool hrc=%Rhrc\n", this, "RangedIntegerFormValue::getVisible", *aVisible, hrc));
    return hrc;
}

STDMETHODIMP RangedIntegerFormValueWrap::COMGETTER(Label)(BSTR *aLabel)
{
    LogRelFlow(("{%p} %s: enter aLabel=%p\n", this, "RangedIntegerFormValue::getLabel", aLabel));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLabel);
        BSTROutConverter TmpLabel(aLabel);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_LABEL_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLabel(TmpLabel.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_LABEL_RETURN(this, hrc, 0 /*normal*/,TmpLabel.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_LABEL_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_LABEL_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLabel=%ls hrc=%Rhrc\n", this, "RangedIntegerFormValue::getLabel", *aLabel, hrc));
    return hrc;
}

STDMETHODIMP RangedIntegerFormValueWrap::COMGETTER(Description)(BSTR *aDescription)
{
    LogRelFlow(("{%p} %s: enter aDescription=%p\n", this, "RangedIntegerFormValue::getDescription", aDescription));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDescription);
        BSTROutConverter TmpDescription(aDescription);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_DESCRIPTION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDescription(TmpDescription.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_DESCRIPTION_RETURN(this, hrc, 0 /*normal*/,TmpDescription.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_DESCRIPTION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_DESCRIPTION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDescription=%ls hrc=%Rhrc\n", this, "RangedIntegerFormValue::getDescription", *aDescription, hrc));
    return hrc;
}

STDMETHODIMP RangedIntegerFormValueWrap::COMGETTER(Help)(BSTR *aHelp)
{
    LogRelFlow(("{%p} %s: enter aHelp=%p\n", this, "RangedIntegerFormValue::getHelp", aHelp));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHelp);
        BSTROutConverter TmpHelp(aHelp);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_HELP_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHelp(TmpHelp.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_HELP_RETURN(this, hrc, 0 /*normal*/,TmpHelp.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_HELP_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_HELP_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHelp=%ls hrc=%Rhrc\n", this, "RangedIntegerFormValue::getHelp", *aHelp, hrc));
    return hrc;
}

STDMETHODIMP RangedIntegerFormValueWrap::COMGETTER(InternalAndReservedAttribute1IFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP RangedIntegerFormValueWrap::COMGETTER(InternalAndReservedAttribute2IFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP RangedIntegerFormValueWrap::COMGETTER(InternalAndReservedAttribute3IFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP RangedIntegerFormValueWrap::COMGETTER(InternalAndReservedAttribute4IFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP RangedIntegerFormValueWrap::COMGETTER(InternalAndReservedAttribute5IFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP RangedIntegerFormValueWrap::COMGETTER(InternalAndReservedAttribute6IFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP RangedIntegerFormValueWrap::COMGETTER(InternalAndReservedAttribute7IFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP RangedIntegerFormValueWrap::COMGETTER(InternalAndReservedAttribute8IFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

//
// IRangedIntegerFormValue properties
//

STDMETHODIMP RangedIntegerFormValueWrap::COMGETTER(Suffix)(BSTR *aSuffix)
{
    LogRelFlow(("{%p} %s: enter aSuffix=%p\n", this, "RangedIntegerFormValue::getSuffix", aSuffix));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSuffix);
        BSTROutConverter TmpSuffix(aSuffix);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_SUFFIX_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSuffix(TmpSuffix.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_SUFFIX_RETURN(this, hrc, 0 /*normal*/,TmpSuffix.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_SUFFIX_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_SUFFIX_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSuffix=%ls hrc=%Rhrc\n", this, "RangedIntegerFormValue::getSuffix", *aSuffix, hrc));
    return hrc;
}

STDMETHODIMP RangedIntegerFormValueWrap::COMGETTER(Minimum)(LONG *aMinimum)
{
    LogRelFlow(("{%p} %s: enter aMinimum=%p\n", this, "RangedIntegerFormValue::getMinimum", aMinimum));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMinimum);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_MINIMUM_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMinimum(aMinimum);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_MINIMUM_RETURN(this, hrc, 0 /*normal*/,*aMinimum);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_MINIMUM_RETURN(this, hrc, 1 /*hrc exception*/,*aMinimum);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_MINIMUM_RETURN(this, hrc, 9 /*unhandled exception*/,*aMinimum);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMinimum=%RI32 hrc=%Rhrc\n", this, "RangedIntegerFormValue::getMinimum", *aMinimum, hrc));
    return hrc;
}

STDMETHODIMP RangedIntegerFormValueWrap::COMGETTER(Maximum)(LONG *aMaximum)
{
    LogRelFlow(("{%p} %s: enter aMaximum=%p\n", this, "RangedIntegerFormValue::getMaximum", aMaximum));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMaximum);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_MAXIMUM_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMaximum(aMaximum);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_MAXIMUM_RETURN(this, hrc, 0 /*normal*/,*aMaximum);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_MAXIMUM_RETURN(this, hrc, 1 /*hrc exception*/,*aMaximum);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GET_MAXIMUM_RETURN(this, hrc, 9 /*unhandled exception*/,*aMaximum);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMaximum=%RI32 hrc=%Rhrc\n", this, "RangedIntegerFormValue::getMaximum", *aMaximum, hrc));
    return hrc;
}

STDMETHODIMP RangedIntegerFormValueWrap::COMGETTER(InternalAndReservedAttribute1IRangedIntegerFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP RangedIntegerFormValueWrap::COMGETTER(InternalAndReservedAttribute2IRangedIntegerFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP RangedIntegerFormValueWrap::COMGETTER(InternalAndReservedAttribute3IRangedIntegerFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP RangedIntegerFormValueWrap::COMGETTER(InternalAndReservedAttribute4IRangedIntegerFormValue)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IFormValue methods
//

STDMETHODIMP RangedIntegerFormValueWrap::InternalAndReservedMethod1IFormValue()
{
    return E_NOTIMPL;
}

STDMETHODIMP RangedIntegerFormValueWrap::InternalAndReservedMethod2IFormValue()
{
    return E_NOTIMPL;
}

STDMETHODIMP RangedIntegerFormValueWrap::InternalAndReservedMethod3IFormValue()
{
    return E_NOTIMPL;
}

STDMETHODIMP RangedIntegerFormValueWrap::InternalAndReservedMethod4IFormValue()
{
    return E_NOTIMPL;
}

//
// IRangedIntegerFormValue methods
//

STDMETHODIMP RangedIntegerFormValueWrap::GetInteger(LONG *aValue)
{
    LogRelFlow(("{%p} %s:enter aValue=%p\n", this, "RangedIntegerFormValue::getInteger", aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aValue);


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GETINTEGER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getInteger(aValue);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GETINTEGER_RETURN(this, hrc, 0 /*normal*/, *aValue);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GETINTEGER_RETURN(this, hrc, 1 /*hrc exception*/, *aValue);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_GETINTEGER_RETURN(this, hrc, 9 /*unhandled exception*/, *aValue);
#endif
    }

    LogRelFlow(("{%p} %s: leave aValue=%RI32 hrc=%Rhrc\n", this, "RangedIntegerFormValue::getInteger", *aValue, hrc));
    return hrc;
}

STDMETHODIMP RangedIntegerFormValueWrap::SetInteger(LONG aValue,
                                                    IProgress **aProgress)
{
    LogRelFlow(("{%p} %s:enter aValue=%RI32 aProgress=%p\n", this, "RangedIntegerFormValue::setInteger", aValue, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_SETINTEGER_ENTER(this, aValue);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setInteger(aValue,
                             TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_SETINTEGER_RETURN(this, hrc, 0 /*normal*/, aValue, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_SETINTEGER_RETURN(this, hrc, 1 /*hrc exception*/, aValue, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RANGEDINTEGERFORMVALUE_SETINTEGER_RETURN(this, hrc, 9 /*unhandled exception*/, aValue, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "RangedIntegerFormValue::setInteger", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP RangedIntegerFormValueWrap::InternalAndReservedMethod1IRangedIntegerFormValue()
{
    return E_NOTIMPL;
}

STDMETHODIMP RangedIntegerFormValueWrap::InternalAndReservedMethod2IRangedIntegerFormValue()
{
    return E_NOTIMPL;
}

STDMETHODIMP RangedIntegerFormValueWrap::InternalAndReservedMethod3IRangedIntegerFormValue()
{
    return E_NOTIMPL;
}

STDMETHODIMP RangedIntegerFormValueWrap::InternalAndReservedMethod4IRangedIntegerFormValue()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(RangedIntegerFormValueWrap)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(RangedIntegerFormValueWrap, IRangedIntegerFormValue, IFormValue)
#endif // VBOX_WITH_XPCOM

