// ##### ENDFILE "GuestScreenInfoWrap.cpp"


// ##### BEGINFILE "SerialPortWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for ISerialPort.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_SERIALPORT

#include "SerialPortWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(SerialPortWrap)

//
// ISerialPort properties
//

STDMETHODIMP SerialPortWrap::COMGETTER(Slot)(ULONG *aSlot)
{
    LogRelFlow(("{%p} %s: enter aSlot=%p\n", this, "SerialPort::getSlot", aSlot));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSlot);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_GET_SLOT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSlot(aSlot);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_GET_SLOT_RETURN(this, hrc, 0 /*normal*/,*aSlot);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_GET_SLOT_RETURN(this, hrc, 1 /*hrc exception*/,*aSlot);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_GET_SLOT_RETURN(this, hrc, 9 /*unhandled exception*/,*aSlot);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSlot=%RU32 hrc=%Rhrc\n", this, "SerialPort::getSlot", *aSlot, hrc));
    return hrc;
}

STDMETHODIMP SerialPortWrap::COMGETTER(Enabled)(BOOL *aEnabled)
{
    LogRelFlow(("{%p} %s: enter aEnabled=%p\n", this, "SerialPort::getEnabled", aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_GET_ENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEnabled(aEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_GET_ENABLED_RETURN(this, hrc, 0 /*normal*/,*aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_GET_ENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_GET_ENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEnabled=%RTbool hrc=%Rhrc\n", this, "SerialPort::getEnabled", *aEnabled, hrc));
    return hrc;
}

STDMETHODIMP SerialPortWrap::COMSETTER(Enabled)(BOOL aEnabled)
{
    LogRelFlow(("{%p} %s: enter aEnabled=%RTbool\n", this, "SerialPort::setEnabled", aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_SET_ENABLED_ENTER(this, aEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setEnabled(aEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_SET_ENABLED_RETURN(this, hrc, 0 /*normal*/,aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_SET_ENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_SET_ENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "SerialPort::setEnabled", hrc));
    return hrc;
}

STDMETHODIMP SerialPortWrap::COMGETTER(IOBase)(ULONG *aIOBase)
{
    LogRelFlow(("{%p} %s: enter aIOBase=%p\n", this, "SerialPort::getIOBase", aIOBase));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIOBase);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_GET_IOBASE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getIOBase(aIOBase);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_GET_IOBASE_RETURN(this, hrc, 0 /*normal*/,*aIOBase);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_GET_IOBASE_RETURN(this, hrc, 1 /*hrc exception*/,*aIOBase);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_GET_IOBASE_RETURN(this, hrc, 9 /*unhandled exception*/,*aIOBase);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIOBase=%RU32 hrc=%Rhrc\n", this, "SerialPort::getIOBase", *aIOBase, hrc));
    return hrc;
}

STDMETHODIMP SerialPortWrap::COMSETTER(IOBase)(ULONG aIOBase)
{
    LogRelFlow(("{%p} %s: enter aIOBase=%RU32\n", this, "SerialPort::setIOBase", aIOBase));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_SET_IOBASE_ENTER(this, aIOBase);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setIOBase(aIOBase);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_SET_IOBASE_RETURN(this, hrc, 0 /*normal*/,aIOBase);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_SET_IOBASE_RETURN(this, hrc, 1 /*hrc exception*/,aIOBase);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_SET_IOBASE_RETURN(this, hrc, 9 /*unhandled exception*/,aIOBase);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "SerialPort::setIOBase", hrc));
    return hrc;
}

STDMETHODIMP SerialPortWrap::COMGETTER(IRQ)(ULONG *aIRQ)
{
    LogRelFlow(("{%p} %s: enter aIRQ=%p\n", this, "SerialPort::getIRQ", aIRQ));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIRQ);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_GET_IRQ_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getIRQ(aIRQ);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_GET_IRQ_RETURN(this, hrc, 0 /*normal*/,*aIRQ);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_GET_IRQ_RETURN(this, hrc, 1 /*hrc exception*/,*aIRQ);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_GET_IRQ_RETURN(this, hrc, 9 /*unhandled exception*/,*aIRQ);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIRQ=%RU32 hrc=%Rhrc\n", this, "SerialPort::getIRQ", *aIRQ, hrc));
    return hrc;
}

STDMETHODIMP SerialPortWrap::COMSETTER(IRQ)(ULONG aIRQ)
{
    LogRelFlow(("{%p} %s: enter aIRQ=%RU32\n", this, "SerialPort::setIRQ", aIRQ));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_SET_IRQ_ENTER(this, aIRQ);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setIRQ(aIRQ);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_SET_IRQ_RETURN(this, hrc, 0 /*normal*/,aIRQ);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_SET_IRQ_RETURN(this, hrc, 1 /*hrc exception*/,aIRQ);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_SET_IRQ_RETURN(this, hrc, 9 /*unhandled exception*/,aIRQ);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "SerialPort::setIRQ", hrc));
    return hrc;
}

STDMETHODIMP SerialPortWrap::COMGETTER(HostMode)(PortMode_T *aHostMode)
{
    LogRelFlow(("{%p} %s: enter aHostMode=%p\n", this, "SerialPort::getHostMode", aHostMode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHostMode);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_GET_HOSTMODE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHostMode(aHostMode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_GET_HOSTMODE_RETURN(this, hrc, 0 /*normal*/,*aHostMode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_GET_HOSTMODE_RETURN(this, hrc, 1 /*hrc exception*/,*aHostMode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_GET_HOSTMODE_RETURN(this, hrc, 9 /*unhandled exception*/,*aHostMode);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHostMode=%RU32 hrc=%Rhrc\n", this, "SerialPort::getHostMode", *aHostMode, hrc));
    return hrc;
}

STDMETHODIMP SerialPortWrap::COMSETTER(HostMode)(PortMode_T aHostMode)
{
    LogRelFlow(("{%p} %s: enter aHostMode=%RU32\n", this, "SerialPort::setHostMode", aHostMode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_SET_HOSTMODE_ENTER(this, aHostMode);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setHostMode(aHostMode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_SET_HOSTMODE_RETURN(this, hrc, 0 /*normal*/,aHostMode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_SET_HOSTMODE_RETURN(this, hrc, 1 /*hrc exception*/,aHostMode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_SET_HOSTMODE_RETURN(this, hrc, 9 /*unhandled exception*/,aHostMode);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "SerialPort::setHostMode", hrc));
    return hrc;
}

STDMETHODIMP SerialPortWrap::COMGETTER(Server)(BOOL *aServer)
{
    LogRelFlow(("{%p} %s: enter aServer=%p\n", this, "SerialPort::getServer", aServer));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aServer);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_GET_SERVER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getServer(aServer);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_GET_SERVER_RETURN(this, hrc, 0 /*normal*/,*aServer != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_GET_SERVER_RETURN(this, hrc, 1 /*hrc exception*/,*aServer != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_GET_SERVER_RETURN(this, hrc, 9 /*unhandled exception*/,*aServer != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aServer=%RTbool hrc=%Rhrc\n", this, "SerialPort::getServer", *aServer, hrc));
    return hrc;
}

STDMETHODIMP SerialPortWrap::COMSETTER(Server)(BOOL aServer)
{
    LogRelFlow(("{%p} %s: enter aServer=%RTbool\n", this, "SerialPort::setServer", aServer));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_SET_SERVER_ENTER(this, aServer != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setServer(aServer != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_SET_SERVER_RETURN(this, hrc, 0 /*normal*/,aServer != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_SET_SERVER_RETURN(this, hrc, 1 /*hrc exception*/,aServer != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_SET_SERVER_RETURN(this, hrc, 9 /*unhandled exception*/,aServer != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "SerialPort::setServer", hrc));
    return hrc;
}

STDMETHODIMP SerialPortWrap::COMGETTER(Path)(BSTR *aPath)
{
    LogRelFlow(("{%p} %s: enter aPath=%p\n", this, "SerialPort::getPath", aPath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPath);
        BSTROutConverter TmpPath(aPath);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_GET_PATH_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPath(TmpPath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_GET_PATH_RETURN(this, hrc, 0 /*normal*/,TmpPath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_GET_PATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_GET_PATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPath=%ls hrc=%Rhrc\n", this, "SerialPort::getPath", *aPath, hrc));
    return hrc;
}

STDMETHODIMP SerialPortWrap::COMSETTER(Path)(IN_BSTR aPath)
{
    LogRelFlow(("{%p} %s: enter aPath=%ls\n", this, "SerialPort::setPath", aPath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpPath(aPath);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_SET_PATH_ENTER(this, TmpPath.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setPath(TmpPath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_SET_PATH_RETURN(this, hrc, 0 /*normal*/,TmpPath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_SET_PATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_SET_PATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "SerialPort::setPath", hrc));
    return hrc;
}

STDMETHODIMP SerialPortWrap::COMGETTER(UartType)(UartType_T *aUartType)
{
    LogRelFlow(("{%p} %s: enter aUartType=%p\n", this, "SerialPort::getUartType", aUartType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUartType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_GET_UARTTYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUartType(aUartType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_GET_UARTTYPE_RETURN(this, hrc, 0 /*normal*/,*aUartType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_GET_UARTTYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aUartType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_GET_UARTTYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aUartType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUartType=%RU32 hrc=%Rhrc\n", this, "SerialPort::getUartType", *aUartType, hrc));
    return hrc;
}

STDMETHODIMP SerialPortWrap::COMSETTER(UartType)(UartType_T aUartType)
{
    LogRelFlow(("{%p} %s: enter aUartType=%RU32\n", this, "SerialPort::setUartType", aUartType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_SET_UARTTYPE_ENTER(this, aUartType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setUartType(aUartType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_SET_UARTTYPE_RETURN(this, hrc, 0 /*normal*/,aUartType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_SET_UARTTYPE_RETURN(this, hrc, 1 /*hrc exception*/,aUartType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SERIALPORT_SET_UARTTYPE_RETURN(this, hrc, 9 /*unhandled exception*/,aUartType);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "SerialPort::setUartType", hrc));
    return hrc;
}

STDMETHODIMP SerialPortWrap::COMGETTER(InternalAndReservedAttribute1ISerialPort)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SerialPortWrap::COMGETTER(InternalAndReservedAttribute2ISerialPort)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SerialPortWrap::COMGETTER(InternalAndReservedAttribute3ISerialPort)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SerialPortWrap::COMGETTER(InternalAndReservedAttribute4ISerialPort)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// ISerialPort methods
//

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(SerialPortWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(SerialPortWrap, ISerialPort)
#endif // VBOX_WITH_XPCOM

