// ##### ENDFILE "USBDeviceFiltersWrap.cpp"


// ##### BEGINFILE "USBControllerWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IUSBController.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_USBCONTROLLER

#include "USBControllerWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(USBControllerWrap)

//
// IUSBController properties
//

STDMETHODIMP USBControllerWrap::COMGETTER(Name)(BSTR *aName)
{
    LogRelFlow(("{%p} %s: enter aName=%p\n", this, "USBController::getName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aName);
        BSTROutConverter TmpName(aName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBCONTROLLER_GET_NAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBCONTROLLER_GET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBCONTROLLER_GET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBCONTROLLER_GET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aName=%ls hrc=%Rhrc\n", this, "USBController::getName", *aName, hrc));
    return hrc;
}

STDMETHODIMP USBControllerWrap::COMSETTER(Name)(IN_BSTR aName)
{
    LogRelFlow(("{%p} %s: enter aName=%ls\n", this, "USBController::setName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpName(aName);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBCONTROLLER_SET_NAME_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBCONTROLLER_SET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBCONTROLLER_SET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBCONTROLLER_SET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "USBController::setName", hrc));
    return hrc;
}

STDMETHODIMP USBControllerWrap::COMGETTER(Type)(USBControllerType_T *aType)
{
    LogRelFlow(("{%p} %s: enter aType=%p\n", this, "USBController::getType", aType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBCONTROLLER_GET_TYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getType(aType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBCONTROLLER_GET_TYPE_RETURN(this, hrc, 0 /*normal*/,*aType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBCONTROLLER_GET_TYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBCONTROLLER_GET_TYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aType=%RU32 hrc=%Rhrc\n", this, "USBController::getType", *aType, hrc));
    return hrc;
}

STDMETHODIMP USBControllerWrap::COMSETTER(Type)(USBControllerType_T aType)
{
    LogRelFlow(("{%p} %s: enter aType=%RU32\n", this, "USBController::setType", aType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBCONTROLLER_SET_TYPE_ENTER(this, aType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setType(aType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBCONTROLLER_SET_TYPE_RETURN(this, hrc, 0 /*normal*/,aType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBCONTROLLER_SET_TYPE_RETURN(this, hrc, 1 /*hrc exception*/,aType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBCONTROLLER_SET_TYPE_RETURN(this, hrc, 9 /*unhandled exception*/,aType);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "USBController::setType", hrc));
    return hrc;
}

STDMETHODIMP USBControllerWrap::COMGETTER(USBStandard)(USHORT *aUSBStandard)
{
    LogRelFlow(("{%p} %s: enter aUSBStandard=%p\n", this, "USBController::getUSBStandard", aUSBStandard));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUSBStandard);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBCONTROLLER_GET_USBSTANDARD_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUSBStandard(aUSBStandard);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBCONTROLLER_GET_USBSTANDARD_RETURN(this, hrc, 0 /*normal*/,*aUSBStandard);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBCONTROLLER_GET_USBSTANDARD_RETURN(this, hrc, 1 /*hrc exception*/,*aUSBStandard);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBCONTROLLER_GET_USBSTANDARD_RETURN(this, hrc, 9 /*unhandled exception*/,*aUSBStandard);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUSBStandard=%RU16 hrc=%Rhrc\n", this, "USBController::getUSBStandard", *aUSBStandard, hrc));
    return hrc;
}

STDMETHODIMP USBControllerWrap::COMGETTER(InternalAndReservedAttribute1IUSBController)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP USBControllerWrap::COMGETTER(InternalAndReservedAttribute2IUSBController)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP USBControllerWrap::COMGETTER(InternalAndReservedAttribute3IUSBController)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP USBControllerWrap::COMGETTER(InternalAndReservedAttribute4IUSBController)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IUSBController methods
//

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(USBControllerWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(USBControllerWrap, IUSBController)
#endif // VBOX_WITH_XPCOM

