// ##### ENDFILE "VirtualSystemDescriptionWrap.h"


// ##### BEGINFILE "UnattendedWrap.h"
/** @file
 * VirtualBox API class wrapper header for IUnattended.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#ifndef UnattendedWrap_H_
#define UnattendedWrap_H_
#ifndef RT_WITHOUT_PRAGMA_ONCE
# pragma once
#endif

#include "VirtualBoxBase.h"
#include "Wrapper.h"

class ATL_NO_VTABLE UnattendedWrap
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IUnattended)
{
    Q_OBJECT

public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(UnattendedWrap, IUnattended)
    DECLARE_NOT_AGGREGATABLE(UnattendedWrap)
    DECLARE_PROTECT_FINAL_CONSTRUCT()

    BEGIN_COM_MAP(UnattendedWrap)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IUnattended)
        COM_INTERFACE_ENTRY2(IDispatch, IUnattended)
        VBOX_TWEAK_INTERFACE_ENTRY(IUnattended)
    END_COM_MAP()

    DECLARE_EMPTY_CTOR_DTOR(UnattendedWrap)

    /** @name Public IUnattended properties
     * @{ */
    STDMETHOD(COMGETTER(IsoPath))(BSTR *aIsoPath);
    STDMETHOD(COMSETTER(IsoPath))(IN_BSTR aIsoPath);
    STDMETHOD(COMGETTER(Machine))(IMachine **aMachine);
    STDMETHOD(COMSETTER(Machine))(IMachine *aMachine);
    STDMETHOD(COMGETTER(User))(BSTR *aUser);
    STDMETHOD(COMSETTER(User))(IN_BSTR aUser);
    STDMETHOD(COMGETTER(Password))(BSTR *aPassword);
    STDMETHOD(COMSETTER(Password))(IN_BSTR aPassword);
    STDMETHOD(COMGETTER(FullUserName))(BSTR *aFullUserName);
    STDMETHOD(COMSETTER(FullUserName))(IN_BSTR aFullUserName);
    STDMETHOD(COMGETTER(ProductKey))(BSTR *aProductKey);
    STDMETHOD(COMSETTER(ProductKey))(IN_BSTR aProductKey);
    STDMETHOD(COMGETTER(AdditionsIsoPath))(BSTR *aAdditionsIsoPath);
    STDMETHOD(COMSETTER(AdditionsIsoPath))(IN_BSTR aAdditionsIsoPath);
    STDMETHOD(COMGETTER(InstallGuestAdditions))(BOOL *aInstallGuestAdditions);
    STDMETHOD(COMSETTER(InstallGuestAdditions))(BOOL aInstallGuestAdditions);
    STDMETHOD(COMGETTER(ValidationKitIsoPath))(BSTR *aValidationKitIsoPath);
    STDMETHOD(COMSETTER(ValidationKitIsoPath))(IN_BSTR aValidationKitIsoPath);
    STDMETHOD(COMGETTER(InstallTestExecService))(BOOL *aInstallTestExecService);
    STDMETHOD(COMSETTER(InstallTestExecService))(BOOL aInstallTestExecService);
    STDMETHOD(COMGETTER(TimeZone))(BSTR *aTimeZone);
    STDMETHOD(COMSETTER(TimeZone))(IN_BSTR aTimeZone);
    STDMETHOD(COMGETTER(Locale))(BSTR *aLocale);
    STDMETHOD(COMSETTER(Locale))(IN_BSTR aLocale);
    STDMETHOD(COMGETTER(Language))(BSTR *aLanguage);
    STDMETHOD(COMSETTER(Language))(IN_BSTR aLanguage);
    STDMETHOD(COMGETTER(Country))(BSTR *aCountry);
    STDMETHOD(COMSETTER(Country))(IN_BSTR aCountry);
    STDMETHOD(COMGETTER(Proxy))(BSTR *aProxy);
    STDMETHOD(COMSETTER(Proxy))(IN_BSTR aProxy);
    STDMETHOD(COMGETTER(PackageSelectionAdjustments))(BSTR *aPackageSelectionAdjustments);
    STDMETHOD(COMSETTER(PackageSelectionAdjustments))(IN_BSTR aPackageSelectionAdjustments);
    STDMETHOD(COMGETTER(Hostname))(BSTR *aHostname);
    STDMETHOD(COMSETTER(Hostname))(IN_BSTR aHostname);
    STDMETHOD(COMGETTER(AuxiliaryBasePath))(BSTR *aAuxiliaryBasePath);
    STDMETHOD(COMSETTER(AuxiliaryBasePath))(IN_BSTR aAuxiliaryBasePath);
    STDMETHOD(COMGETTER(ImageIndex))(ULONG *aImageIndex);
    STDMETHOD(COMSETTER(ImageIndex))(ULONG aImageIndex);
    STDMETHOD(COMGETTER(ScriptTemplatePath))(BSTR *aScriptTemplatePath);
    STDMETHOD(COMSETTER(ScriptTemplatePath))(IN_BSTR aScriptTemplatePath);
    STDMETHOD(COMGETTER(PostInstallScriptTemplatePath))(BSTR *aPostInstallScriptTemplatePath);
    STDMETHOD(COMSETTER(PostInstallScriptTemplatePath))(IN_BSTR aPostInstallScriptTemplatePath);
    STDMETHOD(COMGETTER(PostInstallCommand))(BSTR *aPostInstallCommand);
    STDMETHOD(COMSETTER(PostInstallCommand))(IN_BSTR aPostInstallCommand);
    STDMETHOD(COMGETTER(ExtraInstallKernelParameters))(BSTR *aExtraInstallKernelParameters);
    STDMETHOD(COMSETTER(ExtraInstallKernelParameters))(IN_BSTR aExtraInstallKernelParameters);
    STDMETHOD(COMGETTER(DetectedOSTypeId))(BSTR *aDetectedOSTypeId);
    STDMETHOD(COMGETTER(DetectedOSVersion))(BSTR *aDetectedOSVersion);
    STDMETHOD(COMGETTER(DetectedOSFlavor))(BSTR *aDetectedOSFlavor);
    STDMETHOD(COMGETTER(DetectedOSLanguages))(BSTR *aDetectedOSLanguages);
    STDMETHOD(COMGETTER(DetectedOSHints))(BSTR *aDetectedOSHints);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute1IUnattended))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute2IUnattended))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute3IUnattended))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute4IUnattended))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute5IUnattended))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute6IUnattended))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute7IUnattended))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute8IUnattended))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute9IUnattended))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute10IUnattended))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute11IUnattended))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute12IUnattended))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute13IUnattended))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute14IUnattended))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute15IUnattended))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute16IUnattended))(ULONG *aReserved);
    /** @} */

    /** @name Public IUnattended methods
     * @{ */
    STDMETHOD(DetectIsoOS)();
    STDMETHOD(Prepare)();
    STDMETHOD(ConstructMedia)();
    STDMETHOD(ReconfigureVM)();
    STDMETHOD(Done)();
    STDMETHOD(InternalAndReservedMethod1IUnattended)();
    STDMETHOD(InternalAndReservedMethod2IUnattended)();
    STDMETHOD(InternalAndReservedMethod3IUnattended)();
    STDMETHOD(InternalAndReservedMethod4IUnattended)();
    /** @} */

private:
    /** @name Wrapped IUnattended properties
     * @{ */
    virtual HRESULT getIsoPath(com::Utf8Str &aIsoPath) = 0;
    virtual HRESULT setIsoPath(const com::Utf8Str &aIsoPath) = 0;
    virtual HRESULT getMachine(ComPtr<IMachine> &aMachine) = 0;
    virtual HRESULT setMachine(const ComPtr<IMachine> &aMachine) = 0;
    virtual HRESULT getUser(com::Utf8Str &aUser) = 0;
    virtual HRESULT setUser(const com::Utf8Str &aUser) = 0;
    virtual HRESULT getPassword(com::Utf8Str &aPassword) = 0;
    virtual HRESULT setPassword(const com::Utf8Str &aPassword) = 0;
    virtual HRESULT getFullUserName(com::Utf8Str &aFullUserName) = 0;
    virtual HRESULT setFullUserName(const com::Utf8Str &aFullUserName) = 0;
    virtual HRESULT getProductKey(com::Utf8Str &aProductKey) = 0;
    virtual HRESULT setProductKey(const com::Utf8Str &aProductKey) = 0;
    virtual HRESULT getAdditionsIsoPath(com::Utf8Str &aAdditionsIsoPath) = 0;
    virtual HRESULT setAdditionsIsoPath(const com::Utf8Str &aAdditionsIsoPath) = 0;
    virtual HRESULT getInstallGuestAdditions(BOOL *aInstallGuestAdditions) = 0;
    virtual HRESULT setInstallGuestAdditions(BOOL aInstallGuestAdditions) = 0;
    virtual HRESULT getValidationKitIsoPath(com::Utf8Str &aValidationKitIsoPath) = 0;
    virtual HRESULT setValidationKitIsoPath(const com::Utf8Str &aValidationKitIsoPath) = 0;
    virtual HRESULT getInstallTestExecService(BOOL *aInstallTestExecService) = 0;
    virtual HRESULT setInstallTestExecService(BOOL aInstallTestExecService) = 0;
    virtual HRESULT getTimeZone(com::Utf8Str &aTimeZone) = 0;
    virtual HRESULT setTimeZone(const com::Utf8Str &aTimeZone) = 0;
    virtual HRESULT getLocale(com::Utf8Str &aLocale) = 0;
    virtual HRESULT setLocale(const com::Utf8Str &aLocale) = 0;
    virtual HRESULT getLanguage(com::Utf8Str &aLanguage) = 0;
    virtual HRESULT setLanguage(const com::Utf8Str &aLanguage) = 0;
    virtual HRESULT getCountry(com::Utf8Str &aCountry) = 0;
    virtual HRESULT setCountry(const com::Utf8Str &aCountry) = 0;
    virtual HRESULT getProxy(com::Utf8Str &aProxy) = 0;
    virtual HRESULT setProxy(const com::Utf8Str &aProxy) = 0;
    virtual HRESULT getPackageSelectionAdjustments(com::Utf8Str &aPackageSelectionAdjustments) = 0;
    virtual HRESULT setPackageSelectionAdjustments(const com::Utf8Str &aPackageSelectionAdjustments) = 0;
    virtual HRESULT getHostname(com::Utf8Str &aHostname) = 0;
    virtual HRESULT setHostname(const com::Utf8Str &aHostname) = 0;
    virtual HRESULT getAuxiliaryBasePath(com::Utf8Str &aAuxiliaryBasePath) = 0;
    virtual HRESULT setAuxiliaryBasePath(const com::Utf8Str &aAuxiliaryBasePath) = 0;
    virtual HRESULT getImageIndex(ULONG *aImageIndex) = 0;
    virtual HRESULT setImageIndex(ULONG aImageIndex) = 0;
    virtual HRESULT getScriptTemplatePath(com::Utf8Str &aScriptTemplatePath) = 0;
    virtual HRESULT setScriptTemplatePath(const com::Utf8Str &aScriptTemplatePath) = 0;
    virtual HRESULT getPostInstallScriptTemplatePath(com::Utf8Str &aPostInstallScriptTemplatePath) = 0;
    virtual HRESULT setPostInstallScriptTemplatePath(const com::Utf8Str &aPostInstallScriptTemplatePath) = 0;
    virtual HRESULT getPostInstallCommand(com::Utf8Str &aPostInstallCommand) = 0;
    virtual HRESULT setPostInstallCommand(const com::Utf8Str &aPostInstallCommand) = 0;
    virtual HRESULT getExtraInstallKernelParameters(com::Utf8Str &aExtraInstallKernelParameters) = 0;
    virtual HRESULT setExtraInstallKernelParameters(const com::Utf8Str &aExtraInstallKernelParameters) = 0;
    virtual HRESULT getDetectedOSTypeId(com::Utf8Str &aDetectedOSTypeId) = 0;
    virtual HRESULT getDetectedOSVersion(com::Utf8Str &aDetectedOSVersion) = 0;
    virtual HRESULT getDetectedOSFlavor(com::Utf8Str &aDetectedOSFlavor) = 0;
    virtual HRESULT getDetectedOSLanguages(com::Utf8Str &aDetectedOSLanguages) = 0;
    virtual HRESULT getDetectedOSHints(com::Utf8Str &aDetectedOSHints) = 0;
    /** @} */

    /** @name Wrapped IUnattended methods
     * @{ */
    virtual HRESULT detectIsoOS() = 0;
    virtual HRESULT prepare() = 0;
    virtual HRESULT constructMedia() = 0;
    virtual HRESULT reconfigureVM() = 0;
    virtual HRESULT done() = 0;
    /** @} */

private:
    DECLARE_CLS_COPY_CTOR_ASSIGN_NOOP(UnattendedWrap); /* Shuts up MSC warning C4625. */

};

#endif // !UnattendedWrap_H_

