// ##### ENDFILE "BandwidthGroupWrap.cpp"


// ##### BEGINFILE "VirtualBoxClientWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IVirtualBoxClient.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_VIRTUALBOXCLIENT

#include "VirtualBoxClientWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(VirtualBoxClientWrap)

//
// IVirtualBoxClient properties
//

STDMETHODIMP VirtualBoxClientWrap::COMGETTER(VirtualBox)(IVirtualBox **aVirtualBox)
{
    LogRelFlow(("{%p} %s: enter aVirtualBox=%p\n", this, "VirtualBoxClient::getVirtualBox", aVirtualBox));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVirtualBox);
        ComTypeOutConverter<IVirtualBox> TmpVirtualBox(aVirtualBox);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOXCLIENT_GET_VIRTUALBOX_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVirtualBox(TmpVirtualBox.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOXCLIENT_GET_VIRTUALBOX_RETURN(this, hrc, 0 /*normal*/,(void *)TmpVirtualBox.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOXCLIENT_GET_VIRTUALBOX_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOXCLIENT_GET_VIRTUALBOX_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVirtualBox=%p hrc=%Rhrc\n", this, "VirtualBoxClient::getVirtualBox", *aVirtualBox, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxClientWrap::COMGETTER(Session)(ISession **aSession)
{
    LogRelFlow(("{%p} %s: enter aSession=%p\n", this, "VirtualBoxClient::getSession", aSession));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSession);
        ComTypeOutConverter<ISession> TmpSession(aSession);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOXCLIENT_GET_SESSION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSession(TmpSession.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOXCLIENT_GET_SESSION_RETURN(this, hrc, 0 /*normal*/,(void *)TmpSession.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOXCLIENT_GET_SESSION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOXCLIENT_GET_SESSION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSession=%p hrc=%Rhrc\n", this, "VirtualBoxClient::getSession", *aSession, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxClientWrap::COMGETTER(EventSource)(IEventSource **aEventSource)
{
    LogRelFlow(("{%p} %s: enter aEventSource=%p\n", this, "VirtualBoxClient::getEventSource", aEventSource));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEventSource);
        ComTypeOutConverter<IEventSource> TmpEventSource(aEventSource);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOXCLIENT_GET_EVENTSOURCE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEventSource(TmpEventSource.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOXCLIENT_GET_EVENTSOURCE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpEventSource.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOXCLIENT_GET_EVENTSOURCE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOXCLIENT_GET_EVENTSOURCE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEventSource=%p hrc=%Rhrc\n", this, "VirtualBoxClient::getEventSource", *aEventSource, hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxClientWrap::COMGETTER(InternalAndReservedAttribute1IVirtualBoxClient)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP VirtualBoxClientWrap::COMGETTER(InternalAndReservedAttribute2IVirtualBoxClient)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP VirtualBoxClientWrap::COMGETTER(InternalAndReservedAttribute3IVirtualBoxClient)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP VirtualBoxClientWrap::COMGETTER(InternalAndReservedAttribute4IVirtualBoxClient)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IVirtualBoxClient methods
//

STDMETHODIMP VirtualBoxClientWrap::CheckMachineError(IMachine *aMachine)
{
    LogRelFlow(("{%p} %s:enter aMachine=%p\n", this, "VirtualBoxClient::checkMachineError", aMachine));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ComTypeInConverter<IMachine> TmpMachine(aMachine);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOXCLIENT_CHECKMACHINEERROR_ENTER(this, (void *)TmpMachine.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = checkMachineError(TmpMachine.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOXCLIENT_CHECKMACHINEERROR_RETURN(this, hrc, 0 /*normal*/, (void *)TmpMachine.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOXCLIENT_CHECKMACHINEERROR_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALBOXCLIENT_CHECKMACHINEERROR_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "VirtualBoxClient::checkMachineError", hrc));
    return hrc;
}

STDMETHODIMP VirtualBoxClientWrap::InternalAndReservedMethod1IVirtualBoxClient()
{
    return E_NOTIMPL;
}

STDMETHODIMP VirtualBoxClientWrap::InternalAndReservedMethod2IVirtualBoxClient()
{
    return E_NOTIMPL;
}

STDMETHODIMP VirtualBoxClientWrap::InternalAndReservedMethod3IVirtualBoxClient()
{
    return E_NOTIMPL;
}

STDMETHODIMP VirtualBoxClientWrap::InternalAndReservedMethod4IVirtualBoxClient()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(VirtualBoxClientWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(VirtualBoxClientWrap, IVirtualBoxClient)
#endif // VBOX_WITH_XPCOM

