#
# Linux kernel configuration
#

# kernel fundamentals
LX_ENABLE += TTY SERIAL_EARLYCON SERIAL_OF_PLATFORM PRINTK HAS_IOMEM SMP

# support disabling ticking during idle
LX_ENABLE  += NO_HZ_IDLE HIGH_RES_TIMERS

# initrd support
LX_ENABLE += BINFMT_ELF BINFMT_SCRIPT BLK_DEV_INITRD

# kmem_cache allocator
LX_DISABLE += SLOB SLUB_DEBUG
LX_ENABLE  += SLUB

# UART device
LX_ENABLE += SERIAL_8250 SERIAL_8250_CONSOLE

# PCI support
LX_ENABLE += PCI PCI_MSI

# IOMMU support (used by Intel fb to apply scanout scratch page workaround)
LX_ENABLE += IOMMU_SUPPORT INTEL_IOMMU

# needed on new intel hardware (e.g. framework 13 / Meteorlake)
# that cpus will boot initially
LX_ENABLE += IRQ_REMAP X86_X2APIC

# to map scratch page for i915 on meteorlake, we need this
LX_ENABLE += MTRR X86_PAT

# ACPI support
LX_ENABLE += ACPI

# EFI support
LX_ENABLE += EFI EFI_STUB

# general network and WLAN support
LX_ENABLE += NET NETDEVICES PACKET
LX_ENABLE += WLAN CFG80211 MAC80211
LX_ENABLE += RFKILL

# iwlwifi
LX_ENABLE += WLAN_VENDOR_INTEL IWLWIFI IWLDVM IWLMVM

# rtlwifi
LX_ENABLE += WLAN_VENDOR_REALTEK RTL_CARDS RTL8188EE RTL8192CE

# ath9k
LX_ENABLE += WLAN_VENDOR_ATH ATH_COMMON ATH9K ATH9K_PCI
LX_ENABLE += ATH9K_DEBUGFS
#LX_ENABLE += ATH9K_RFKILL ATH9K_PCI_NO_EEPROM
#LX_ENABLE += ATH9K_HTC

# Ethernet NIC support
LX_ENABLE += E1000 E1000E PCNET32
LX_ENABLE += R8169

# USB host-controller support (keep USB_USBNET hook)
LX_ENABLE += USB_USBNET
LX_ENABLE += USB_SUPPORT USB USB_ARCH_HAS_HCD USB_XHCI_HCD USB_EHCI_HCD USB_OHCI_HCD
LX_ENABLE += USB_PCI USB_UHCI_HCD

# Intel i915 driver
LX_ENABLE += DRM DRM_I915

# required for GPIO irqchip on tigerlake and meteorlake
LX_ENABLE += PINCTRL PINCTRL_TIGERLAKE PINCTRL_METEORLAKE

# I2C HID touchpad support (keep INPUT_EVDEV hook)
LX_ENABLE += INPUT_EVDEV HID_GENERIC HID_MULTITOUCH
LX_ENABLE += MFD_INTEL_LPSS_PCI
LX_ENABLE += I2C_DESIGNWARE_CORE I2C_DESIGNWARE_PLATFORM
LX_ENABLE += I2C I2C_HID_ACPI

# no AML code is run that uses this feature
LX_DISABLE += ACPI_I2C_OPREGION

# to automatically set up screen mode at boot time
LX_ENABLE += FB

# GPIO for sound
LX_ENABLE += GPIOLIB GPIO_ACPI

# Sound
LX_ENABLE += SOUND SND AC97_BUS

LX_DISABLE += SND_DRIVERS SND_PCI SND_SUPPORT_OLD_API SND_USB SND_X86 SND_PROC_FS
# Intel HDA

LX_ENABLE += SND_HDA SND_HDA_CODEC_REALTEK SND_HDA_RECONFIG
LX_ENABLE += SND_HDA_PATCH_LOADER

# SOC
LX_ENABLE += SND_SOC SND_SOC_INTEL_HDA_DSP_COMMON ND
LX_ENABLE += SOC_INTEL_SKL_HDA_DSP_GENERIC_MACH
LX_ENABLE += SND_SOC_SOF_HDA_LINK CONFIG_SND_SOC_SOF_HDA_AUDIO_CODEC
LX_ENABLE += SND_SOC_HDAC_HDMI SND_SOC_HDAC_HDA SND_HDA_CODEC_HDMI
LX_ENABLE += SND_SOC_AC97_CODEC SND_SOC_INTEL_SKL_HDA_DSP_GENERIC_MACH

LX_DISABLE += SND_SST_ATOM_HIFI2_PLATFORM_ACPI

# SOF
LX_ENABLE += SND_SOC_SOF_TOPLEVEL SND_SOC_SOF_PCI SND_SOC_SOF_INTEL_TOPLEVEL

LX_DISABLE += SND_SOC_SOF_MERRIFIELD SND_SOC_SOF_INTEL_APL SND_SOC_SOF_APOLLOLAKE
LX_DISABLE += SND_SOC_SOF_GEMINILAKE SND_SOC_SOF_INTEL_CNL SND_SOC_SOF_CANNONLAKE
LX_DISABLE += SND_SOC_SOF_COFFEELAKE SND_SOC_SOF_COMETLAKE SND_SOC_SOF_INTEL_ICL
LX_DISABLE += SND_SOC_SOF_ICELAKE SND_SOC_SOF_JASPERLAKE SND_SOC_SOF_ALDERLAKE
LX_DISABLE += SND_SOC_SOF_ELKHARTLAKE

# mandatory fs support
LX_ENABLE += PROC_FS SYSFS

# Options for testing pc_linux images
#
# - network support for NFS root
#LX_ENABLE += INET IP_PNP IP_PNP_DHCP NFS_FS FILE_LOCKING MULTIUSER ROOT_NFS
# - log all input events (requires "debug" on the kernel commandline)
#LX_ENABLE += INPUT_EVBUG
# - in-kernel symbolic backtraces with show_stack(NULL, NULL, KERN_DEFAULT)
#LX_ENABLE += KALLSYMS
# - provide console on screen
#LX_ENABLE += FRAMEBUFFER_CONSOLE

# disable cpu frequency scaling
LX_DISABLE += SCHED_MC CPU_FREQ

# disable optimization not possible in PIC code under Genode
LX_DISABLE += CC_HAS_ASM_GOTO

LX_ENABLE += USB_HID

# slim down kernel by removing superfluous drivers
LX_DISABLE += VGA_CONSOLE DUMMY_CONSOLE NLS VGA_ARB DEBUG_LIST
