// ##### ENDFILE "FormWrap.cpp"


// ##### BEGINFILE "CloudNetworkGatewayInfoWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for ICloudNetworkGatewayInfo.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_CLOUDNETWORKGATEWAYINFO

#include "CloudNetworkGatewayInfoWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(CloudNetworkGatewayInfoWrap)

//
// ICloudNetworkGatewayInfo properties
//

STDMETHODIMP CloudNetworkGatewayInfoWrap::COMGETTER(PublicIP)(BSTR *aPublicIP)
{
    LogRelFlow(("{%p} %s: enter aPublicIP=%p\n", this, "CloudNetworkGatewayInfo::getPublicIP", aPublicIP));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPublicIP);
        BSTROutConverter TmpPublicIP(aPublicIP);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORKGATEWAYINFO_GET_PUBLICIP_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPublicIP(TmpPublicIP.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORKGATEWAYINFO_GET_PUBLICIP_RETURN(this, hrc, 0 /*normal*/,TmpPublicIP.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORKGATEWAYINFO_GET_PUBLICIP_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORKGATEWAYINFO_GET_PUBLICIP_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPublicIP=%ls hrc=%Rhrc\n", this, "CloudNetworkGatewayInfo::getPublicIP", *aPublicIP, hrc));
    return hrc;
}

STDMETHODIMP CloudNetworkGatewayInfoWrap::COMGETTER(SecondaryPublicIP)(BSTR *aSecondaryPublicIP)
{
    LogRelFlow(("{%p} %s: enter aSecondaryPublicIP=%p\n", this, "CloudNetworkGatewayInfo::getSecondaryPublicIP", aSecondaryPublicIP));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSecondaryPublicIP);
        BSTROutConverter TmpSecondaryPublicIP(aSecondaryPublicIP);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORKGATEWAYINFO_GET_SECONDARYPUBLICIP_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSecondaryPublicIP(TmpSecondaryPublicIP.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORKGATEWAYINFO_GET_SECONDARYPUBLICIP_RETURN(this, hrc, 0 /*normal*/,TmpSecondaryPublicIP.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORKGATEWAYINFO_GET_SECONDARYPUBLICIP_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORKGATEWAYINFO_GET_SECONDARYPUBLICIP_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSecondaryPublicIP=%ls hrc=%Rhrc\n", this, "CloudNetworkGatewayInfo::getSecondaryPublicIP", *aSecondaryPublicIP, hrc));
    return hrc;
}

STDMETHODIMP CloudNetworkGatewayInfoWrap::COMGETTER(MacAddress)(BSTR *aMacAddress)
{
    LogRelFlow(("{%p} %s: enter aMacAddress=%p\n", this, "CloudNetworkGatewayInfo::getMacAddress", aMacAddress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMacAddress);
        BSTROutConverter TmpMacAddress(aMacAddress);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORKGATEWAYINFO_GET_MACADDRESS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMacAddress(TmpMacAddress.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORKGATEWAYINFO_GET_MACADDRESS_RETURN(this, hrc, 0 /*normal*/,TmpMacAddress.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORKGATEWAYINFO_GET_MACADDRESS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORKGATEWAYINFO_GET_MACADDRESS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMacAddress=%ls hrc=%Rhrc\n", this, "CloudNetworkGatewayInfo::getMacAddress", *aMacAddress, hrc));
    return hrc;
}

STDMETHODIMP CloudNetworkGatewayInfoWrap::COMGETTER(InstanceId)(BSTR *aInstanceId)
{
    LogRelFlow(("{%p} %s: enter aInstanceId=%p\n", this, "CloudNetworkGatewayInfo::getInstanceId", aInstanceId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aInstanceId);
        BSTROutConverter TmpInstanceId(aInstanceId);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORKGATEWAYINFO_GET_INSTANCEID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getInstanceId(TmpInstanceId.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORKGATEWAYINFO_GET_INSTANCEID_RETURN(this, hrc, 0 /*normal*/,TmpInstanceId.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORKGATEWAYINFO_GET_INSTANCEID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDNETWORKGATEWAYINFO_GET_INSTANCEID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aInstanceId=%ls hrc=%Rhrc\n", this, "CloudNetworkGatewayInfo::getInstanceId", *aInstanceId, hrc));
    return hrc;
}

STDMETHODIMP CloudNetworkGatewayInfoWrap::COMGETTER(InternalAndReservedAttribute1ICloudNetworkGatewayInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudNetworkGatewayInfoWrap::COMGETTER(InternalAndReservedAttribute2ICloudNetworkGatewayInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudNetworkGatewayInfoWrap::COMGETTER(InternalAndReservedAttribute3ICloudNetworkGatewayInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudNetworkGatewayInfoWrap::COMGETTER(InternalAndReservedAttribute4ICloudNetworkGatewayInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudNetworkGatewayInfoWrap::COMGETTER(InternalAndReservedAttribute5ICloudNetworkGatewayInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// ICloudNetworkGatewayInfo methods
//

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(CloudNetworkGatewayInfoWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(CloudNetworkGatewayInfoWrap, ICloudNetworkGatewayInfo)
#endif // VBOX_WITH_XPCOM

