// ##### ENDFILE "DHCPGlobalConfigWrap.cpp"


// ##### BEGINFILE "DHCPGroupConfigWrap.cpp"
/** @file
 * VirtualBox API class wrapper code for IDHCPGroupConfig.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#define LOG_GROUP LOG_GROUP_MAIN_DHCPGROUPCONFIG

#include "DHCPGroupConfigWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(DHCPGroupConfigWrap)

//
// IDHCPConfig properties
//

STDMETHODIMP DHCPGroupConfigWrap::COMGETTER(Scope)(DHCPConfigScope_T *aScope)
{
    LogRelFlow(("{%p} %s: enter aScope=%p\n", this, "DHCPGroupConfig::getScope", aScope));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aScope);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GET_SCOPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getScope(aScope);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GET_SCOPE_RETURN(this, hrc, 0 /*normal*/,*aScope);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GET_SCOPE_RETURN(this, hrc, 1 /*hrc exception*/,*aScope);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GET_SCOPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aScope);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aScope=%RU32 hrc=%Rhrc\n", this, "DHCPGroupConfig::getScope", *aScope, hrc));
    return hrc;
}

STDMETHODIMP DHCPGroupConfigWrap::COMGETTER(MinLeaseTime)(ULONG *aMinLeaseTime)
{
    LogRelFlow(("{%p} %s: enter aMinLeaseTime=%p\n", this, "DHCPGroupConfig::getMinLeaseTime", aMinLeaseTime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMinLeaseTime);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GET_MINLEASETIME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMinLeaseTime(aMinLeaseTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GET_MINLEASETIME_RETURN(this, hrc, 0 /*normal*/,*aMinLeaseTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GET_MINLEASETIME_RETURN(this, hrc, 1 /*hrc exception*/,*aMinLeaseTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GET_MINLEASETIME_RETURN(this, hrc, 9 /*unhandled exception*/,*aMinLeaseTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMinLeaseTime=%RU32 hrc=%Rhrc\n", this, "DHCPGroupConfig::getMinLeaseTime", *aMinLeaseTime, hrc));
    return hrc;
}

STDMETHODIMP DHCPGroupConfigWrap::COMSETTER(MinLeaseTime)(ULONG aMinLeaseTime)
{
    LogRelFlow(("{%p} %s: enter aMinLeaseTime=%RU32\n", this, "DHCPGroupConfig::setMinLeaseTime", aMinLeaseTime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_SET_MINLEASETIME_ENTER(this, aMinLeaseTime);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setMinLeaseTime(aMinLeaseTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_SET_MINLEASETIME_RETURN(this, hrc, 0 /*normal*/,aMinLeaseTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_SET_MINLEASETIME_RETURN(this, hrc, 1 /*hrc exception*/,aMinLeaseTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_SET_MINLEASETIME_RETURN(this, hrc, 9 /*unhandled exception*/,aMinLeaseTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPGroupConfig::setMinLeaseTime", hrc));
    return hrc;
}

STDMETHODIMP DHCPGroupConfigWrap::COMGETTER(DefaultLeaseTime)(ULONG *aDefaultLeaseTime)
{
    LogRelFlow(("{%p} %s: enter aDefaultLeaseTime=%p\n", this, "DHCPGroupConfig::getDefaultLeaseTime", aDefaultLeaseTime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDefaultLeaseTime);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GET_DEFAULTLEASETIME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDefaultLeaseTime(aDefaultLeaseTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GET_DEFAULTLEASETIME_RETURN(this, hrc, 0 /*normal*/,*aDefaultLeaseTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GET_DEFAULTLEASETIME_RETURN(this, hrc, 1 /*hrc exception*/,*aDefaultLeaseTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GET_DEFAULTLEASETIME_RETURN(this, hrc, 9 /*unhandled exception*/,*aDefaultLeaseTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDefaultLeaseTime=%RU32 hrc=%Rhrc\n", this, "DHCPGroupConfig::getDefaultLeaseTime", *aDefaultLeaseTime, hrc));
    return hrc;
}

STDMETHODIMP DHCPGroupConfigWrap::COMSETTER(DefaultLeaseTime)(ULONG aDefaultLeaseTime)
{
    LogRelFlow(("{%p} %s: enter aDefaultLeaseTime=%RU32\n", this, "DHCPGroupConfig::setDefaultLeaseTime", aDefaultLeaseTime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_SET_DEFAULTLEASETIME_ENTER(this, aDefaultLeaseTime);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setDefaultLeaseTime(aDefaultLeaseTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_SET_DEFAULTLEASETIME_RETURN(this, hrc, 0 /*normal*/,aDefaultLeaseTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_SET_DEFAULTLEASETIME_RETURN(this, hrc, 1 /*hrc exception*/,aDefaultLeaseTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_SET_DEFAULTLEASETIME_RETURN(this, hrc, 9 /*unhandled exception*/,aDefaultLeaseTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPGroupConfig::setDefaultLeaseTime", hrc));
    return hrc;
}

STDMETHODIMP DHCPGroupConfigWrap::COMGETTER(MaxLeaseTime)(ULONG *aMaxLeaseTime)
{
    LogRelFlow(("{%p} %s: enter aMaxLeaseTime=%p\n", this, "DHCPGroupConfig::getMaxLeaseTime", aMaxLeaseTime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMaxLeaseTime);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GET_MAXLEASETIME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMaxLeaseTime(aMaxLeaseTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GET_MAXLEASETIME_RETURN(this, hrc, 0 /*normal*/,*aMaxLeaseTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GET_MAXLEASETIME_RETURN(this, hrc, 1 /*hrc exception*/,*aMaxLeaseTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GET_MAXLEASETIME_RETURN(this, hrc, 9 /*unhandled exception*/,*aMaxLeaseTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMaxLeaseTime=%RU32 hrc=%Rhrc\n", this, "DHCPGroupConfig::getMaxLeaseTime", *aMaxLeaseTime, hrc));
    return hrc;
}

STDMETHODIMP DHCPGroupConfigWrap::COMSETTER(MaxLeaseTime)(ULONG aMaxLeaseTime)
{
    LogRelFlow(("{%p} %s: enter aMaxLeaseTime=%RU32\n", this, "DHCPGroupConfig::setMaxLeaseTime", aMaxLeaseTime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_SET_MAXLEASETIME_ENTER(this, aMaxLeaseTime);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setMaxLeaseTime(aMaxLeaseTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_SET_MAXLEASETIME_RETURN(this, hrc, 0 /*normal*/,aMaxLeaseTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_SET_MAXLEASETIME_RETURN(this, hrc, 1 /*hrc exception*/,aMaxLeaseTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_SET_MAXLEASETIME_RETURN(this, hrc, 9 /*unhandled exception*/,aMaxLeaseTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPGroupConfig::setMaxLeaseTime", hrc));
    return hrc;
}

STDMETHODIMP DHCPGroupConfigWrap::COMGETTER(ForcedOptions)(ComSafeArrayOut(DHCPOption_T, aForcedOptions))
{
    LogRelFlow(("{%p} %s: enter aForcedOptions=%p\n", this, "DHCPGroupConfig::getForcedOptions", aForcedOptions));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aForcedOptions);
        ArrayOutConverter<DHCPOption_T> TmpForcedOptions(ComSafeArrayOutArg(aForcedOptions));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GET_FORCEDOPTIONS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getForcedOptions(TmpForcedOptions.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GET_FORCEDOPTIONS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpForcedOptions.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GET_FORCEDOPTIONS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GET_FORCEDOPTIONS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aForcedOptions=%zu hrc=%Rhrc\n", this, "DHCPGroupConfig::getForcedOptions", ComSafeArraySize(*aForcedOptions), hrc));
    return hrc;
}

STDMETHODIMP DHCPGroupConfigWrap::COMSETTER(ForcedOptions)(ComSafeArrayIn(DHCPOption_T, aForcedOptions))
{
    LogRelFlow(("{%p} %s: enter aForcedOptions=%zu\n", this, "DHCPGroupConfig::setForcedOptions", ComSafeArraySize(aForcedOptions)));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        ArrayInConverter<DHCPOption_T> TmpForcedOptions(ComSafeArrayInArg(aForcedOptions));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_SET_FORCEDOPTIONS_ENTER(this, (uint32_t)TmpForcedOptions.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setForcedOptions(TmpForcedOptions.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_SET_FORCEDOPTIONS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpForcedOptions.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_SET_FORCEDOPTIONS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_SET_FORCEDOPTIONS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPGroupConfig::setForcedOptions", hrc));
    return hrc;
}

STDMETHODIMP DHCPGroupConfigWrap::COMGETTER(SuppressedOptions)(ComSafeArrayOut(DHCPOption_T, aSuppressedOptions))
{
    LogRelFlow(("{%p} %s: enter aSuppressedOptions=%p\n", this, "DHCPGroupConfig::getSuppressedOptions", aSuppressedOptions));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSuppressedOptions);
        ArrayOutConverter<DHCPOption_T> TmpSuppressedOptions(ComSafeArrayOutArg(aSuppressedOptions));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GET_SUPPRESSEDOPTIONS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSuppressedOptions(TmpSuppressedOptions.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GET_SUPPRESSEDOPTIONS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSuppressedOptions.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GET_SUPPRESSEDOPTIONS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GET_SUPPRESSEDOPTIONS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSuppressedOptions=%zu hrc=%Rhrc\n", this, "DHCPGroupConfig::getSuppressedOptions", ComSafeArraySize(*aSuppressedOptions), hrc));
    return hrc;
}

STDMETHODIMP DHCPGroupConfigWrap::COMSETTER(SuppressedOptions)(ComSafeArrayIn(DHCPOption_T, aSuppressedOptions))
{
    LogRelFlow(("{%p} %s: enter aSuppressedOptions=%zu\n", this, "DHCPGroupConfig::setSuppressedOptions", ComSafeArraySize(aSuppressedOptions)));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        ArrayInConverter<DHCPOption_T> TmpSuppressedOptions(ComSafeArrayInArg(aSuppressedOptions));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_SET_SUPPRESSEDOPTIONS_ENTER(this, (uint32_t)TmpSuppressedOptions.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setSuppressedOptions(TmpSuppressedOptions.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_SET_SUPPRESSEDOPTIONS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSuppressedOptions.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_SET_SUPPRESSEDOPTIONS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_SET_SUPPRESSEDOPTIONS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPGroupConfig::setSuppressedOptions", hrc));
    return hrc;
}

STDMETHODIMP DHCPGroupConfigWrap::COMGETTER(InternalAndReservedAttribute1IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::COMGETTER(InternalAndReservedAttribute2IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::COMGETTER(InternalAndReservedAttribute3IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::COMGETTER(InternalAndReservedAttribute4IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::COMGETTER(InternalAndReservedAttribute5IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::COMGETTER(InternalAndReservedAttribute6IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::COMGETTER(InternalAndReservedAttribute7IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::COMGETTER(InternalAndReservedAttribute8IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::COMGETTER(InternalAndReservedAttribute9IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::COMGETTER(InternalAndReservedAttribute10IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::COMGETTER(InternalAndReservedAttribute11IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::COMGETTER(InternalAndReservedAttribute12IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::COMGETTER(InternalAndReservedAttribute13IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::COMGETTER(InternalAndReservedAttribute14IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::COMGETTER(InternalAndReservedAttribute15IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::COMGETTER(InternalAndReservedAttribute16IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

//
// IDHCPGroupConfig properties
//

STDMETHODIMP DHCPGroupConfigWrap::COMGETTER(Name)(BSTR *aName)
{
    LogRelFlow(("{%p} %s: enter aName=%p\n", this, "DHCPGroupConfig::getName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aName);
        BSTROutConverter TmpName(aName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GET_NAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aName=%ls hrc=%Rhrc\n", this, "DHCPGroupConfig::getName", *aName, hrc));
    return hrc;
}

STDMETHODIMP DHCPGroupConfigWrap::COMSETTER(Name)(IN_BSTR aName)
{
    LogRelFlow(("{%p} %s: enter aName=%ls\n", this, "DHCPGroupConfig::setName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpName(aName);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_SET_NAME_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_SET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_SET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_SET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPGroupConfig::setName", hrc));
    return hrc;
}

STDMETHODIMP DHCPGroupConfigWrap::COMGETTER(Conditions)(ComSafeArrayOut(IDHCPGroupCondition *, aConditions))
{
    LogRelFlow(("{%p} %s: enter aConditions=%p\n", this, "DHCPGroupConfig::getConditions", aConditions));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aConditions);
        ArrayComTypeOutConverter<IDHCPGroupCondition> TmpConditions(ComSafeArrayOutArg(aConditions));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GET_CONDITIONS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getConditions(TmpConditions.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GET_CONDITIONS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpConditions.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GET_CONDITIONS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GET_CONDITIONS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aConditions=%zu hrc=%Rhrc\n", this, "DHCPGroupConfig::getConditions", ComSafeArraySize(*aConditions), hrc));
    return hrc;
}

STDMETHODIMP DHCPGroupConfigWrap::COMGETTER(InternalAndReservedAttribute1IDHCPGroupConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::COMGETTER(InternalAndReservedAttribute2IDHCPGroupConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::COMGETTER(InternalAndReservedAttribute3IDHCPGroupConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::COMGETTER(InternalAndReservedAttribute4IDHCPGroupConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::COMGETTER(InternalAndReservedAttribute5IDHCPGroupConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::COMGETTER(InternalAndReservedAttribute6IDHCPGroupConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::COMGETTER(InternalAndReservedAttribute7IDHCPGroupConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::COMGETTER(InternalAndReservedAttribute8IDHCPGroupConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IDHCPConfig methods
//

STDMETHODIMP DHCPGroupConfigWrap::SetOption(DHCPOption_T aOption,
                                            DHCPOptionEncoding_T aEncoding,
                                            IN_BSTR aValue)
{
    LogRelFlow(("{%p} %s:enter aOption=%RU32 aEncoding=%RU32 aValue=%ls\n", this, "DHCPGroupConfig::setOption", aOption, aEncoding, aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        
        BSTRInConverter TmpValue(aValue);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_SETOPTION_ENTER(this, aOption, aEncoding, TmpValue.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = setOption(aOption,
                            aEncoding,
                            TmpValue.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_SETOPTION_RETURN(this, hrc, 0 /*normal*/, aOption, aEncoding, TmpValue.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_SETOPTION_RETURN(this, hrc, 1 /*hrc exception*/, aOption, aEncoding, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_SETOPTION_RETURN(this, hrc, 9 /*unhandled exception*/, aOption, aEncoding, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPGroupConfig::setOption", hrc));
    return hrc;
}

STDMETHODIMP DHCPGroupConfigWrap::RemoveOption(DHCPOption_T aOption)
{
    LogRelFlow(("{%p} %s:enter aOption=%RU32\n", this, "DHCPGroupConfig::removeOption", aOption));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_REMOVEOPTION_ENTER(this, aOption);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = removeOption(aOption);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_REMOVEOPTION_RETURN(this, hrc, 0 /*normal*/, aOption);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_REMOVEOPTION_RETURN(this, hrc, 1 /*hrc exception*/, aOption);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_REMOVEOPTION_RETURN(this, hrc, 9 /*unhandled exception*/, aOption);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPGroupConfig::removeOption", hrc));
    return hrc;
}

STDMETHODIMP DHCPGroupConfigWrap::RemoveAllOptions()
{
    LogRelFlow(("{%p} %s:enter\n", this, "DHCPGroupConfig::removeAllOptions"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_REMOVEALLOPTIONS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = removeAllOptions();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_REMOVEALLOPTIONS_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_REMOVEALLOPTIONS_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_REMOVEALLOPTIONS_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPGroupConfig::removeAllOptions", hrc));
    return hrc;
}

STDMETHODIMP DHCPGroupConfigWrap::GetOption(DHCPOption_T aOption,
                                            DHCPOptionEncoding_T *aEncoding,
                                            BSTR *aValue)
{
    LogRelFlow(("{%p} %s:enter aOption=%RU32 aEncoding=%p aValue=%p\n", this, "DHCPGroupConfig::getOption", aOption, aEncoding, aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEncoding);
        CheckComArgOutPointerValidThrow(aValue);


        
        
        BSTROutConverter TmpValue(aValue);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GETOPTION_ENTER(this, aOption);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getOption(aOption,
                            aEncoding,
                            TmpValue.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GETOPTION_RETURN(this, hrc, 0 /*normal*/, aOption, *aEncoding, TmpValue.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GETOPTION_RETURN(this, hrc, 1 /*hrc exception*/, aOption, *aEncoding, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GETOPTION_RETURN(this, hrc, 9 /*unhandled exception*/, aOption, *aEncoding, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEncoding=%RU32 aValue=%ls hrc=%Rhrc\n", this, "DHCPGroupConfig::getOption", *aEncoding, *aValue, hrc));
    return hrc;
}

STDMETHODIMP DHCPGroupConfigWrap::GetAllOptions(ComSafeArrayOut(DHCPOption_T, aOptions),
                                                ComSafeArrayOut(DHCPOptionEncoding_T, aEncodings),
                                                ComSafeArrayOut(BSTR, aValues))
{
    LogRelFlow(("{%p} %s:enter aOptions=%p aEncodings=%p aValues=%p\n", this, "DHCPGroupConfig::getAllOptions", aOptions, aEncodings, aValues));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aOptions);
        CheckComArgOutPointerValidThrow(aEncodings);
        CheckComArgOutPointerValidThrow(aValues);


        ArrayOutConverter<DHCPOption_T> TmpOptions(ComSafeArrayOutArg(aOptions));
        ArrayOutConverter<DHCPOptionEncoding_T> TmpEncodings(ComSafeArrayOutArg(aEncodings));
        ArrayBSTROutConverter TmpValues(ComSafeArrayOutArg(aValues));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GETALLOPTIONS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAllOptions(TmpOptions.array(),
                                TmpEncodings.array(),
                                TmpValues.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GETALLOPTIONS_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpOptions.array().size(), NULL /*for now*/, (uint32_t)TmpEncodings.array().size(), NULL /*for now*/, (uint32_t)TmpValues.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GETALLOPTIONS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_GETALLOPTIONS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aOptions=%zu *aEncodings=%zu aValues=%zu hrc=%Rhrc\n", this, "DHCPGroupConfig::getAllOptions", ComSafeArraySize(*aOptions), ComSafeArraySize(*aEncodings), ComSafeArraySize(*aValues), hrc));
    return hrc;
}

STDMETHODIMP DHCPGroupConfigWrap::Remove()
{
    LogRelFlow(("{%p} %s:enter\n", this, "DHCPGroupConfig::remove"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_REMOVE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = remove();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_REMOVE_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_REMOVE_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_REMOVE_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPGroupConfig::remove", hrc));
    return hrc;
}

STDMETHODIMP DHCPGroupConfigWrap::InternalAndReservedMethod1IDHCPConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::InternalAndReservedMethod2IDHCPConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::InternalAndReservedMethod3IDHCPConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::InternalAndReservedMethod4IDHCPConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::InternalAndReservedMethod5IDHCPConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::InternalAndReservedMethod6IDHCPConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::InternalAndReservedMethod7IDHCPConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::InternalAndReservedMethod8IDHCPConfig()
{
    return E_NOTIMPL;
}

//
// IDHCPGroupConfig methods
//

STDMETHODIMP DHCPGroupConfigWrap::AddCondition(BOOL aInclusive,
                                               DHCPGroupConditionType_T aType,
                                               IN_BSTR aValue,
                                               IDHCPGroupCondition **aCondition)
{
    LogRelFlow(("{%p} %s:enter aInclusive=%RTbool aType=%RU32 aValue=%ls aCondition=%p\n", this, "DHCPGroupConfig::addCondition", aInclusive, aType, aValue, aCondition));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCondition);


        
        
        BSTRInConverter TmpValue(aValue);
        ComTypeOutConverter<IDHCPGroupCondition> TmpCondition(aCondition);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_ADDCONDITION_ENTER(this, aInclusive != FALSE, aType, TmpValue.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = addCondition(aInclusive != FALSE,
                               aType,
                               TmpValue.str(),
                               TmpCondition.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_ADDCONDITION_RETURN(this, hrc, 0 /*normal*/, aInclusive != FALSE, aType, TmpValue.str().c_str(), (void *)TmpCondition.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_ADDCONDITION_RETURN(this, hrc, 1 /*hrc exception*/, aInclusive != FALSE, aType, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_ADDCONDITION_RETURN(this, hrc, 9 /*unhandled exception*/, aInclusive != FALSE, aType, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aCondition=%p hrc=%Rhrc\n", this, "DHCPGroupConfig::addCondition", *aCondition, hrc));
    return hrc;
}

STDMETHODIMP DHCPGroupConfigWrap::RemoveAllConditions()
{
    LogRelFlow(("{%p} %s:enter\n", this, "DHCPGroupConfig::removeAllConditions"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_REMOVEALLCONDITIONS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.rc();
        if (SUCCEEDED(hrc))
        {
            hrc = removeAllConditions();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_REMOVEALLCONDITIONS_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_REMOVEALLCONDITIONS_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONFIG_REMOVEALLCONDITIONS_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPGroupConfig::removeAllConditions", hrc));
    return hrc;
}

STDMETHODIMP DHCPGroupConfigWrap::InternalAndReservedMethod1IDHCPGroupConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::InternalAndReservedMethod2IDHCPGroupConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::InternalAndReservedMethod3IDHCPGroupConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::InternalAndReservedMethod4IDHCPGroupConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::InternalAndReservedMethod5IDHCPGroupConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::InternalAndReservedMethod6IDHCPGroupConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::InternalAndReservedMethod7IDHCPGroupConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConfigWrap::InternalAndReservedMethod8IDHCPGroupConfig()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(DHCPGroupConfigWrap)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(DHCPGroupConfigWrap, IDHCPGroupConfig, IDHCPConfig)
#endif // VBOX_WITH_XPCOM

