// ##### ENDFILE "CertificateWrap.h"


// ##### BEGINFILE "ApplianceWrap.h"
/** @file
 * VirtualBox API class wrapper header for IAppliance.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#ifndef ApplianceWrap_H_
#define ApplianceWrap_H_
#ifndef RT_WITHOUT_PRAGMA_ONCE
# pragma once
#endif

#include "VirtualBoxBase.h"
#include "Wrapper.h"

class ATL_NO_VTABLE ApplianceWrap
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IAppliance)
{
    Q_OBJECT

public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(ApplianceWrap, IAppliance)
    DECLARE_NOT_AGGREGATABLE(ApplianceWrap)
    DECLARE_PROTECT_FINAL_CONSTRUCT()

    BEGIN_COM_MAP(ApplianceWrap)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IAppliance)
        COM_INTERFACE_ENTRY2(IDispatch, IAppliance)
        VBOX_TWEAK_INTERFACE_ENTRY(IAppliance)
    END_COM_MAP()

    DECLARE_EMPTY_CTOR_DTOR(ApplianceWrap)

    /** @name Public IAppliance properties
     * @{ */
    STDMETHOD(COMGETTER(Path))(BSTR *aPath);
    STDMETHOD(COMGETTER(Disks))(ComSafeArrayOut(BSTR, aDisks));
    STDMETHOD(COMGETTER(VirtualSystemDescriptions))(ComSafeArrayOut(IVirtualSystemDescription *, aVirtualSystemDescriptions));
    STDMETHOD(COMGETTER(Machines))(ComSafeArrayOut(BSTR, aMachines));
    STDMETHOD(COMGETTER(Certificate))(ICertificate **aCertificate);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute1IAppliance))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute2IAppliance))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute3IAppliance))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute4IAppliance))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute5IAppliance))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute6IAppliance))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute7IAppliance))(ULONG *aReserved);
    STDMETHOD(COMGETTER(InternalAndReservedAttribute8IAppliance))(ULONG *aReserved);
    /** @} */

    /** @name Public IAppliance methods
     * @{ */
    STDMETHOD(Read)(IN_BSTR aFile,
                    IProgress **aProgress);
    STDMETHOD(Interpret)();
    STDMETHOD(ImportMachines)(ComSafeArrayIn(ImportOptions_T, aOptions),
                              IProgress **aProgress);
    STDMETHOD(CreateVFSExplorer)(IN_BSTR aURI,
                                 IVFSExplorer **aExplorer);
    STDMETHOD(Write)(IN_BSTR aFormat,
                     ComSafeArrayIn(ExportOptions_T, aOptions),
                     IN_BSTR aPath,
                     IProgress **aProgress);
    STDMETHOD(GetWarnings)(ComSafeArrayOut(BSTR, aWarnings));
    STDMETHOD(GetPasswordIds)(ComSafeArrayOut(BSTR, aIdentifiers));
    STDMETHOD(GetMediumIdsForPasswordId)(IN_BSTR aPasswordId,
                                         ComSafeArrayOut(BSTR, aIdentifiers));
    STDMETHOD(AddPasswords)(ComSafeArrayIn(IN_BSTR, aIdentifiers),
                            ComSafeArrayIn(IN_BSTR, aPasswords));
    STDMETHOD(CreateVirtualSystemDescriptions)(ULONG aRequested,
                                               ULONG *aCreated);
    STDMETHOD(InternalAndReservedMethod1IAppliance)();
    STDMETHOD(InternalAndReservedMethod2IAppliance)();
    STDMETHOD(InternalAndReservedMethod3IAppliance)();
    STDMETHOD(InternalAndReservedMethod4IAppliance)();
    STDMETHOD(InternalAndReservedMethod5IAppliance)();
    STDMETHOD(InternalAndReservedMethod6IAppliance)();
    STDMETHOD(InternalAndReservedMethod7IAppliance)();
    /** @} */

private:
    /** @name Wrapped IAppliance properties
     * @{ */
    virtual HRESULT getPath(com::Utf8Str &aPath) = 0;
    virtual HRESULT getDisks(std::vector<com::Utf8Str> &aDisks) = 0;
    virtual HRESULT getVirtualSystemDescriptions(std::vector<ComPtr<IVirtualSystemDescription> > &aVirtualSystemDescriptions) = 0;
    virtual HRESULT getMachines(std::vector<com::Utf8Str> &aMachines) = 0;
    virtual HRESULT getCertificate(ComPtr<ICertificate> &aCertificate) = 0;
    /** @} */

    /** @name Wrapped IAppliance methods
     * @{ */
    virtual HRESULT read(const com::Utf8Str &aFile,
                         ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT interpret() = 0;
    virtual HRESULT importMachines(const std::vector<ImportOptions_T> &aOptions,
                                   ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT createVFSExplorer(const com::Utf8Str &aURI,
                                      ComPtr<IVFSExplorer> &aExplorer) = 0;
    virtual HRESULT write(const com::Utf8Str &aFormat,
                          const std::vector<ExportOptions_T> &aOptions,
                          const com::Utf8Str &aPath,
                          ComPtr<IProgress> &aProgress) = 0;
    virtual HRESULT getWarnings(std::vector<com::Utf8Str> &aWarnings) = 0;
    virtual HRESULT getPasswordIds(std::vector<com::Utf8Str> &aIdentifiers) = 0;
    virtual HRESULT getMediumIdsForPasswordId(const com::Utf8Str &aPasswordId,
                                              std::vector<com::Guid> &aIdentifiers) = 0;
    virtual HRESULT addPasswords(const std::vector<com::Utf8Str> &aIdentifiers,
                                 const std::vector<com::Utf8Str> &aPasswords) = 0;
    virtual HRESULT createVirtualSystemDescriptions(ULONG aRequested,
                                                    ULONG *aCreated) = 0;
    /** @} */

private:
    DECLARE_CLS_COPY_CTOR_ASSIGN_NOOP(ApplianceWrap); /* Shuts up MSC warning C4625. */

};

#endif // !ApplianceWrap_H_

